/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.FileBasedErrorLogPublisherCfgClient;
import org.opends.server.admin.std.client.LogRetentionPolicyCfgClient;
import org.opends.server.admin.std.client.LogRotationPolicyCfgClient;
import org.opends.server.admin.std.meta.ErrorLogPublisherCfgDefn;
import org.opends.server.admin.std.server.ErrorLogPublisherCfg;
import org.opends.server.admin.std.server.FileBasedErrorLogPublisherCfg;
import org.opends.server.admin.std.server.LogPublisherCfg;
import org.opends.server.admin.std.server.LogRetentionPolicyCfg;
import org.opends.server.admin.std.server.LogRotationPolicyCfg;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileBasedErrorLogPublisherCfgDefn
extends ManagedObjectDefinition<FileBasedErrorLogPublisherCfgClient, FileBasedErrorLogPublisherCfg> {
    private static final FileBasedErrorLogPublisherCfgDefn INSTANCE = new FileBasedErrorLogPublisherCfgDefn();
    private static final BooleanPropertyDefinition PD_APPEND;
    private static final BooleanPropertyDefinition PD_ASYNCHRONOUS;
    private static final BooleanPropertyDefinition PD_AUTO_FLUSH;
    private static final SizePropertyDefinition PD_BUFFER_SIZE;
    private static final ClassPropertyDefinition PD_JAVA_CLASS;
    private static final StringPropertyDefinition PD_LOG_FILE;
    private static final StringPropertyDefinition PD_LOG_FILE_PERMISSIONS;
    private static final IntegerPropertyDefinition PD_QUEUE_SIZE;
    private static final AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> PD_RETENTION_POLICY;
    private static final AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> PD_ROTATION_POLICY;
    private static final DurationPropertyDefinition PD_TIME_INTERVAL;

    public static FileBasedErrorLogPublisherCfgDefn getInstance() {
        return INSTANCE;
    }

    private FileBasedErrorLogPublisherCfgDefn() {
        super("file-based-error-log-publisher", ErrorLogPublisherCfgDefn.getInstance());
    }

    @Override
    public FileBasedErrorLogPublisherCfgClient createClientConfiguration(ManagedObject<? extends FileBasedErrorLogPublisherCfgClient> impl) {
        return new FileBasedErrorLogPublisherCfgClientImpl(impl);
    }

    @Override
    public FileBasedErrorLogPublisherCfg createServerConfiguration(ServerManagedObject<? extends FileBasedErrorLogPublisherCfg> impl) {
        return new FileBasedErrorLogPublisherCfgServerImpl(impl);
    }

    @Override
    public Class<FileBasedErrorLogPublisherCfg> getServerConfigurationClass() {
        return FileBasedErrorLogPublisherCfg.class;
    }

    public BooleanPropertyDefinition getAppendPropertyDefinition() {
        return PD_APPEND;
    }

    public BooleanPropertyDefinition getAsynchronousPropertyDefinition() {
        return PD_ASYNCHRONOUS;
    }

    public BooleanPropertyDefinition getAutoFlushPropertyDefinition() {
        return PD_AUTO_FLUSH;
    }

    public SizePropertyDefinition getBufferSizePropertyDefinition() {
        return PD_BUFFER_SIZE;
    }

    public EnumPropertyDefinition<ErrorLogPublisherCfgDefn.DefaultSeverity> getDefaultSeverityPropertyDefinition() {
        return ErrorLogPublisherCfgDefn.getInstance().getDefaultSeverityPropertyDefinition();
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return ErrorLogPublisherCfgDefn.getInstance().getEnabledPropertyDefinition();
    }

    public ClassPropertyDefinition getJavaClassPropertyDefinition() {
        return PD_JAVA_CLASS;
    }

    public StringPropertyDefinition getLogFilePropertyDefinition() {
        return PD_LOG_FILE;
    }

    public StringPropertyDefinition getLogFilePermissionsPropertyDefinition() {
        return PD_LOG_FILE_PERMISSIONS;
    }

    public StringPropertyDefinition getOverrideSeverityPropertyDefinition() {
        return ErrorLogPublisherCfgDefn.getInstance().getOverrideSeverityPropertyDefinition();
    }

    public IntegerPropertyDefinition getQueueSizePropertyDefinition() {
        return PD_QUEUE_SIZE;
    }

    public AggregationPropertyDefinition<LogRetentionPolicyCfgClient, LogRetentionPolicyCfg> getRetentionPolicyPropertyDefinition() {
        return PD_RETENTION_POLICY;
    }

    public AggregationPropertyDefinition<LogRotationPolicyCfgClient, LogRotationPolicyCfg> getRotationPolicyPropertyDefinition() {
        return PD_ROTATION_POLICY;
    }

    public DurationPropertyDefinition getTimeIntervalPropertyDefinition() {
        return PD_TIME_INTERVAL;
    }

    static {
        PropertyDefinition.AbstractBuilder builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "append");
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "append"));
        DefinedDefaultBehaviorProvider provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_APPEND = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_APPEND);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "asynchronous");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "asynchronous"));
        provider = new DefinedDefaultBehaviorProvider("false");
        builder.setDefaultBehaviorProvider(provider);
        PD_ASYNCHRONOUS = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ASYNCHRONOUS);
        builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "auto-flush");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "auto-flush"));
        provider = new DefinedDefaultBehaviorProvider("true");
        builder.setDefaultBehaviorProvider(provider);
        PD_AUTO_FLUSH = (BooleanPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_AUTO_FLUSH);
        builder = SizePropertyDefinition.createBuilder(INSTANCE, "buffer-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "buffer-size"));
        provider = new DefinedDefaultBehaviorProvider("64kb");
        builder.setDefaultBehaviorProvider(provider);
        ((SizePropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_BUFFER_SIZE = (SizePropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_BUFFER_SIZE);
        builder = ClassPropertyDefinition.createBuilder(INSTANCE, "java-class");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "java-class"));
        provider = new DefinedDefaultBehaviorProvider("org.opends.server.loggers.TextErrorLogPublisher");
        builder.setDefaultBehaviorProvider(provider);
        ((ClassPropertyDefinition.Builder)builder).addInstanceOf("org.opends.server.api.ErrorLogPublisher");
        PD_JAVA_CLASS = (ClassPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_JAVA_CLASS);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.COMPONENT_RESTART, INSTANCE, "log-file"));
        builder.setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_LOG_FILE = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "log-file-permissions");
        builder.setOption(PropertyOption.MANDATORY);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "log-file-permissions"));
        provider = new DefinedDefaultBehaviorProvider("640");
        builder.setDefaultBehaviorProvider(provider);
        ((StringPropertyDefinition.Builder)builder).setPattern("^([0-7][0-7][0-7])$", "MODE");
        PD_LOG_FILE_PERMISSIONS = (StringPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_LOG_FILE_PERMISSIONS);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "queue-size");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "queue-size"));
        provider = new DefinedDefaultBehaviorProvider("5000");
        builder.setDefaultBehaviorProvider(provider);
        ((IntegerPropertyDefinition.Builder)builder).setLowerLimit(1);
        PD_QUEUE_SIZE = (IntegerPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_QUEUE_SIZE);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "retention-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "retention-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "retention-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-retention-policy");
        PD_RETENTION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_RETENTION_POLICY);
        INSTANCE.registerConstraint(PD_RETENTION_POLICY.getSourceConstraint());
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "rotation-policy");
        builder.setOption(PropertyOption.MULTI_VALUED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "rotation-policy"));
        builder.setDefaultBehaviorProvider(new AliasDefaultBehaviorProvider(INSTANCE, "rotation-policy"));
        ((AggregationPropertyDefinition.Builder)builder).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)builder).setRelationDefinition("log-rotation-policy");
        PD_ROTATION_POLICY = (AggregationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_ROTATION_POLICY);
        INSTANCE.registerConstraint(PD_ROTATION_POLICY.getSourceConstraint());
        builder = DurationPropertyDefinition.createBuilder(INSTANCE, "time-interval");
        builder.setOption(PropertyOption.ADVANCED);
        builder.setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "time-interval"));
        provider = new DefinedDefaultBehaviorProvider("5s");
        builder.setDefaultBehaviorProvider(provider);
        ((DurationPropertyDefinition.Builder)builder).setBaseUnit("ms");
        ((DurationPropertyDefinition.Builder)builder).setLowerLimit("1");
        PD_TIME_INTERVAL = (DurationPropertyDefinition)builder.getInstance();
        INSTANCE.registerPropertyDefinition(PD_TIME_INTERVAL);
        INSTANCE.registerTag(Tag.valueOf("logging"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileBasedErrorLogPublisherCfgServerImpl
    implements FileBasedErrorLogPublisherCfg {
        private ServerManagedObject<? extends FileBasedErrorLogPublisherCfg> impl;
        private final boolean pAppend;
        private final boolean pAsynchronous;
        private final boolean pAutoFlush;
        private final long pBufferSize;
        private final SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> pDefaultSeverity;
        private final boolean pEnabled;
        private final String pJavaClass;
        private final String pLogFile;
        private final String pLogFilePermissions;
        private final SortedSet<String> pOverrideSeverity;
        private final int pQueueSize;
        private final SortedSet<String> pRetentionPolicy;
        private final SortedSet<String> pRotationPolicy;
        private final long pTimeInterval;

        private FileBasedErrorLogPublisherCfgServerImpl(ServerManagedObject<? extends FileBasedErrorLogPublisherCfg> impl) {
            this.impl = impl;
            this.pAppend = impl.getPropertyValue(INSTANCE.getAppendPropertyDefinition());
            this.pAsynchronous = impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
            this.pAutoFlush = impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
            this.pBufferSize = impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
            this.pDefaultSeverity = impl.getPropertyValues(INSTANCE.getDefaultSeverityPropertyDefinition());
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pJavaClass = impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
            this.pLogFile = impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
            this.pLogFilePermissions = impl.getPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition());
            this.pOverrideSeverity = impl.getPropertyValues((PropertyDefinition)INSTANCE.getOverrideSeverityPropertyDefinition());
            this.pQueueSize = impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
            this.pRetentionPolicy = impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
            this.pRotationPolicy = impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
            this.pTimeInterval = impl.getPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition());
        }

        @Override
        public void addFileBasedErrorChangeListener(ConfigurationChangeListener<FileBasedErrorLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeFileBasedErrorChangeListener(ConfigurationChangeListener<FileBasedErrorLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addErrorChangeListener(ConfigurationChangeListener<ErrorLogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeErrorChangeListener(ConfigurationChangeListener<ErrorLogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<LogPublisherCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isAppend() {
            return this.pAppend;
        }

        @Override
        public boolean isAsynchronous() {
            return this.pAsynchronous;
        }

        @Override
        public boolean isAutoFlush() {
            return this.pAutoFlush;
        }

        @Override
        public long getBufferSize() {
            return this.pBufferSize;
        }

        @Override
        public SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> getDefaultSeverity() {
            return this.pDefaultSeverity;
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getJavaClass() {
            return this.pJavaClass;
        }

        @Override
        public String getLogFile() {
            return this.pLogFile;
        }

        @Override
        public String getLogFilePermissions() {
            return this.pLogFilePermissions;
        }

        @Override
        public SortedSet<String> getOverrideSeverity() {
            return this.pOverrideSeverity;
        }

        @Override
        public int getQueueSize() {
            return this.pQueueSize;
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.pRetentionPolicy;
        }

        @Override
        public SortedSet<DN> getRetentionPolicyDNs() {
            SortedSet<String> values = this.getRetentionPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRetentionPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.pRotationPolicy;
        }

        @Override
        public SortedSet<DN> getRotationPolicyDNs() {
            SortedSet<String> values = this.getRotationPolicy();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getRotationPolicyPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public long getTimeInterval() {
            return this.pTimeInterval;
        }

        @Override
        public Class<? extends FileBasedErrorLogPublisherCfg> configurationClass() {
            return FileBasedErrorLogPublisherCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileBasedErrorLogPublisherCfgClientImpl
    implements FileBasedErrorLogPublisherCfgClient {
        private ManagedObject<? extends FileBasedErrorLogPublisherCfgClient> impl;

        private FileBasedErrorLogPublisherCfgClientImpl(ManagedObject<? extends FileBasedErrorLogPublisherCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public boolean isAppend() {
            return this.impl.getPropertyValue(INSTANCE.getAppendPropertyDefinition());
        }

        @Override
        public void setAppend(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAppendPropertyDefinition(), value);
        }

        @Override
        public boolean isAsynchronous() {
            return this.impl.getPropertyValue(INSTANCE.getAsynchronousPropertyDefinition());
        }

        @Override
        public void setAsynchronous(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAsynchronousPropertyDefinition(), value);
        }

        @Override
        public boolean isAutoFlush() {
            return this.impl.getPropertyValue(INSTANCE.getAutoFlushPropertyDefinition());
        }

        @Override
        public void setAutoFlush(Boolean value) {
            this.impl.setPropertyValue(INSTANCE.getAutoFlushPropertyDefinition(), value);
        }

        @Override
        public long getBufferSize() {
            return this.impl.getPropertyValue(INSTANCE.getBufferSizePropertyDefinition());
        }

        @Override
        public void setBufferSize(Long value) {
            this.impl.setPropertyValue(INSTANCE.getBufferSizePropertyDefinition(), value);
        }

        @Override
        public SortedSet<ErrorLogPublisherCfgDefn.DefaultSeverity> getDefaultSeverity() {
            return this.impl.getPropertyValues(INSTANCE.getDefaultSeverityPropertyDefinition());
        }

        @Override
        public void setDefaultSeverity(Collection<ErrorLogPublisherCfgDefn.DefaultSeverity> values) {
            this.impl.setPropertyValues(INSTANCE.getDefaultSeverityPropertyDefinition(), values);
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getJavaClass() {
            return this.impl.getPropertyValue(INSTANCE.getJavaClassPropertyDefinition());
        }

        @Override
        public void setJavaClass(String value) {
            this.impl.setPropertyValue(INSTANCE.getJavaClassPropertyDefinition(), value);
        }

        @Override
        public String getLogFile() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePropertyDefinition());
        }

        @Override
        public void setLogFile(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePropertyDefinition(), value);
        }

        @Override
        public String getLogFilePermissions() {
            return this.impl.getPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition());
        }

        @Override
        public void setLogFilePermissions(String value) {
            this.impl.setPropertyValue(INSTANCE.getLogFilePermissionsPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getOverrideSeverity() {
            return this.impl.getPropertyValues(INSTANCE.getOverrideSeverityPropertyDefinition());
        }

        @Override
        public void setOverrideSeverity(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getOverrideSeverityPropertyDefinition(), values);
        }

        @Override
        public int getQueueSize() {
            return this.impl.getPropertyValue(INSTANCE.getQueueSizePropertyDefinition());
        }

        @Override
        public void setQueueSize(Integer value) {
            this.impl.setPropertyValue(INSTANCE.getQueueSizePropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getRetentionPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition());
        }

        @Override
        public void setRetentionPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRetentionPolicyPropertyDefinition(), values);
        }

        @Override
        public SortedSet<String> getRotationPolicy() {
            return this.impl.getPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition());
        }

        @Override
        public void setRotationPolicy(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getRotationPolicyPropertyDefinition(), values);
        }

        @Override
        public long getTimeInterval() {
            return this.impl.getPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition());
        }

        @Override
        public void setTimeInterval(Long value) {
            this.impl.setPropertyValue(INSTANCE.getTimeIntervalPropertyDefinition(), value);
        }

        @Override
        public ManagedObjectDefinition<? extends FileBasedErrorLogPublisherCfgClient, ? extends FileBasedErrorLogPublisherCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

