/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.condition;

import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.condition.ANDCondition;
import org.opends.server.admin.condition.Condition;
import org.opends.server.admin.condition.ContainsCondition;
import org.opends.server.admin.condition.IsPresentCondition;
import org.opends.server.admin.condition.NOTCondition;
import org.opends.server.admin.condition.ORCondition;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.config.ConfigException;

public final class Conditions {
    public static final Condition FALSE = new Condition(){

        @Override
        public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws AuthorizationException, CommunicationException {
            return false;
        }

        @Override
        public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
            return false;
        }

        @Override
        public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        }
    };
    public static final Condition TRUE = new Condition(){

        @Override
        public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws AuthorizationException, CommunicationException {
            return true;
        }

        @Override
        public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
            return true;
        }

        @Override
        public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        }
    };

    public static Condition and(Condition ... conditions) {
        return new ANDCondition(conditions);
    }

    public static Condition contains(String propertyName, String propertyStringValue) {
        return new ContainsCondition(propertyName, propertyStringValue);
    }

    public static Condition implies(Condition premise, Condition implication) {
        return Conditions.or(Conditions.not(premise), implication);
    }

    public static Condition isPresent(String propertyName) {
        return new IsPresentCondition(propertyName);
    }

    public static Condition not(Condition condition) {
        return new NOTCondition(condition);
    }

    public static Condition or(Condition ... conditions) {
        return new ORCondition(conditions);
    }

    private Conditions() {
    }
}

