/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.SortedSet;
import org.opends.messages.Message;
import org.opends.server.admin.AbsoluteInheritedDefaultBehaviorProvider;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AliasDefaultBehaviorProvider;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.Constraint;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefaultBehaviorProviderVisitor;
import org.opends.server.admin.DefinedDefaultBehaviorProvider;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.PropertyIsSingleValuedException;
import org.opends.server.admin.PropertyNotFoundException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.RelativeInheritedDefaultBehaviorProvider;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.ClientConstraintHandler;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.std.client.RootCfgClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Driver {
    protected Driver() {
    }

    public void close() {
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, InstantiableRelationDefinition<C, S> rd, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(parent, rd);
        ManagedObjectPath<C, S> child = parent.child(rd, name);
        return this.doDeleteManagedObject(child);
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, OptionalRelationDefinition<C, S> rd) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(parent, rd);
        ManagedObjectPath<C, S> child = parent.child(rd);
        return this.doDeleteManagedObject(child);
    }

    public final <C extends ConfigurationClient, S extends Configuration> boolean deleteManagedObject(ManagedObjectPath<?, ?> parent, SetRelationDefinition<C, S> rd, String name) throws IllegalArgumentException, ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        this.validateRelationDefinition(parent, rd);
        ManagedObjectPath<C, S> child = parent.child(rd, name);
        return this.doDeleteManagedObject(child);
    }

    public abstract <C extends ConfigurationClient, S extends Configuration> ManagedObject<? extends C> getManagedObject(ManagedObjectPath<C, S> var1) throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException;

    public abstract <C extends ConfigurationClient, S extends Configuration, PD> SortedSet<PD> getPropertyValues(ManagedObjectPath<C, S> var1, PropertyDefinition<PD> var2) throws IllegalArgumentException, DefinitionDecodingException, AuthorizationException, ManagedObjectNotFoundException, CommunicationException, PropertyException;

    public abstract ManagedObject<RootCfgClient> getRootConfigurationManagedObject();

    public abstract <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> var1, InstantiableRelationDefinition<C, S> var2, AbstractManagedObjectDefinition<? extends C, ? extends S> var3) throws IllegalArgumentException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException;

    public abstract <C extends ConfigurationClient, S extends Configuration> String[] listManagedObjects(ManagedObjectPath<?, ?> var1, SetRelationDefinition<C, S> var2, AbstractManagedObjectDefinition<? extends C, ? extends S> var3) throws IllegalArgumentException, ManagedObjectNotFoundException, AuthorizationException, CommunicationException;

    public abstract boolean managedObjectExists(ManagedObjectPath<?, ?> var1) throws ManagedObjectNotFoundException, AuthorizationException, CommunicationException;

    protected abstract <C extends ConfigurationClient, S extends Configuration> void deleteManagedObject(ManagedObjectPath<C, S> var1) throws OperationRejectedException, AuthorizationException, CommunicationException;

    protected final <PD> Collection<PD> findDefaultValues(ManagedObjectPath<?, ?> p, PropertyDefinition<PD> pd, boolean isCreate) throws DefaultBehaviorException {
        DefaultValueFinder v = new DefaultValueFinder(p, isCreate);
        return v.find(p, pd);
    }

    protected abstract ManagementContext getManagementContext();

    protected final void validateRelationDefinition(ManagedObjectPath<?, ?> path, RelationDefinition<?, ?> rd) throws IllegalArgumentException {
        AbstractManagedObjectDefinition<?, ?> d = path.getManagedObjectDefinition();
        RelationDefinition<?, ?> tmp = d.getRelationDefinition(rd.getName());
        if (tmp != rd) {
            throw new IllegalArgumentException("The relation " + rd.getName() + " is not associated with a " + d.getName());
        }
    }

    private <C extends ConfigurationClient, S extends Configuration> boolean doDeleteManagedObject(ManagedObjectPath<C, S> path) throws ManagedObjectNotFoundException, OperationRejectedException, AuthorizationException, CommunicationException {
        if (!this.managedObjectExists(path.parent())) {
            throw new ManagedObjectNotFoundException();
        }
        if (!this.managedObjectExists(path)) {
            return false;
        }
        AbstractManagedObjectDefinition<C, S> d = path.getManagedObjectDefinition();
        LinkedList<Message> messages = new LinkedList<Message>();
        boolean isAcceptable = true;
        for (Constraint constraint : d.getAllConstraints()) {
            for (ClientConstraintHandler handler : constraint.getClientConstraintHandlers()) {
                ManagementContext context;
                if (handler.isDeleteAcceptable(context = this.getManagementContext(), path, messages)) continue;
                isAcceptable = false;
            }
            if (isAcceptable) continue;
            break;
        }
        if (!isAcceptable) {
            throw new OperationRejectedException(OperationRejectedException.OperationType.DELETE, d.getUserFriendlyName(), messages);
        }
        this.deleteManagedObject(path);
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultValueFinder<T>
    implements DefaultBehaviorProviderVisitor<T, Collection<T>, Void> {
        private DefaultBehaviorException exception = null;
        private final ManagedObjectPath<?, ?> firstPath;
        private final boolean isCreate;
        private ManagedObjectPath<?, ?> nextPath = null;
        private PropertyDefinition<T> nextProperty = null;

        private DefaultValueFinder(ManagedObjectPath<?, ?> p, boolean isCreate) {
            this.firstPath = p;
            this.isCreate = isCreate;
        }

        @Override
        public Collection<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitAlias(AliasDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        @Override
        public Collection<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, Void p) {
            Collection<String> stringValues = d.getDefaultValues();
            ArrayList<T> values = new ArrayList<T>(stringValues.size());
            for (String stringValue : stringValues) {
                try {
                    values.add(this.nextProperty.decodeValue(stringValue));
                }
                catch (IllegalPropertyValueStringException e) {
                    this.exception = new DefaultBehaviorException(this.nextProperty, (Throwable)e);
                    break;
                }
            }
            return values;
        }

        @Override
        public Collection<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, Void p) {
            try {
                return this.getInheritedProperty(d.getManagedObjectPath(this.nextPath), d.getManagedObjectDefinition(), d.getPropertyName());
            }
            catch (DefaultBehaviorException e) {
                this.exception = e;
                return Collections.emptySet();
            }
        }

        @Override
        public Collection<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, Void p) {
            return Collections.emptySet();
        }

        private Collection<T> find(ManagedObjectPath<?, ?> p, PropertyDefinition<T> pd) throws DefaultBehaviorException {
            this.nextPath = p;
            this.nextProperty = pd;
            Collection values = (Collection)this.nextProperty.getDefaultBehaviorProvider().accept(this, null);
            if (this.exception != null) {
                throw this.exception;
            }
            if (values.size() > 1 && !pd.hasOption(PropertyOption.MULTI_VALUED)) {
                throw new DefaultBehaviorException(pd, (Throwable)new PropertyIsSingleValuedException(pd));
            }
            return values;
        }

        private Collection<T> getInheritedProperty(ManagedObjectPath target, AbstractManagedObjectDefinition<?, ?> d, String propertyName) throws DefaultBehaviorException {
            AbstractManagedObjectDefinition supr = target.getManagedObjectDefinition();
            if (!supr.isParentOf(d)) {
                throw new DefaultBehaviorException(this.nextProperty, (Throwable)new DefinitionDecodingException(supr, DefinitionDecodingException.Reason.WRONG_TYPE_INFORMATION));
            }
            PropertyDefinition<T> pd1 = this.nextProperty;
            try {
                PropertyDefinition pd2;
                try {
                    PropertyDefinition<?> pdTmp = d.getPropertyDefinition(propertyName);
                    pd2 = (PropertyDefinition)pd1.getClass().cast(pdTmp);
                }
                catch (IllegalArgumentException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                catch (ClassCastException e) {
                    throw new PropertyNotFoundException(propertyName);
                }
                if (this.isCreate && this.firstPath.equals(target)) {
                    Collection<T> tmp = this.find(target, pd2);
                    ArrayList<T> values = new ArrayList<T>(tmp.size());
                    for (T value : tmp) {
                        pd1.validateValue(value);
                        values.add(value);
                    }
                    return values;
                }
                return Driver.this.getPropertyValues(target, pd2);
            }
            catch (DefaultBehaviorException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (DefinitionDecodingException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (PropertyNotFoundException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (AuthorizationException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (ManagedObjectNotFoundException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (CommunicationException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
            catch (PropertyException e) {
                throw new DefaultBehaviorException(pd1, (Throwable)e);
            }
        }
    }
}

