/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.client;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.opends.messages.AdminMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.DecodingException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedObjectDecodingException
extends DecodingException {
    private static final long serialVersionUID = -4268510652395945357L;
    private final Collection<PropertyException> causes;
    private final ManagedObject<?> partialManagedObject;

    private static Message createMessage(ManagedObject<?> partialManagedObject, Collection<PropertyException> causes) {
        Validator.ensureNotNull(causes);
        Validator.ensureTrue(!causes.isEmpty());
        ManagedObjectDefinition<?, Configuration> d = partialManagedObject.getManagedObjectDefinition();
        if (causes.size() == 1) {
            return AdminMessages.ERR_MANAGED_OBJECT_DECODING_EXCEPTION_SINGLE.get(d.getUserFriendlyName(), causes.iterator().next().getMessageObject());
        }
        MessageBuilder builder = new MessageBuilder();
        boolean isFirst = true;
        for (PropertyException cause : causes) {
            if (!isFirst) {
                builder.append("; ");
            }
            builder.append(cause.getMessageObject());
            isFirst = false;
        }
        return AdminMessages.ERR_MANAGED_OBJECT_DECODING_EXCEPTION_PLURAL.get(d.getUserFriendlyName(), builder.toMessage());
    }

    public ManagedObjectDecodingException(ManagedObject<?> partialManagedObject, Collection<PropertyException> causes) {
        super(ManagedObjectDecodingException.createMessage(partialManagedObject, causes));
        this.partialManagedObject = partialManagedObject;
        this.causes = Collections.unmodifiableList(new LinkedList<PropertyException>(causes));
    }

    public Collection<PropertyException> getCauses() {
        return this.causes;
    }

    public ManagedObject<?> getPartialManagedObject() {
        return this.partialManagedObject;
    }
}

