/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.net.InetAddress;
import org.opends.server.admin.ACIPropertyDefinition;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DNPropertyDefinition;
import org.opends.server.admin.DurationPropertyDefinition;
import org.opends.server.admin.EnumPropertyDefinition;
import org.opends.server.admin.IPAddressMaskPropertyDefinition;
import org.opends.server.admin.IPAddressPropertyDefinition;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.SizePropertyDefinition;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.UnknownPropertyDefinitionException;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.types.AddressMask;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertyValueVisitor<R, P> {
    protected PropertyValueVisitor() {
    }

    public R visitACI(ACIPropertyDefinition pd, Aci v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public <C extends ConfigurationClient, S extends Configuration> R visitAggregation(AggregationPropertyDefinition<C, S> pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitAttributeType(AttributeTypePropertyDefinition pd, AttributeType v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitBoolean(BooleanPropertyDefinition pd, Boolean v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitClass(ClassPropertyDefinition pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitDN(DNPropertyDefinition pd, DN v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitDuration(DurationPropertyDefinition pd, Long v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public <E extends Enum<E>> R visitEnum(EnumPropertyDefinition<E> pd, E v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitInteger(IntegerPropertyDefinition pd, Integer v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitIPAddress(IPAddressPropertyDefinition pd, InetAddress v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitIPAddressMask(IPAddressMaskPropertyDefinition pd, AddressMask v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitSize(SizePropertyDefinition pd, Long v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public R visitString(StringPropertyDefinition pd, String v, P p) {
        return this.visitUnknown(pd, v, p);
    }

    public <T> R visitUnknown(PropertyDefinition<T> pd, T v, P p) throws UnknownPropertyDefinitionException {
        throw new UnknownPropertyDefinitionException(pd, p);
    }
}

