/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class StandardOutputSuppressor {
    private static Token token = null;

    public static synchronized void suppress() {
        if (token != null) {
            throw new IllegalStateException("Standard streams currently suppressed");
        }
        token = new Token();
        StandardOutputSuppressor.token.out = System.out;
        StandardOutputSuppressor.token.err = System.err;
        System.out.flush();
        System.err.flush();
        System.setOut(new PrintStream(new NullOutputStream()));
        System.setErr(new PrintStream(new NullOutputStream()));
    }

    public static synchronized void unsuppress() {
        if (token == null) {
            throw new IllegalStateException("Standard streams not currently suppressed");
        }
        System.setOut(StandardOutputSuppressor.token.out);
        System.setErr(StandardOutputSuppressor.token.err);
        token = null;
    }

    public static boolean isSuppressed() {
        return token != null;
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }

    private static class Token {
        PrintStream out;
        PrintStream err;

        private Token() {
        }
    }
}

