/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;
import java.util.Set;
import org.opends.quicksetup.upgrader.Upgrader;
import org.opends.quicksetup.util.Utils;

class UpgradeFileFilter
implements FileFilter {
    private Utils.Dir dir;
    private Set<File> installDirFileList;
    Set<File> filesToIgnore = new HashSet<File>();

    public UpgradeFileFilter(File root) {
        for (String rootFileNamesToIgnore : Upgrader.ROOT_FILES_TO_IGNORE_DURING_BACKUP) {
            this.filesToIgnore.add(new File(root, rootFileNamesToIgnore));
        }
        for (String rootFileNamesToIgnore : Upgrader.FILES_TO_IGNORE_DURING_BACKUP) {
            this.filesToIgnore.add(new File(root, rootFileNamesToIgnore));
        }
        this.dir = Utils.Dir.ALL;
        this.installDirFileList = null;
    }

    public UpgradeFileFilter(File root, boolean forInstallDir) {
        this(root);
        this.dir = forInstallDir ? Utils.Dir.INSTALL : Utils.Dir.INSTANCE;
        this.installDirFileList = new HashSet<File>();
        for (String rootInstallDirFile : Upgrader.ROOT_FILE_FOR_INSTALL_DIR) {
            this.installDirFileList.add(new File(root, rootInstallDirFile));
        }
    }

    public boolean accept(File file) {
        boolean accept = true;
        for (File ignoreFile : this.filesToIgnore) {
            if (!ignoreFile.equals(file) && !Utils.isParentOf(ignoreFile, file)) continue;
            accept = false;
            break;
        }
        if (!accept || this.dir.compareTo(Utils.Dir.ALL) == 0) {
            return accept;
        }
        if (this.dir.compareTo(Utils.Dir.INSTALL) == 0) {
            accept = false;
            for (File installDirFile : this.installDirFileList) {
                if (!installDirFile.equals(file) && !Utils.isParentOf(installDirFile, file)) continue;
                accept = true;
                break;
            }
        } else if (this.dir.compareTo(Utils.Dir.INSTANCE) == 0) {
            for (File installDirFile : this.installDirFileList) {
                if (!installDirFile.equals(file) && !Utils.isParentOf(installDirFile, file)) continue;
                accept = false;
                break;
            }
        } else {
            accept = false;
        }
        return accept;
    }
}

