/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.upgrader;

import java.net.URL;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Build
implements Comparable<Build> {
    private URL downloadUrl;
    private String displayName;
    private Category category;

    Build(String displayName, URL downloadUrl, Category category) {
        this.displayName = displayName;
        this.downloadUrl = downloadUrl;
        this.category = category;
    }

    public URL getUrl() {
        return this.downloadUrl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Category getCategory() {
        return this.category;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int compareTo(Build o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int c = this.getCategory().compareTo(o.getCategory());
        if (c == 0) {
            c = this.getDisplayName().compareTo(o.getDisplayName());
        }
        return c;
    }

    public int hashCode() {
        String disp;
        int hc = 11;
        Category cat = this.getCategory();
        if (cat != null) {
            hc = 31 * hc + cat.hashCode();
        }
        if ((disp = this.getDisplayName()) != null) {
            hc = 31 * hc + disp.hashCode();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        boolean eq = false;
        if (obj != null && obj instanceof Build) {
            Category thisCat = this.getCategory();
            Category thatCat = ((Build)obj).getCategory();
            if (thisCat != null && thisCat.equals((Object)thatCat) || thisCat == null && thatCat == null) {
                String thisDisp = this.getDisplayName();
                String thatDisp = ((Build)obj).getDisplayName();
                eq = thisDisp != null && thisDisp.equals(thatDisp) || thisDisp == null && thatDisp == null;
            }
        }
        return eq;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Category {
        DAILY("Daily Build"),
        WEEKLY("Weekly Build"),
        RELEASE("Release Build");

        String key;

        public static Category fromString(String s) {
            Category category = null;
            for (Category c : EnumSet.allOf(Category.class)) {
                if (!c.key.equals(s)) continue;
                category = c;
                break;
            }
            return category;
        }

        private Category(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

