/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.UserInteraction;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiUserInteraction
implements UserInteraction {
    private Component parent = null;

    public GuiUserInteraction(Component parent) {
        this.parent = parent;
    }

    @Override
    public Object confirm(Message summary, Message details, Message title, UserInteraction.MessageType type, Message[] options, Message def) {
        return this.confirm(summary, details, null, title, type, options, def, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object confirm(Message summary, Message details, Message fineDetails, Message title, UserInteraction.MessageType type, Message[] options, Message def, Message viewDetailsOption) {
        int msgType;
        int optionType;
        if (options == null) throw new NullPointerException("options cannot be null");
        if (options.length == 2) {
            optionType = 0;
        } else {
            if (options.length != 3) throw new IllegalArgumentException("unsupported number of options: " + options.length);
            optionType = 1;
        }
        switch (type) {
            case PLAIN: {
                msgType = -1;
                break;
            }
            case ERROR: {
                msgType = 0;
                break;
            }
            case INFORMATION: {
                msgType = 1;
                break;
            }
            case WARNING: {
                msgType = 2;
                break;
            }
            case QUESTION: {
                msgType = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported MessageType");
            }
        }
        MaxCharactersPerLineOptionPane op = fineDetails != null ? new DetailsOptionPane(100, fineDetails) : new MaxCharactersPerLineOptionPane(100);
        MessageBuilder sb = new MessageBuilder();
        sb.append("<b>");
        sb.append(Utils.breakHtmlString(summary, 100));
        sb.append("</b>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append(Utils.breakHtmlString(details, 100));
        JEditorPane ep = UIFactory.makeHtmlPane(sb.toMessage(), UIFactory.INSTRUCTIONS_FONT);
        ep.setBorder(BorderFactory.createEmptyBorder(0, 0, 20, 0));
        op.setMessage(ep);
        op.setOptionType(optionType);
        op.setMessageType(msgType);
        op.setOptions(options);
        op.setInitialValue(def);
        JDialog dlg = op.createDialog(this.parent, String.valueOf(title));
        dlg.setVisible(true);
        return op.getValue();
    }

    @Override
    public String createUnorderedList(List<?> list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            sb.append(Constants.HTML_UNORDERED_LIST_OPEN);
            for (Object o : list) {
                sb.append("<li>");
                sb.append(o.toString());
                sb.append("</li>");
            }
            sb.append(Constants.HTML_UNORDERED_LIST_CLOSE);
        }
        return sb.toString();
    }

    @Override
    public String promptForString(Message prompt, Message title, String defaultValue) {
        Object o = JOptionPane.showInputDialog(this.parent, prompt.toString(), title.toString(), 3, null, null, defaultValue);
        return o != null ? o.toString() : null;
    }

    @Override
    public boolean isCLI() {
        return false;
    }

    private class DetailsOptionPane
    extends MaxCharactersPerLineOptionPane {
        static final long serialVersionUID = -7813059467702205272L;
        private static final int MAX_DETAILS_COMPONENT_HEIGHT = 200;
        private boolean detailsShowing;
        private Component detailsComponent;
        private JDialog dialog;

        public DetailsOptionPane(int maxCharactersPerLine, Message details) {
            super(maxCharactersPerLine);
            this.detailsShowing = false;
            this.detailsComponent = this.createDetailsComponent(details);
        }

        public Component add(Component comp) {
            if ("OptionPane.buttonArea".equals(comp.getName())) {
                JPanel detailsButtonsPanel = new JPanel();
                detailsButtonsPanel.setLayout(new BoxLayout(detailsButtonsPanel, 2));
                final Message showDetailsLabel = QuickSetupMessages.INFO_SHOW_DETAILS_BUTTON_LABEL.get();
                final Message hideDetailsLabel = QuickSetupMessages.INFO_HIDE_DETAILS_BUTTON_LABEL.get();
                final JButton btnDetails = new JButton(showDetailsLabel.toString());
                btnDetails.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Dimension current = DetailsOptionPane.this.dialog.getSize();
                        if (!DetailsOptionPane.this.detailsShowing) {
                            DetailsOptionPane.this.dialog.setSize(current.width, current.height + DetailsOptionPane.this.getExpansionHeight());
                            btnDetails.setText(hideDetailsLabel.toString());
                        } else {
                            DetailsOptionPane.this.dialog.setSize(current.width, current.height - DetailsOptionPane.this.getExpansionHeight());
                            btnDetails.setText(showDetailsLabel.toString());
                        }
                        DetailsOptionPane.this.detailsShowing = !DetailsOptionPane.this.detailsShowing;
                    }
                });
                JPanel detailsBottom = new JPanel();
                Border border = UIManager.getBorder("OptionPane.buttonAreaBorder");
                if (border != null) {
                    detailsBottom.setBorder(border);
                }
                detailsBottom.setLayout(new BasicOptionPaneUI.ButtonAreaLayout(UIManager.getBoolean("OptionPane.sameSizeButtons"), UIManager.getInt("OptionPane.buttonPadding")));
                detailsBottom.add(btnDetails);
                detailsButtonsPanel.add(detailsBottom);
                detailsButtonsPanel.add(Box.createHorizontalGlue());
                detailsButtonsPanel.add(comp);
                super.add(detailsButtonsPanel);
            } else {
                super.add(comp);
            }
            return comp;
        }

        public JDialog createDialog(Component parentComponent, String title) throws HeadlessException {
            this.dialog = super.createDialog(parentComponent, title);
            Dimension d = this.dialog.getSize();
            this.add(this.detailsComponent);
            this.dialog.pack();
            this.dialog.setSize(d);
            return this.dialog;
        }

        private Component createDetailsComponent(Message details) {
            JPanel detailsPanel = new JPanel();
            detailsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(15, 0, 0, 0);
            gbc.fill = 2;
            detailsPanel.add((Component)UIFactory.makeJLabel(null, QuickSetupMessages.INFO_DETAILS_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID), gbc);
            gbc.insets.top = 10;
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            JEditorPane ep = Utils.containsHtml(String.valueOf(details)) ? UIFactory.makeHtmlPane(details, UIFactory.INSTRUCTIONS_FONT) : UIFactory.makeTextPane(details, UIFactory.TextStyle.INSTRUCTIONS);
            ep.setOpaque(false);
            detailsPanel.add((Component)new JScrollPane(ep), gbc);
            return detailsPanel;
        }

        private int getExpansionHeight() {
            return (int)Math.min(this.detailsComponent.getPreferredSize().getHeight(), 200.0);
        }
    }

    private class MaxCharactersPerLineOptionPane
    extends JOptionPane {
        static final long serialVersionUID = 8984664928623358120L;
        private int maxCharactersPerLineCount;

        public MaxCharactersPerLineOptionPane(int maxCharactersPerLine) {
            this.maxCharactersPerLineCount = maxCharactersPerLine;
        }

        public int getMaxCharactersPerLineCount() {
            return this.maxCharactersPerLineCount;
        }
    }
}

