/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.Utils;

public class DirectoryManagerAuthenticationDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(DirectoryManagerAuthenticationDialog.class.getName());
    private static final long serialVersionUID = 9049409381101152000L;
    private JFrame parent;
    private JLabel lDn;
    private JLabel lPwd;
    private JTextField tfDn;
    private JTextField tfPwd;
    private JButton cancelButton;
    private JButton shutDownButton;
    private boolean isCancelled;
    private boolean isServerRunning;

    public DirectoryManagerAuthenticationDialog(JFrame parent) {
        super(parent);
        this.setTitle(QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_DIALOG_TITLE.get().toString());
        this.parent = parent;
        this.getContentPane().add(this.createPanel());
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void packAndShow() {
        this.setPreferredSize(new Dimension(500, 300));
        this.addComponentListener(new MinimumSizeComponentListener(this, 500, 300));
        this.getRootPane().setDefaultButton(this.shutDownButton);
        this.pack();
        Utilities.centerOnComponent(this, this.parent);
        this.tfPwd.requestFocusInWindow();
        this.setVisible(true);
    }

    public boolean getStopServer() {
        return this.isServerRunning;
    }

    public String getDirectoryManagerDn() {
        return this.tfDn.getText();
    }

    public String getDirectoryManagerPwd() {
        return this.tfPwd.getText();
    }

    private JPanel createPanel() {
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)UIFactory.makeJLabel(UIFactory.IconType.INFORMATION_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        Message msg = QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_DIALOG_MSG.get();
        JEditorPane textPane = UIFactory.makeHtmlPane(msg, UIFactory.INSTRUCTIONS_FONT);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        p1.add((Component)textPane, gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setOpaque(false);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.lDn = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_DN_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lDn, gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        this.tfDn = UIFactory.makeJTextField(Message.raw(this.getProposedDirectoryManagerDn(), new Object[0]), QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_DN_TOOLTIP.get(), 20, UIFactory.TextStyle.TEXTFIELD);
        p2.add((Component)this.tfDn, gbc);
        gbc.insets.top = 0;
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.lPwd = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_PWD_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lPwd, gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.fill = 0;
        gbc.gridwidth = 0;
        JPanel p3 = new JPanel(new GridBagLayout());
        p3.setOpaque(false);
        this.tfPwd = UIFactory.makeJPasswordField(null, QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_PWD_TOOLTIP.get(), 15, UIFactory.TextStyle.PASSWORD_FIELD);
        p2.add((Component)this.tfPwd, gbc);
        p2.add((Component)p3, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        p3.add((Component)this.tfPwd, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p3.add(Box.createHorizontalGlue(), gbc);
        gbc.fill = 2;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 0;
        p1.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        p1.add((Component)p2, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 3;
        p1.add(Box.createVerticalGlue(), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 3;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.shutDownButton = UIFactory.makeJButton(QuickSetupMessages.INFO_SHUTDOWN_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_SHUTDOWN_BUTTON_TOOLTIP.get());
        buttonPanel.add((Component)this.shutDownButton, gbc);
        this.shutDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DirectoryManagerAuthenticationDialog.this.shutDownClicked();
            }
        });
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        this.cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), QuickSetupMessages.INFO_SHUTDOWN_DIRECTORY_MANAGER_CANCEL_BUTTON_TOOLTIP.get());
        buttonPanel.add((Component)this.cancelButton, gbc);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DirectoryManagerAuthenticationDialog.this.cancelClicked();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        p.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)buttonPanel, gbc);
        return p;
    }

    private String getProposedDirectoryManagerDn() {
        Set<String> dns = null;
        try {
            dns = Installation.getLocal().getCurrentConfiguration().getDirectoryManagerDns();
        }
        catch (IOException ioe) {
            LOG.log(Level.INFO, "error obtaining dirmanager DNs", ioe);
        }
        String dn = dns != null && dns.size() > 0 ? dns.iterator().next() : null;
        return dn;
    }

    private void cancelClicked() {
        this.isCancelled = true;
        this.dispose();
    }

    private void shutDownClicked() {
        this.isCancelled = false;
        BackgroundTask<Boolean> worker = new BackgroundTask<Boolean>(){

            @Override
            public Boolean processBackgroundTask() throws NamingException {
                Boolean isServerRunning = Boolean.TRUE;
                try {
                    Installation installation = Installation.getLocal();
                    int port = installation.getCurrentConfiguration().getPort();
                    String ldapUrl = "ldap://localhost:" + port;
                    InitialLdapContext ctx = Utils.createLdapContext(ldapUrl, DirectoryManagerAuthenticationDialog.this.tfDn.getText(), DirectoryManagerAuthenticationDialog.this.tfPwd.getText(), Utils.getDefaultLDAPTimeout(), null);
                    SearchControls searchControls = new SearchControls();
                    searchControls.setCountLimit(1L);
                    searchControls.setSearchScope(0);
                    searchControls.setReturningAttributes(new String[]{"1.1"});
                    ctx.search("cn=config", "objectclass=*", searchControls);
                }
                catch (NamingException ne) {
                    if (Installation.getLocal().getStatus().isServerRunning()) {
                        throw ne;
                    }
                    isServerRunning = Boolean.FALSE;
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unexpected throwable.", t);
                }
                return isServerRunning;
            }

            @Override
            public void backgroundTaskCompleted(Boolean returnValue, Throwable throwable) {
                if (throwable != null) {
                    if (throwable instanceof NamingException) {
                        boolean dnInvalid = false;
                        boolean pwdInvalid = false;
                        String dn = DirectoryManagerAuthenticationDialog.this.tfDn.getText();
                        ArrayList<Message> possibleCauses = new ArrayList<Message>();
                        if ("".equals(dn.trim())) {
                            dnInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_EMPTY_DIRECTORY_MANAGER_DN.get());
                        } else if (!Utils.isDn(dn)) {
                            dnInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_DN.get());
                        } else {
                            boolean found = false;
                            try {
                                Set<String> dns = Installation.getLocal().getCurrentConfiguration().getDirectoryManagerDns();
                                Iterator<String> it = dns.iterator();
                                while (it.hasNext() && !found) {
                                    found = Utils.areDnsEqual(dn, it.next());
                                }
                            }
                            catch (IOException ioe) {
                                LOG.log(Level.INFO, "error obtaining dirmanager DNs", ioe);
                            }
                            if (!found) {
                                dnInvalid = true;
                                possibleCauses.add(QuickSetupMessages.INFO_NOT_A_DIRECTORY_MANAGER_IN_CONFIG.get());
                            }
                        }
                        if ("".equals(DirectoryManagerAuthenticationDialog.this.tfPwd.getText())) {
                            pwdInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_EMPTY_PWD.get());
                        }
                        if (dnInvalid) {
                            UIFactory.setTextStyle(DirectoryManagerAuthenticationDialog.this.lDn, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(DirectoryManagerAuthenticationDialog.this.lDn, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                            pwdInvalid = true;
                        }
                        if (pwdInvalid) {
                            UIFactory.setTextStyle(DirectoryManagerAuthenticationDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(DirectoryManagerAuthenticationDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                        }
                        if (possibleCauses.size() > 0) {
                            Utilities.displayError(DirectoryManagerAuthenticationDialog.this.parent, QuickSetupMessages.INFO_CANNOT_CONNECT_TO_SHUTDOWN_WITH_CAUSE.get(Utils.getMessageFromCollection(possibleCauses, "\n")), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        } else {
                            Utilities.displayError(DirectoryManagerAuthenticationDialog.this.parent, QuickSetupMessages.INFO_CANNOT_CONNECT_TO_SHUTDOWN_WITHOUT_CAUSE.get(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                    } else {
                        throwable.printStackTrace();
                        Utilities.displayError(DirectoryManagerAuthenticationDialog.this.parent, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    }
                    DirectoryManagerAuthenticationDialog.this.cancelButton.setEnabled(true);
                    DirectoryManagerAuthenticationDialog.this.shutDownButton.setEnabled(true);
                } else {
                    DirectoryManagerAuthenticationDialog.this.isServerRunning = Boolean.TRUE.equals(returnValue);
                    if (!DirectoryManagerAuthenticationDialog.this.isServerRunning) {
                        Utilities.displayInformationMessage(DirectoryManagerAuthenticationDialog.this.parent, QuickSetupMessages.INFO_SERVER_NOT_RUNNING_MSG.get(), QuickSetupMessages.INFO_SERVER_NOT_RUNNING_TITLE.get());
                    }
                    DirectoryManagerAuthenticationDialog.this.isCancelled = false;
                    DirectoryManagerAuthenticationDialog.this.dispose();
                }
            }
        };
        this.cancelButton.setEnabled(false);
        this.shutDownButton.setEnabled(false);
        worker.startBackgroundTask();
    }

    public static void main(String[] args) {
        try {
            DirectoryManagerAuthenticationDialog dlg = new DirectoryManagerAuthenticationDialog(new JFrame());
            dlg.packAndShow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

