/*
 * Decompiled with CFR 0.152.
 */
package org.opends.quicksetup.installer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.InitialLdapContext;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.CoreMessages;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ReplicationMessages;
import org.opends.quicksetup.Application;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.JavaArguments;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.installer.ConfiguredDomain;
import org.opends.quicksetup.installer.ConfiguredReplication;
import org.opends.quicksetup.util.OutputReader;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.client.CryptoManagerCfgClient;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.BackendCfgDefn;
import org.opends.server.admin.std.meta.LocalDBBackendCfgDefn;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.meta.ReplicationServerCfgDefn;
import org.opends.server.admin.std.meta.ReplicationSynchronizationProviderCfgDefn;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.tools.ConfigureDS;
import org.opends.server.tools.ConfigureWindowsService;
import org.opends.server.tools.JavaPropertiesTool;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerHelper {
    private static final Logger LOG = Logger.getLogger(InstallerHelper.class.getName());
    private static final int MAX_ID_VALUE = Short.MAX_VALUE;

    public int invokeConfigureServer(String[] args) throws ApplicationException {
        return ConfigureDS.configMain(args, System.out, System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int invokeImportLDIF(final Application application, String[] args) throws IOException, InterruptedException {
        File installPath = new File(application.getInstallationPath());
        ArrayList<String> argList = new ArrayList<String>();
        File binPath = Utils.isWindows() ? new File(installPath, "bat") : new File(installPath, "bin");
        File importPath = Utils.isWindows() ? new File(binPath, "import-ldif.bat") : new File(binPath, "import-ldif");
        argList.add(Utils.getScriptPath(importPath.getAbsolutePath()));
        for (String arg : args) {
            argList.add(arg);
        }
        String[] allArgs = new String[argList.size()];
        argList.toArray(allArgs);
        LOG.log(Level.INFO, "import-ldif arg list: " + argList);
        ProcessBuilder pb = new ProcessBuilder(allArgs);
        Map<String, String> env = pb.environment();
        env.remove("OPENDS_JAVA_HOME");
        env.remove("OPENDS_JAVA_ARGS");
        env.remove("CLASSPATH");
        pb.directory(installPath);
        Process process = null;
        try {
            process = pb.start();
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            new OutputReader(err){

                public void processLine(String line) {
                    LOG.log(Level.WARNING, "import-ldif error log: " + line);
                    application.notifyListeners(Message.raw(line, new Object[0]));
                    application.notifyListeners(application.getLineBreak());
                }
            };
            BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new OutputReader(out){

                public void processLine(String line) {
                    LOG.log(Level.INFO, "import-ldif out log: " + line);
                    application.notifyListeners(Message.raw(line, new Object[0]));
                    application.notifyListeners(application.getLineBreak());
                }
            };
            int n = process.waitFor();
            return n;
        }
        finally {
            if (process != null) {
                try {
                    process.getErrorStream().close();
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Error closing error stream: " + t, t);
                }
                try {
                    process.getOutputStream().close();
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Error closing output stream: " + t, t);
                }
            }
        }
    }

    public String getStartedId() {
        return String.valueOf(CoreMessages.NOTE_DIRECTORY_SERVER_STARTED.getId());
    }

    public void enableWindowsService() throws ApplicationException {
        int code = ConfigureWindowsService.enableService(System.out, System.err);
        Message errorMessage = QuickSetupMessages.INFO_ERROR_ENABLING_WINDOWS_SERVICE.get();
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new ApplicationException(ReturnCode.WINDOWS_SERVICE_ERROR, errorMessage, null);
            }
        }
    }

    public void disableWindowsService() throws ApplicationException {
        int code = ConfigureWindowsService.disableService(System.out, System.err);
        if (code == 3) {
            throw new ApplicationException(ReturnCode.WINDOWS_SERVICE_ERROR, QuickSetupMessages.INFO_ERROR_DISABLING_WINDOWS_SERVICE.get(""), null);
        }
    }

    public File createBaseEntryTempFile(String baseDn) throws ApplicationException {
        File ldifFile;
        try {
            ldifFile = File.createTempFile("opends-base-entry", ".ldif");
            ldifFile.deleteOnExit();
        }
        catch (IOException ioe) {
            Message failedMsg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CREATING_TEMP_FILE.get(), ioe);
            throw new ApplicationException(ReturnCode.FILE_SYSTEM_ACCESS_ERROR, failedMsg, ioe);
        }
        try {
            LDIFExportConfig exportConfig = new LDIFExportConfig(ldifFile.getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
            LDIFWriter writer = new LDIFWriter(exportConfig);
            DN dn = DN.decode(baseDn);
            Entry entry = StaticUtils.createEntry(dn);
            writer.writeEntry(entry);
            writer.close();
        }
        catch (DirectoryException de) {
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), de), de);
        }
        catch (LDIFException le) {
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), le), le);
        }
        catch (IOException ioe) {
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_IMPORTING_LDIF.get(), ioe), ioe);
        }
        catch (Throwable t) {
            throw new ApplicationException(ReturnCode.BUG, Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), t), t);
        }
        return ldifFile;
    }

    public void deleteBackend(InitialLdapContext ctx, String backendName, String serverDisplay) throws ApplicationException {
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            root.removeBackend(backendName);
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public void deleteBackend(String backendName) throws ApplicationException {
        try {
            String dn = Utilities.getRDNString("ds-cfg-backend-id", backendName) + ",cn=Backends,cn=config";
            Utilities.deleteConfigSubtree(DirectoryServer.getConfigHandler(), DN.decode(dn));
        }
        catch (OpenDsException ode) {
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, ode.getMessageObject(), ode);
        }
    }

    public void createLocalDBBackend(InitialLdapContext ctx, String backendName, Set<String> baseDNs, String serverDisplay) throws ApplicationException {
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LocalDBBackendCfgDefn provider = LocalDBBackendCfgDefn.getInstance();
            LocalDBBackendCfgClient backend = root.createBackend(provider, backendName, null);
            backend.setEnabled(true);
            HashSet<DN> setBaseDNs = new HashSet<DN>();
            for (String baseDN : baseDNs) {
                setBaseDNs.add(DN.decode(baseDN));
            }
            backend.setBaseDN(setBaseDNs);
            backend.setBackendId(backendName);
            backend.setWritabilityMode(BackendCfgDefn.WritabilityMode.ENABLED);
            backend.commit();
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public void setBaseDns(InitialLdapContext ctx, String backendName, Set<String> baseDNs, String serverDisplay) throws ApplicationException {
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            BackendCfgClient backend = root.getBackend(backendName);
            HashSet<DN> setBaseDNs = new HashSet<DN>();
            for (String baseDN : baseDNs) {
                setBaseDNs.add(DN.decode(baseDN));
            }
            backend.setBaseDN(setBaseDNs);
            backend.commit();
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public ConfiguredReplication configureReplication(InitialLdapContext remoteCtx, Map<String, Set<String>> replicationServers, int replicationPort, boolean useSecureReplication, String serverDisplay, Set<Integer> usedReplicationServerIds, Set<Integer> usedServerIds) throws ApplicationException {
        try {
            boolean replicationServerCreated;
            boolean secureReplicationEnabled;
            boolean synchProviderEnabled;
            boolean synchProviderCreated;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(remoteCtx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (ManagedObjectNotFoundException monfe) {
                // empty catch block
            }
            if (sync == null) {
                ReplicationSynchronizationProviderCfgDefn provider = ReplicationSynchronizationProviderCfgDefn.getInstance();
                sync = root.createSynchronizationProvider(provider, "Multimaster Synchronization", new ArrayList<DefaultBehaviorException>());
                sync.setJavaClass(MultimasterReplication.class.getName());
                sync.setEnabled(Boolean.TRUE);
                synchProviderCreated = true;
                synchProviderEnabled = false;
            } else {
                synchProviderCreated = false;
                if (!sync.isEnabled().booleanValue()) {
                    sync.setEnabled(Boolean.TRUE);
                    synchProviderEnabled = true;
                } else {
                    synchProviderEnabled = false;
                }
            }
            sync.commit();
            ReplicationServerCfgClient replicationServer = null;
            if (!sync.hasReplicationServer()) {
                if (useSecureReplication) {
                    CryptoManagerCfgClient crypto = root.getCryptoManager();
                    if (!crypto.isSSLEncryption()) {
                        crypto.setSSLEncryption(true);
                        crypto.commit();
                        secureReplicationEnabled = true;
                    } else {
                        secureReplicationEnabled = false;
                    }
                } else {
                    secureReplicationEnabled = false;
                }
                int id = InstallerHelper.getReplicationId(usedReplicationServerIds);
                usedReplicationServerIds.add(id);
                replicationServer = sync.createReplicationServer(ReplicationServerCfgDefn.getInstance(), new ArrayList<DefaultBehaviorException>());
                replicationServer.setReplicationServerId(id);
                replicationServer.setReplicationPort(replicationPort);
                replicationServerCreated = true;
            } else {
                secureReplicationEnabled = false;
                replicationServer = sync.getReplicationServer();
                usedReplicationServerIds.add(replicationServer.getReplicationServerId());
                replicationServerCreated = false;
            }
            Set<String> servers = replicationServer.getReplicationServer();
            if (servers == null) {
                servers = new HashSet();
            }
            Set<String> oldServers = new HashSet<String>();
            oldServers.addAll(servers);
            for (Set<String> rs : replicationServers.values()) {
                servers.addAll(rs);
            }
            replicationServer.setReplicationServer(servers);
            replicationServer.commit();
            HashSet<String> newReplicationServers = new HashSet<String>();
            newReplicationServers.addAll(servers);
            newReplicationServers.removeAll(oldServers);
            String[] domainNames = sync.listReplicationDomains();
            if (domainNames == null) {
                domainNames = new String[]{};
            }
            HashSet<ConfiguredDomain> domainsConf = new HashSet<ConfiguredDomain>();
            ReplicationDomainCfgClient[] domains = new ReplicationDomainCfgClient[domainNames.length];
            for (int i = 0; i < domains.length; ++i) {
                domains[i] = sync.getReplicationDomain(domainNames[i]);
            }
            for (String dn : replicationServers.keySet()) {
                boolean isCreated;
                ReplicationDomainCfgClient domain = null;
                String domainName = null;
                for (int i = 0; i < domains.length && domain == null; ++i) {
                    if (!Utils.areDnsEqual(dn, domains[i].getBaseDN().toString())) continue;
                    domain = domains[i];
                    domainName = domainNames[i];
                }
                if (domain == null) {
                    int domainId = InstallerHelper.getReplicationId(usedServerIds);
                    usedServerIds.add(domainId);
                    domainName = InstallerHelper.getDomainName(domainNames, domainId, dn);
                    domain = sync.createReplicationDomain(ReplicationDomainCfgDefn.getInstance(), domainName, new ArrayList<DefaultBehaviorException>());
                    domain.setServerId(domainId);
                    domain.setBaseDN(DN.decode(dn));
                    isCreated = true;
                } else {
                    isCreated = false;
                }
                oldServers = domain.getReplicationServer();
                if (oldServers == null) {
                    oldServers = new TreeSet();
                }
                servers = replicationServers.get(dn);
                domain.setReplicationServer(servers);
                usedServerIds.add(domain.getServerId());
                domain.commit();
                TreeSet<String> addedServers = new TreeSet<String>();
                addedServers.addAll(servers);
                addedServers.removeAll(oldServers);
                ConfiguredDomain domainConf = new ConfiguredDomain(domainName, isCreated, addedServers);
                domainsConf.add(domainConf);
            }
            return new ConfiguredReplication(synchProviderCreated, synchProviderEnabled, replicationServerCreated, secureReplicationEnabled, newReplicationServers, domainsConf);
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public void unconfigureReplication(InitialLdapContext remoteCtx, ConfiguredReplication replConf, String serverDisplay) throws ApplicationException {
        try {
            CryptoManagerCfgClient crypto;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(remoteCtx));
            RootCfgClient root = mCtx.getRootConfiguration();
            if (replConf.isSynchProviderCreated()) {
                try {
                    root.removeSynchronizationProvider("Multimaster Synchronization");
                }
                catch (ManagedObjectNotFoundException monfe) {}
            } else {
                try {
                    ReplicationServerCfgClient replicationServer;
                    SortedSet<String> replServers;
                    ReplicationSynchronizationProviderCfgClient sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
                    if (replConf.isSynchProviderEnabled()) {
                        sync.setEnabled(Boolean.FALSE);
                    }
                    if (replConf.isReplicationServerCreated()) {
                        sync.removeReplicationServer();
                    } else if (sync.hasReplicationServer() && (replServers = (replicationServer = sync.getReplicationServer()).getReplicationServer()) != null) {
                        replServers.removeAll(replConf.getNewReplicationServers());
                        replicationServer.setReplicationServer(replServers);
                        replicationServer.commit();
                    }
                    for (ConfiguredDomain domain : replConf.getDomainsConf()) {
                        if (domain.isCreated()) {
                            sync.removeReplicationDomain(domain.getDomainName());
                            continue;
                        }
                        try {
                            ReplicationDomainCfgClient d = sync.getReplicationDomain(domain.getDomainName());
                            SortedSet<String> replServers2 = d.getReplicationServer();
                            if (replServers2 == null) continue;
                            replServers2.removeAll(domain.getAddedReplicationServers());
                            d.setReplicationServer(replServers2);
                            d.commit();
                        }
                        catch (ManagedObjectNotFoundException monfe) {}
                    }
                    sync.commit();
                }
                catch (ManagedObjectNotFoundException monfe) {
                    // empty catch block
                }
            }
            if (replConf.isSecureReplicationEnabled() && (crypto = root.getCryptoManager()).isSSLEncryption()) {
                crypto.setSSLEncryption(false);
                crypto.commit();
            }
        }
        catch (Throwable t) {
            Message errorMessage = QuickSetupMessages.INFO_ERROR_CONFIGURING_REMOTE_GENERIC.get(serverDisplay, t.toString());
            throw new ApplicationException(ReturnCode.CONFIGURATION_ERROR, errorMessage, t);
        }
    }

    public boolean isDone(String sState) {
        TaskState state = TaskState.fromString(sState);
        return TaskState.isDone(state);
    }

    public boolean isSuccessful(String sState) {
        TaskState state = TaskState.fromString(sState);
        return TaskState.isSuccessful(state);
    }

    public boolean isCompletedWithErrors(String sState) {
        TaskState state = TaskState.fromString(sState);
        return state == TaskState.COMPLETED_WITH_ERRORS;
    }

    public boolean isStoppedByError(String sState) {
        TaskState state = TaskState.fromString(sState);
        return state == TaskState.STOPPED_BY_ERROR;
    }

    public boolean isPeersNotFoundError(String logMsg) {
        return logMsg.indexOf("=" + ReplicationMessages.ERR_NO_REACHABLE_PEER_IN_THE_DOMAIN.getId()) != -1;
    }

    public static int getReplicationId(Set<Integer> usedIds) {
        Random r = new Random();
        int id = 0;
        while (id == 0 || usedIds.contains(id)) {
            id = r.nextInt(Short.MAX_VALUE);
        }
        return id;
    }

    public static String getDomainName(String[] existingDomains, int newDomainId, String baseDN) {
        String domainName = baseDN;
        boolean nameExists = true;
        int j = 0;
        while (nameExists) {
            boolean found = false;
            for (int i = 0; i < existingDomains.length && !found; ++i) {
                found = existingDomains[i].equalsIgnoreCase(domainName);
            }
            if (found) {
                domainName = baseDN + "-" + j;
            } else {
                nameExists = false;
            }
            ++j;
        }
        return domainName;
    }

    public void writeSetOpenDSJavaHome(UserData uData, String installPath) throws IOException {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || javaHome.length() == 0) {
            javaHome = System.getenv("OPENDS_JAVA_HOME");
        }
        HashMap<JavaArguments, JavaArguments> hmJavaArguments = new HashMap<JavaArguments, JavaArguments>();
        for (String script : uData.getScriptNamesForJavaArguments()) {
            JavaArguments origJavaArguments = uData.getJavaArguments(script);
            if (hmJavaArguments.get(origJavaArguments) != null) continue;
            if (Utils.supportsOption(origJavaArguments.getStringArguments(), javaHome, installPath)) {
                hmJavaArguments.put(origJavaArguments, origJavaArguments);
                continue;
            }
            JavaArguments transformedArguments = this.getBestEffortArguments(origJavaArguments, javaHome, installPath);
            hmJavaArguments.put(origJavaArguments, transformedArguments);
        }
        Properties fileProperties = this.getJavaPropertiesFileContents(this.getPropertiesFileName(installPath));
        HashMap<String, JavaArguments> args = new HashMap<String, JavaArguments>();
        HashMap<String, String> otherProperties = new HashMap<String, String>();
        for (String script : uData.getScriptNamesForJavaArguments()) {
            JavaArguments origJavaArgument = uData.getJavaArguments(script);
            JavaArguments transformedJavaArg = (JavaArguments)hmJavaArguments.get(origJavaArgument);
            JavaArguments defaultJavaArg = uData.getDefaultJavaArguments(script);
            String propertiesKey = InstallerHelper.getJavaArgPropertyForScript(script);
            if (origJavaArgument.equals(defaultJavaArg) && fileProperties.containsKey(propertiesKey)) {
                otherProperties.put(propertiesKey, fileProperties.getProperty(propertiesKey));
                continue;
            }
            args.put(script, transformedJavaArg);
        }
        String v = fileProperties.getProperty("overwrite-env-java-home");
        if (v == null || !v.equalsIgnoreCase("true") && !v.equalsIgnoreCase("false")) {
            otherProperties.put("overwrite-env-java-home", "false");
        } else {
            otherProperties.put("overwrite-env-java-home", v.toLowerCase());
        }
        v = fileProperties.getProperty("overwrite-env-java-args");
        if (v == null || !v.equalsIgnoreCase("true") && !v.equalsIgnoreCase("false")) {
            otherProperties.put("overwrite-env-java-args", "false");
        } else {
            otherProperties.put("overwrite-env-java-args", v.toLowerCase());
        }
        if (!fileProperties.containsKey("default.java-home")) {
            otherProperties.put("default.java-home=", javaHome);
        }
        this.writeSetOpenDSJavaHome(installPath, javaHome, args, otherProperties);
    }

    private JavaArguments getBestEffortArguments(JavaArguments origJavaArguments, String javaHome, String installPath) {
        JavaArguments memArgs = new JavaArguments();
        memArgs.setInitialMemory(origJavaArguments.getInitialMemory());
        memArgs.setMaxMemory(origJavaArguments.getMaxMemory());
        String m = memArgs.getStringArguments();
        boolean supportsMemory = false;
        if (m.length() > 0) {
            supportsMemory = Utils.supportsOption(m, javaHome, installPath);
        }
        JavaArguments additionalArgs = new JavaArguments();
        additionalArgs.setAdditionalArguments(origJavaArguments.getAdditionalArguments());
        String a = additionalArgs.getStringArguments();
        boolean supportsAdditional = false;
        if (a.length() > 0) {
            supportsAdditional = Utils.supportsOption(a, javaHome, installPath);
        }
        JavaArguments javaArgs = new JavaArguments();
        if (supportsMemory) {
            javaArgs.setInitialMemory(origJavaArguments.getInitialMemory());
            javaArgs.setMaxMemory(origJavaArguments.getMaxMemory());
        } else {
            long currentMaxMemory = Runtime.getRuntime().maxMemory();
            int maxMemory = origJavaArguments.getMaxMemory();
            if (maxMemory != -1) {
                maxMemory /= 2;
                while ((long)(0x100000 * maxMemory) < currentMaxMemory && !Utils.supportsOption(JavaArguments.getMaxMemoryArgument(maxMemory), javaHome, installPath)) {
                    maxMemory /= 2;
                }
                if ((long)(0x100000 * maxMemory) > currentMaxMemory) {
                    javaArgs.setMaxMemory(maxMemory);
                }
            }
        }
        if (supportsAdditional) {
            javaArgs.setAdditionalArguments(origJavaArguments.getAdditionalArguments());
        }
        return javaArgs;
    }

    private List<String> getJavaPropertiesFileComments(String propertiesFile) throws IOException {
        String trimmedLine;
        String line;
        ArrayList<String> commentLines = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new FileReader(propertiesFile));
        while ((line = reader.readLine()) != null && ((trimmedLine = line.trim()).startsWith("#") || trimmedLine.length() == 0)) {
            commentLines.add(line);
        }
        return commentLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getJavaPropertiesFileContents(String propertiesFile) throws IOException {
        FileInputStream fs = null;
        Properties fileProperties = new Properties();
        try {
            fs = new FileInputStream(propertiesFile);
            fileProperties.load(fs);
        }
        catch (Throwable t) {
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Throwable t) {}
            }
        }
        return fileProperties;
    }

    private String getPropertiesFileName(String installPath) {
        String configDir = Utils.getPath(Utils.getInstancePathFromInstallPath(installPath), "config");
        String propertiesFile = Utils.getPath(configDir, "java.properties");
        return propertiesFile;
    }

    private void writeSetOpenDSJavaHome(String installPath, String javaHome, Map<String, JavaArguments> arguments, Map<String, String> otherProperties) throws IOException {
        String propertiesFile = this.getPropertiesFileName(installPath);
        List<String> commentLines = this.getJavaPropertiesFileComments(propertiesFile);
        BufferedWriter writer = new BufferedWriter(new FileWriter(propertiesFile, false));
        for (String line : commentLines) {
            writer.write(line);
            writer.newLine();
        }
        for (String key : otherProperties.keySet()) {
            writer.write(key + "=" + otherProperties.get(key));
            writer.newLine();
        }
        for (String scriptName : arguments.keySet()) {
            String argument = arguments.get(scriptName).getStringArguments();
            writer.newLine();
            writer.write(InstallerHelper.getJavaArgPropertyForScript(scriptName) + "=" + argument);
        }
        writer.close();
        String libDir = Utils.getPath(Utils.getInstancePathFromInstallPath(installPath), "lib");
        String destinationFile = Utils.isWindows() ? Utils.getPath(libDir, "set-java-home.bat") : Utils.getPath(libDir, "set-java-home");
        String[] args = new String[]{"--propertiesFile", propertiesFile, "--destinationFile", destinationFile, "--quiet"};
        int returnValue = JavaPropertiesTool.mainCLI(args);
        if (returnValue != JavaPropertiesTool.ErrorReturnCode.SUCCESSFUL.getReturnCode() && returnValue != JavaPropertiesTool.ErrorReturnCode.SUCCESSFUL_NOP.getReturnCode()) {
            LOG.log(Level.WARNING, "Error creating java home scripts, error code: " + returnValue);
            throw new IOException(QuickSetupMessages.ERR_ERROR_CREATING_JAVA_HOME_SCRIPTS.get(returnValue).toString());
        }
    }

    private static String getJavaArgPropertyForScript(String scriptName) {
        return scriptName + ".java-args";
    }

    public String getImportProgressMessage(String msg) {
        int index;
        String parsedMsg = null;
        if (msg != null && (msg.indexOf("msgID=" + JebMessages.NOTE_JEB_IMPORT_FINAL_STATUS.getId()) != -1 || msg.indexOf("msgID=" + JebMessages.NOTE_JEB_IMPORT_PROGRESS_REPORT.getId()) != -1) && (index = msg.indexOf("msg=")) != -1) {
            parsedMsg = msg.substring(index + 4);
        }
        return parsedMsg;
    }
}

