/*
 * Decompiled with CFR 0.152.
 */
package org.opends.messages;

import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.opends.messages.Category;
import org.opends.messages.MessageDescriptor;
import org.opends.messages.Severity;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class Message
implements CharSequence,
Formattable,
Comparable<Message> {
    public static final Message EMPTY = Message.raw("", new Object[0]);
    private final boolean isAIXPost5 = this.isAIXPost5();
    private final MessageDescriptor descriptor;
    private final Object[] args;

    public static Message raw(CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            message = new MessageDescriptor.Raw(formatString).get(args);
        }
        return message;
    }

    public static Message raw(Category category, Severity severity, CharSequence formatString, Object ... args) {
        Message message = null;
        if (formatString != null) {
            MessageDescriptor.Raw md = new MessageDescriptor.Raw(formatString, category, severity);
            message = md.get(args);
        }
        return message;
    }

    public static Message fromObject(Object object, Object ... arguments) {
        Message message = null;
        if (object != null) {
            String cs = object.toString();
            message = Message.raw(cs, arguments);
        }
        return message;
    }

    public static String toString(Message message) {
        return message != null ? message.toString() : null;
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        String s;
        block10: {
            String fmt = this.descriptor.getFormatString(locale);
            if (this.descriptor.requiresFormatter()) {
                try {
                    if (this.isAIXPost5) {
                        boolean changeType = false;
                        for (Object o : this.args) {
                            if (!(o instanceof Formattable)) continue;
                            changeType = true;
                            break;
                        }
                        if (changeType) {
                            Object[] newArgs = new Object[this.args.length];
                            for (int i = 0; i < this.args.length; ++i) {
                                newArgs[i] = this.args[i] instanceof Formattable ? this.args[i].toString() : this.args[i];
                            }
                            s = new Formatter(locale).format(locale, fmt, newArgs).toString();
                        } else {
                            s = new Formatter(locale).format(locale, fmt, this.args).toString();
                        }
                        break block10;
                    }
                    s = new Formatter(locale).format(locale, fmt, this.args).toString();
                }
                catch (IllegalFormatException e) {
                    s = fmt;
                }
            } else {
                s = fmt;
            }
        }
        if (s == null) {
            s = "";
        }
        return s;
    }

    public MessageDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int length() {
        return this.length(Locale.getDefault());
    }

    public byte[] getBytes() {
        return this.toString().getBytes();
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.charAt(Locale.getDefault(), index);
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public char charAt(Locale locale, int index) throws IndexOutOfBoundsException {
        return this.toString(locale).charAt(index);
    }

    public CharSequence subSequence(Locale locale, int start, int end) throws IndexOutOfBoundsException {
        return this.toString(locale).subSequence(start, end);
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) throws IllegalFormatException {
        Locale l = formatter.locale();
        formatter.format(l, this.descriptor.getFormatString(l), this.args);
    }

    Message(MessageDescriptor descriptor, Object ... args) {
        this.descriptor = descriptor;
        this.args = args;
    }

    @Override
    public int compareTo(Message o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return this.toString().equals(message.toString());
    }

    public int hashCode() {
        int result = 31 * this.toString().hashCode();
        return result;
    }

    private boolean isAIXPost5() {
        boolean isJDK15 = false;
        try {
            String javaRelease = System.getProperty("java.version");
            isJDK15 = javaRelease.startsWith("1.5");
        }
        catch (Throwable t) {
            System.err.println("Cannot get the java version: " + t);
        }
        boolean isAIX = "aix".equalsIgnoreCase(System.getProperty("os.name"));
        return !isJDK15 && isAIX;
    }
}

