/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.uninstaller.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.guitools.controlpanel.datamodel.ConnectionProtocolPolicy;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.util.ConfigFromFile;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Installation;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.event.MinimumSizeComponentListener;
import org.opends.quicksetup.ui.CertificateDialog;
import org.opends.quicksetup.ui.UIFactory;
import org.opends.quicksetup.ui.Utilities;
import org.opends.quicksetup.util.BackgroundTask;
import org.opends.quicksetup.util.UIKeyStore;
import org.opends.quicksetup.util.Utils;

public class LoginDialog
extends JDialog {
    private static final long serialVersionUID = 9049409381101152000L;
    private JFrame parent;
    private JLabel lHostName;
    private JLabel lUid;
    private JLabel lPwd;
    private JTextField tfHostName;
    private JTextField tfUid;
    private JTextField tfPwd;
    private JButton cancelButton;
    private JButton okButton;
    private boolean isCancelled = true;
    private ApplicationTrustManager trustManager;
    private InitialLdapContext ctx;
    private String usedUrl;
    private static final Logger LOG = Logger.getLogger(LoginDialog.class.getName());

    public LoginDialog(JFrame parent, ApplicationTrustManager trustManager) {
        super(parent);
        this.setTitle(AdminToolMessages.INFO_LOGIN_DIALOG_TITLE.get().toString());
        this.parent = parent;
        this.getContentPane().add(this.createPanel());
        if (trustManager == null) {
            throw new IllegalArgumentException("The trustmanager cannot be null.");
        }
        this.trustManager = trustManager;
        this.setPreferredSize(new Dimension(500, 250));
        this.addComponentListener(new MinimumSizeComponentListener(this, 500, 250));
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setVisible(boolean visible) {
        this.cancelButton.setEnabled(true);
        this.okButton.setEnabled(true);
        if (visible) {
            this.tfPwd.setText("");
            this.tfPwd.requestFocusInWindow();
            UIFactory.setTextStyle(this.lHostName, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            UIFactory.setTextStyle(this.lUid, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            UIFactory.setTextStyle(this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
            this.getRootPane().setDefaultButton(this.okButton);
        }
        super.setVisible(visible);
    }

    public String getHostName() {
        return this.tfHostName.getText();
    }

    public String getAdministratorUid() {
        return this.tfUid.getText();
    }

    public String getAdministratorPwd() {
        return this.tfPwd.getText();
    }

    public InitialLdapContext getContext() {
        return this.ctx;
    }

    private JPanel createPanel() {
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setBackground(UIFactory.CURRENT_STEP_PANEL_BACKGROUND);
        p1.setBorder(UIFactory.DIALOG_PANEL_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = -1;
        gbc.anchor = 18;
        gbc.insets = UIFactory.getCurrentStepPanelInsets();
        p1.add((Component)UIFactory.makeJLabel(UIFactory.IconType.INFORMATION_LARGE, null, UIFactory.TextStyle.NO_STYLE), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.insets.left = 0;
        Message msg = AdminToolMessages.INFO_UNINSTALL_LOGIN_DIALOG_MSG.get();
        JEditorPane textPane = UIFactory.makeHtmlPane(msg, UIFactory.INSTRUCTIONS_FONT);
        textPane.setOpaque(false);
        textPane.setEditable(false);
        p1.add((Component)textPane, gbc);
        JPanel p2 = new JPanel(new GridBagLayout());
        p2.setOpaque(false);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.anchor = 17;
        gbc.fill = 2;
        this.lHostName = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, AdminToolMessages.INFO_UNINSTALL_LOGIN_HOST_NAME_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lHostName, gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        UserData uData = new UserData();
        this.tfHostName = UIFactory.makeJTextField(Message.raw(uData.getHostName(), new Object[0]), AdminToolMessages.INFO_UNINSTALL_LOGIN_HOST_NAME_TOOLTIP.get(), 20, UIFactory.TextStyle.TEXTFIELD);
        p2.add((Component)this.tfHostName, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.lUid = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_UID_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lUid, gbc);
        gbc.weightx = 1.0;
        gbc.insets.left = 10;
        gbc.gridwidth = 0;
        this.tfUid = UIFactory.makeJTextField(Message.raw("admin", new Object[0]), AdminToolMessages.INFO_UNINSTALL_LOGIN_UID_TOOLTIP.get(), 20, UIFactory.TextStyle.TEXTFIELD);
        p2.add((Component)this.tfUid, gbc);
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        this.lPwd = UIFactory.makeJLabel(UIFactory.IconType.NO_ICON, QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_PWD_LABEL.get(), UIFactory.TextStyle.PRIMARY_FIELD_VALID);
        p2.add((Component)this.lPwd, gbc);
        gbc.insets.left = 10;
        gbc.fill = 2;
        gbc.gridwidth = 0;
        JPanel p3 = new JPanel(new GridBagLayout());
        p3.setOpaque(false);
        this.tfPwd = UIFactory.makeJPasswordField(null, AdminToolMessages.INFO_UNINSTALL_LOGIN_PWD_TOOLTIP.get(), 15, UIFactory.TextStyle.PASSWORD_FIELD);
        p2.add((Component)p3, gbc);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        p3.add((Component)this.tfPwd, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        p3.add(Box.createHorizontalGlue(), gbc);
        gbc.fill = 2;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = -1;
        gbc.weightx = 0.0;
        gbc.insets.top = 0;
        p1.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets.right = UIFactory.getCurrentStepPanelInsets().right;
        p1.add((Component)p2, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 3;
        gbc.insets.bottom = UIFactory.getCurrentStepPanelInsets().bottom;
        p1.add(Box.createVerticalGlue(), gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.gridwidth = 3;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridwidth = -1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.okButton = UIFactory.makeJButton(QuickSetupMessages.INFO_OK_BUTTON_LABEL.get(), AdminToolMessages.INFO_UNINSTALL_LOGIN_OK_BUTTON_TOOLTIP.get());
        buttonPanel.add((Component)this.okButton, gbc);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LoginDialog.this.okClicked();
            }
        });
        gbc.gridwidth = 0;
        gbc.insets.left = 5;
        this.cancelButton = UIFactory.makeJButton(QuickSetupMessages.INFO_CANCEL_BUTTON_LABEL.get(), AdminToolMessages.INFO_UNINSTALL_LOGIN_CANCEL_BUTTON_TOOLTIP.get());
        buttonPanel.add((Component)this.cancelButton, gbc);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LoginDialog.this.cancelClicked();
            }
        });
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(UIFactory.DEFAULT_BACKGROUND);
        gbc.insets = UIFactory.getEmptyInsets();
        gbc.fill = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        p.add((Component)p1, gbc);
        gbc.weighty = 0.0;
        gbc.insets = UIFactory.getButtonsPanelInsets();
        p.add((Component)buttonPanel, gbc);
        return p;
    }

    private void cancelClicked() {
        this.isCancelled = true;
        this.dispose();
    }

    private void okClicked() {
        BackgroundTask<Boolean> worker = new BackgroundTask<Boolean>(){

            @Override
            public Boolean processBackgroundTask() throws NamingException, ApplicationException {
                Boolean isServerRunning = Boolean.TRUE;
                LoginDialog.this.ctx = null;
                try {
                    ControlPanelInfo info = ControlPanelInfo.getInstance();
                    info.setTrustManager(LoginDialog.this.getTrustManager());
                    info.regenerateDescriptor();
                    ConfigFromFile conf = new ConfigFromFile();
                    conf.readConfiguration();
                    String dn = ADSContext.getAdministratorDN(LoginDialog.this.tfUid.getText());
                    String pwd = LoginDialog.this.tfPwd.getText();
                    info.setConnectionPolicy(ConnectionProtocolPolicy.USE_ADMIN);
                    LoginDialog.this.usedUrl = info.getAdminConnectorURL();
                    if (LoginDialog.this.usedUrl == null) {
                        throw new ApplicationException(ReturnCode.APPLICATION_ERROR, AdminToolMessages.ERR_COULD_NOT_FIND_VALID_LDAPURL.get(), null);
                    }
                    LoginDialog.this.ctx = org.opends.guitools.controlpanel.util.Utilities.getAdminDirContext(info, dn, pwd);
                }
                catch (NamingException ne) {
                    if (LoginDialog.this.isServerRunning()) {
                        throw ne;
                    }
                    isServerRunning = Boolean.FALSE;
                }
                catch (ApplicationException e) {
                    throw e;
                }
                catch (IllegalStateException ise) {
                    throw ise;
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Unexpected throwable.", t);
                }
                return isServerRunning;
            }

            @Override
            public void backgroundTaskCompleted(Boolean returnValue, Throwable throwable) {
                if (throwable != null) {
                    LOG.log(Level.INFO, "Error connecting: " + throwable, throwable);
                    if (Utils.isCertificateException(throwable)) {
                        ApplicationTrustManager.Cause cause = LoginDialog.this.trustManager.getLastRefusedCause();
                        LOG.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
                        UserDataCertificateException.Type excType = null;
                        if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
                            excType = UserDataCertificateException.Type.NOT_TRUSTED;
                        } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
                            excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
                        } else {
                            Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), throwable);
                            LoginDialog.this.displayError(msg, QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                        if (excType != null) {
                            int p;
                            String h;
                            try {
                                URI uri = new URI(LoginDialog.this.usedUrl);
                                h = uri.getHost();
                                p = uri.getPort();
                            }
                            catch (Throwable t) {
                                LOG.log(Level.WARNING, "Error parsing ldap url of ldap url.", t);
                                h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                                p = -1;
                            }
                            UserDataCertificateException udce = new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), throwable, h, p, LoginDialog.this.getTrustManager().getLastRefusedChain(), LoginDialog.this.getTrustManager().getLastRefusedAuthType(), excType);
                            LoginDialog.this.handleCertificateException(udce);
                        }
                    } else if (throwable instanceof NamingException) {
                        boolean uidInvalid = false;
                        boolean pwdInvalid = false;
                        String uid = LoginDialog.this.tfUid.getText();
                        ArrayList<Message> possibleCauses = new ArrayList<Message>();
                        if ("".equals(uid.trim())) {
                            uidInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_EMPTY_ADMINISTRATOR_UID.get());
                        }
                        if ("".equals(LoginDialog.this.tfPwd.getText())) {
                            pwdInvalid = true;
                            possibleCauses.add(QuickSetupMessages.INFO_EMPTY_PWD.get());
                        }
                        if (uidInvalid) {
                            UIFactory.setTextStyle(LoginDialog.this.lUid, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(LoginDialog.this.lUid, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                            pwdInvalid = true;
                        }
                        if (pwdInvalid) {
                            UIFactory.setTextStyle(LoginDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(LoginDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                        }
                        if (possibleCauses.size() > 0) {
                            LoginDialog.this.displayError(AdminToolMessages.ERR_CANNOT_CONNECT_TO_LOGIN_WITH_CAUSE.get(Utils.getMessageFromCollection(possibleCauses, "\n")), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        } else {
                            LoginDialog.this.displayError(Utils.getMessageForException((NamingException)throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                        }
                    } else if (throwable instanceof ApplicationException) {
                        LoginDialog.this.displayError(((ApplicationException)throwable).getMessageObject(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    } else {
                        LOG.log(Level.SEVERE, "Unexpected throwable: " + throwable, throwable);
                        LoginDialog.this.displayError(Utils.getThrowableMsg(QuickSetupMessages.INFO_BUG_MSG.get(), throwable), QuickSetupMessages.INFO_ERROR_TITLE.get());
                    }
                    LoginDialog.this.cancelButton.setEnabled(true);
                    LoginDialog.this.okButton.setEnabled(true);
                } else {
                    if (Boolean.FALSE.equals(returnValue)) {
                        LoginDialog.this.displayInformationMessage(AdminToolMessages.INFO_LOGIN_DIALOG_SERVER_NOT_RUNNING_MSG.get(), AdminToolMessages.INFO_LOGIN_DIALOG_SERVER_NOT_RUNNING_TITLE.get());
                    } else {
                        String hostName = LoginDialog.this.tfHostName.getText();
                        if (hostName == null || hostName.trim().length() == 0) {
                            LoginDialog.this.displayError(QuickSetupMessages.INFO_EMPTY_REMOTE_HOST.get(), QuickSetupMessages.INFO_ERROR_TITLE.get());
                            UIFactory.setTextStyle(LoginDialog.this.lHostName, UIFactory.TextStyle.PRIMARY_FIELD_INVALID);
                        } else {
                            UIFactory.setTextStyle(LoginDialog.this.lHostName, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                        }
                    }
                    UIFactory.setTextStyle(LoginDialog.this.lUid, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                    UIFactory.setTextStyle(LoginDialog.this.lPwd, UIFactory.TextStyle.PRIMARY_FIELD_VALID);
                    LoginDialog.this.isCancelled = false;
                    LoginDialog.this.cancelButton.setEnabled(true);
                    LoginDialog.this.okButton.setEnabled(true);
                    LoginDialog.this.dispose();
                }
            }
        };
        this.cancelButton.setEnabled(false);
        this.okButton.setEnabled(false);
        worker.startBackgroundTask();
    }

    private void displayError(Message msg, Message title) {
        Utilities.displayError(this.parent, msg, title);
        this.toFront();
    }

    private void displayInformationMessage(Message msg, Message title) {
        Utilities.displayInformationMessage(this.parent, msg, title);
        this.toFront();
    }

    private boolean isServerRunning() {
        return Installation.getLocal().getStatus().isServerRunning();
    }

    private ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    private void handleCertificateException(UserDataCertificateException ce) {
        X509Certificate[] chain;
        CertificateDialog dlg = new CertificateDialog(this.parent, ce);
        dlg.pack();
        dlg.setVisible(true);
        if (dlg.getUserAnswer() != CertificateDialog.ReturnType.NOT_ACCEPTED) {
            chain = ce.getChain();
            String authType = ce.getAuthType();
            String host = ce.getHost();
            if (chain != null && authType != null && host != null) {
                LOG.log(Level.INFO, "Accepting certificate presented by host " + host);
                this.getTrustManager().acceptCertificate(chain, authType, host);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoginDialog.this.okClicked();
                    }
                });
            } else {
                if (chain == null) {
                    LOG.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    LOG.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    LOG.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
        }
        if (dlg.getUserAnswer() == CertificateDialog.ReturnType.ACCEPTED_PERMANENTLY && (chain = ce.getChain()) != null) {
            try {
                UIKeyStore.acceptCertificate(chain);
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error accepting certificate: " + t, t);
            }
        }
    }

    public static void main(String[] args) {
        try {
            LoginDialog dlg = new LoginDialog(org.opends.guitools.controlpanel.util.Utilities.createFrame(), new ApplicationTrustManager(null));
            dlg.pack();
            dlg.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

