/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.util.HashSet;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.util.SchemaLoader;
import org.opends.server.config.ConfigException;
import org.opends.server.schema.AttributeTypeSyntax;
import org.opends.server.schema.ObjectClassSyntax;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Schema;

public class RemoteSchemaLoader
extends SchemaLoader {
    private Schema schema;

    public void readSchema(InitialLdapContext ctx) throws NamingException, DirectoryException, InitializationException, ConfigException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(0);
        String[] schemaAttrs = new String[]{"objectclasses", "attributetypes"};
        searchControls.setReturningAttributes(schemaAttrs);
        String filter = "(|(objectClass=*)(objectClass=ldapsubentry))";
        NamingEnumeration<SearchResult> srs = ctx.search("cn=schema", filter, searchControls);
        SearchResult sr = srs.next();
        CustomSearchResult csr = new CustomSearchResult(sr, "cn=schema");
        this.schema = this.getBaseSchema();
        List<Object> attrs = csr.getAttributeValues("attributetypes");
        HashSet<String> remainingAttrs = new HashSet<String>();
        for (Object o : attrs) {
            remainingAttrs.add((String)o);
        }
        while (!remainingAttrs.isEmpty()) {
            DirectoryException lastException = null;
            boolean oneRegistered = false;
            HashSet<String> registeredAttrs = new HashSet<String>();
            for (String attrDefinition : remainingAttrs) {
                ByteStringBuilder sb = new ByteStringBuilder();
                sb.append(attrDefinition);
                try {
                    AttributeType attrType = AttributeTypeSyntax.decodeAttributeType(sb, this.schema, false);
                    this.schema.registerAttributeType(attrType, true);
                    oneRegistered = true;
                    registeredAttrs.add(attrDefinition);
                }
                catch (DirectoryException de) {
                    lastException = de;
                }
            }
            if (!oneRegistered) {
                throw lastException;
            }
            remainingAttrs.removeAll(registeredAttrs);
        }
        List<Object> objectClasses = csr.getAttributeValues("objectclasses");
        HashSet<String> remainingOcs = new HashSet<String>();
        for (Object o : objectClasses) {
            remainingOcs.add((String)o);
        }
        while (!remainingOcs.isEmpty()) {
            DirectoryException lastException = null;
            boolean oneRegistered = false;
            HashSet<String> registeredOcs = new HashSet<String>();
            for (String ocDefinition : remainingOcs) {
                ByteStringBuilder sb = new ByteStringBuilder();
                sb.append(ocDefinition);
                try {
                    ObjectClass oc = ObjectClassSyntax.decodeObjectClass(sb, this.schema, false);
                    this.schema.registerObjectClass(oc, true);
                    oneRegistered = true;
                    registeredOcs.add(ocDefinition);
                }
                catch (DirectoryException de) {
                    lastException = de;
                }
            }
            if (!oneRegistered) {
                throw lastException;
            }
            remainingOcs.removeAll(registeredOcs);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }
}

