/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.api.ConfigHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryEnvironmentConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.LDIFException;
import org.opends.server.util.LDIFReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyConfigFileHandler
extends ConfigHandler {
    private HashMap<DN, ConfigEntry> configEntries = new HashMap();
    private ConfigEntry configRootEntry;
    private String serverRoot;
    private String instanceRoot;
    private final Set<String> emptyStringSet = new HashSet<String>();
    private DN[] baseDNs;

    @Override
    public void finalizeConfigHandler() {
    }

    @Override
    public ConfigEntry getConfigEntry(DN entryDN) throws ConfigException {
        return this.configEntries.get(entryDN);
    }

    @Override
    public ConfigEntry getConfigRootEntry() throws ConfigException {
        return this.configRootEntry;
    }

    @Override
    public String getServerRoot() {
        return this.serverRoot;
    }

    @Override
    public String getInstanceRoot() {
        return this.instanceRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initializeConfigHandler(String configFile, boolean checkSchema) throws InitializationException {
        File f = new File(configFile);
        LDIFReader reader = null;
        try {
            try {
                LDIFImportConfig importConfig = new LDIFImportConfig(f.getAbsolutePath());
                reader = new LDIFReader(importConfig);
            }
            catch (Throwable t) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_CANNOT_OPEN_FOR_READ.get(f.getAbsolutePath(), String.valueOf(t));
                throw new InitializationException(message, t);
            }
            if (!f.exists()) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_DOES_NOT_EXIST.get(f.getAbsolutePath());
                throw new InitializationException(message);
            }
            this.configEntries.clear();
            try {
                Entry entry = reader.readEntry(checkSchema);
                if (entry == null) {
                    Message message = ConfigMessages.ERR_CONFIG_FILE_EMPTY.get(f.getAbsolutePath());
                    throw new InitializationException(message);
                }
                this.configRootEntry = new ConfigEntry(entry, null);
                this.baseDNs = new DN[]{this.configRootEntry.getDN()};
                this.configEntries.put(entry.getDN(), this.configRootEntry);
                while (entry != null) {
                    entry = reader.readEntry(checkSchema);
                    if (entry == null) continue;
                    DN entryDN = entry.getDN();
                    DN parentDN = entryDN.getParent();
                    ConfigEntry parentEntry = null;
                    if (parentDN != null) {
                        parentEntry = this.configEntries.get(parentDN);
                    }
                    if (parentEntry == null) {
                        Message message;
                        if (parentDN == null) {
                            message = ConfigMessages.ERR_CONFIG_FILE_UNKNOWN_PARENT.get(entryDN.toString(), reader.getLastEntryLineNumber(), f.getAbsolutePath());
                            throw new InitializationException(message);
                        }
                        message = ConfigMessages.ERR_CONFIG_FILE_NO_PARENT.get(entryDN.toString(), reader.getLastEntryLineNumber(), f.getAbsolutePath(), parentDN.toString());
                        throw new InitializationException(message);
                    }
                    ConfigEntry configEntry = new ConfigEntry(entry, parentEntry);
                    parentEntry.addChild(configEntry);
                    this.configEntries.put(entryDN, configEntry);
                }
            }
            catch (InitializationException ie) {
                throw ie;
            }
            catch (LDIFException le) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_INVALID_LDIF_ENTRY.get(le.getLineNumber(), f.getAbsolutePath(), String.valueOf(le));
                throw new InitializationException(message, (Throwable)le);
            }
            catch (Throwable t) {
                Message message = ConfigMessages.ERR_CONFIG_FILE_READ_ERROR.get(f.getAbsolutePath(), String.valueOf(t));
                throw new InitializationException(message, t);
            }
            File rootFile = DirectoryServer.getEnvironmentConfig().getServerRoot();
            this.serverRoot = rootFile.getAbsolutePath();
            File instanceRootFile = DirectoryEnvironmentConfig.getInstanceRootFromServerRoot(rootFile);
            this.instanceRoot = instanceRootFile.getAbsolutePath();
        }
        catch (InitializationException ie) {
            throw ie;
        }
        catch (Throwable t) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    @Override
    public void writeSuccessfulStartupConfig() {
    }

    @Override
    public void writeUpdatedConfig() throws DirectoryException {
    }

    @Override
    public void addEntry(Entry arg0, AddOperation arg1) throws DirectoryException, CanceledOperationException {
    }

    @Override
    public void configureBackend(Configuration arg0) throws ConfigException {
    }

    @Override
    public void createBackup(BackupConfig arg0) throws DirectoryException {
    }

    @Override
    public void deleteEntry(DN arg0, DeleteOperation arg1) throws DirectoryException, CanceledOperationException {
    }

    @Override
    public void exportLDIF(LDIFExportConfig arg0) throws DirectoryException {
    }

    @Override
    public void finalizeBackend() {
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        ConfigEntry configEntry = this.configEntries.get(entryDN);
        if (configEntry == null) {
            return null;
        }
        return configEntry.getEntry();
    }

    @Override
    public long getEntryCount() {
        return this.configEntries.size();
    }

    @Override
    public Set<String> getSupportedControls() {
        return this.emptyStringSet;
    }

    @Override
    public Set<String> getSupportedFeatures() {
        return this.emptyStringSet;
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        ConfigEntry baseEntry = this.configEntries.get(entryDN);
        if (baseEntry == null) {
            return ConditionResult.UNDEFINED;
        }
        if (baseEntry.hasChildren()) {
            return ConditionResult.TRUE;
        }
        return ConditionResult.FALSE;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig arg0) throws DirectoryException {
        return null;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
    }

    @Override
    public boolean isIndexed(AttributeType arg0, IndexType arg1) {
        return false;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        ConfigEntry baseEntry = this.configEntries.get(entryDN);
        if (baseEntry == null) {
            return -1L;
        }
        if (!subtree) {
            return baseEntry.getChildren().size();
        }
        long count = 0L;
        for (ConfigEntry child : baseEntry.getChildren().values()) {
            count += this.numSubordinates(child.getDN(), true);
            ++count;
        }
        return count;
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
    }

    @Override
    public void removeBackup(BackupDirectory arg0, String arg1) throws DirectoryException {
    }

    @Override
    public void renameEntry(DN arg0, Entry arg1, ModifyDNOperation arg2) throws DirectoryException, CanceledOperationException {
    }

    @Override
    public void replaceEntry(Entry arg0, Entry arg1, ModifyOperation arg2) throws DirectoryException, CanceledOperationException {
    }

    @Override
    public void restoreBackup(RestoreConfig arg0) throws DirectoryException {
    }

    @Override
    public void search(SearchOperation arg0) throws DirectoryException, CanceledOperationException {
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig arg0, StringBuilder arg1) {
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }
}

