/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class ProcessReader {
    private BufferedReader reader;
    private Thread readerThread;
    private Throwable lastException;
    private boolean interrupt;
    private boolean done;

    public ProcessReader(Process process, final PrintStream printStream, boolean isError) {
        InputStream is = isError ? process.getErrorStream() : process.getInputStream();
        this.reader = new BufferedReader(new InputStreamReader(is));
        this.readerThread = new Thread(new Runnable(){

            public void run() {
                try {
                    String line;
                    while (!ProcessReader.this.interrupt && null != (line = ProcessReader.this.reader.readLine())) {
                        printStream.println(line);
                    }
                }
                catch (Throwable t) {
                    ProcessReader.this.lastException = t;
                }
                ProcessReader.this.done = true;
            }
        });
    }

    public void startReading() {
        this.readerThread.start();
    }

    public void interrupt() {
        this.interrupt = true;
        while (!this.done) {
            try {
                this.readerThread.interrupt();
            }
            catch (Throwable throwable) {}
        }
    }

    public Throwable getLastException() {
        return this.lastException;
    }
}

