/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.net.InetAddress;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.RemoteSchemaLoader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.AdministrationConnectorCfgClient;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.client.BackupBackendCfgClient;
import org.opends.server.admin.std.client.ConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.CryptoManagerCfgClient;
import org.opends.server.admin.std.client.JMXConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.LDAPConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.LDIFBackendCfgClient;
import org.opends.server.admin.std.client.LDIFConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.LocalDBIndexCfgClient;
import org.opends.server.admin.std.client.LocalDBVLVIndexCfgClient;
import org.opends.server.admin.std.client.MemoryBackendCfgClient;
import org.opends.server.admin.std.client.MonitorBackendCfgClient;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.client.RootDNCfgClient;
import org.opends.server.admin.std.client.RootDNUserCfgClient;
import org.opends.server.admin.std.client.SNMPConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.TaskBackendCfgClient;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.tasks.TaskEntry;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFromDirContext
extends ConfigReader {
    private static final String DATABASE_ENVIRONMENT_SUFFIX = " Database Environment";
    private static final Logger LOG = Logger.getLogger(ConfigFromDirContext.class.getName());
    private CustomSearchResult rootMonitor;
    private CustomSearchResult jvmMemoryUsage;
    private CustomSearchResult systemInformation;
    private CustomSearchResult entryCaches;
    private CustomSearchResult workQueue;
    private CustomSearchResult versionMonitor;
    private boolean isLocal = true;
    private Map<String, CustomSearchResult> hmConnectionHandlersMonitor = new HashMap<String, CustomSearchResult>();
    protected DN monitorDN = DN.nullDN();
    protected DN jvmMemoryUsageDN = DN.nullDN();
    protected DN systemInformationDN = DN.nullDN();
    protected DN entryCachesDN = DN.nullDN();
    protected DN workQueueDN = DN.nullDN();
    protected DN versionDN = DN.nullDN();
    public static final SimpleDateFormat utcParser = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
    public static final DateFormat formatter = DateFormat.getDateTimeInstance();

    public ConfigFromDirContext() {
        try {
            this.monitorDN = DN.decode("cn=monitor");
            this.jvmMemoryUsageDN = DN.decode("cn=JVM Memory Usage,cn=monitor");
            this.systemInformationDN = DN.decode("cn=System Information,cn=monitor");
            this.entryCachesDN = DN.decode("cn=Entry Caches,cn=monitor");
            this.workQueueDN = DN.decode("cn=Work Queue,cn=monitor");
            this.versionDN = DN.decode("cn=Version,cn=monitor");
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not decode DNs: " + t, t);
        }
        utcParser.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public CustomSearchResult getEntryCaches() {
        return this.entryCaches;
    }

    public CustomSearchResult getJvmMemoryUsage() {
        return this.jvmMemoryUsage;
    }

    public CustomSearchResult getRootMonitor() {
        return this.rootMonitor;
    }

    public CustomSearchResult getVersionMonitor() {
        return this.versionMonitor;
    }

    public CustomSearchResult getSystemInformation() {
        return this.systemInformation;
    }

    public CustomSearchResult getWorkQueue() {
        return this.workQueue;
    }

    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    /*
     * WARNING - void declaration
     */
    public void readConfiguration(InitialLdapContext ctx) {
        OnlineUpdateException oupe;
        ArrayList<OpenDsException> ex = new ArrayList<OpenDsException>();
        HashSet<ConnectionHandlerDescriptor> ls = new HashSet<ConnectionHandlerDescriptor>();
        HashSet<BackendDescriptor> bs = new HashSet<BackendDescriptor>();
        HashSet<DN> as = new HashSet<DN>();
        HashSet<TaskEntry> ts = new HashSet<TaskEntry>();
        this.rootMonitor = null;
        this.jvmMemoryUsage = null;
        this.systemInformation = null;
        this.entryCaches = null;
        this.workQueue = null;
        this.versionMonitor = null;
        this.hmConnectionHandlersMonitor.clear();
        if (this.mustReadSchema()) {
            try {
                this.readSchema(ctx);
                if (this.getSchema() != null) {
                    DirectoryServer.setSchema(this.getSchema());
                }
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
        }
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            try {
                AdministrationConnectorCfgClient adminConnector = root.getAdministrationConnector();
                this.adminConnector = this.getConnectionHandler(adminConnector);
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
            String[] connectionHandlers = root.listConnectionHandlers();
            for (int i = 0; i < connectionHandlers.length; ++i) {
                try {
                    ConnectionHandlerCfgClient connectionHandler = root.getConnectionHandler(connectionHandlers[i]);
                    ls.add(this.getConnectionHandler(connectionHandler, connectionHandlers[i]));
                    continue;
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            this.isSchemaEnabled = root.getGlobalConfiguration().isCheckSchema();
            String[] backendNames = root.listBackends();
            for (int i = 0; i < backendNames.length; ++i) {
                try {
                    BackendDescriptor.Type type;
                    BackendCfgClient backend = root.getBackend(backendNames[i]);
                    TreeSet<BaseDNDescriptor> baseDNs = new TreeSet<BaseDNDescriptor>();
                    for (DN dn : backend.getBaseDN()) {
                        BaseDNDescriptor baseDN = new BaseDNDescriptor(BaseDNDescriptor.Type.NOT_REPLICATED, dn, null, -1, -1L, -1);
                        baseDNs.add(baseDN);
                    }
                    TreeSet<IndexDescriptor> indexes = new TreeSet<IndexDescriptor>();
                    TreeSet<VLVIndexDescriptor> vlvIndexes = new TreeSet<VLVIndexDescriptor>();
                    if (backend instanceof LocalDBBackendCfgClient) {
                        type = BackendDescriptor.Type.LOCAL_DB;
                        LocalDBBackendCfgClient db = (LocalDBBackendCfgClient)backend;
                        String[] indexNames = db.listLocalDBIndexes();
                        try {
                            void var19_39;
                            boolean bl = false;
                            while (var19_39 < indexNames.length) {
                                LocalDBIndexCfgClient index = db.getLocalDBIndex(indexNames[var19_39]);
                                indexes.add(new IndexDescriptor(index.getAttribute().getNameOrOID(), index.getAttribute(), null, index.getIndexType(), index.getIndexEntryLimit()));
                                ++var19_39;
                            }
                        }
                        catch (OpenDsException openDsException) {
                            ex.add(openDsException);
                        }
                        indexes.add(new IndexDescriptor("dn2id", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        indexes.add(new IndexDescriptor("id2children", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        indexes.add(new IndexDescriptor("id2subtree", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        String[] stringArray = db.listLocalDBVLVIndexes();
                        try {
                            for (int j = 0; j < stringArray.length; ++j) {
                                LocalDBVLVIndexCfgClient index = db.getLocalDBVLVIndex(stringArray[j]);
                                String s = index.getSortOrder();
                                List<VLVSortOrder> sortOrder = this.getVLVSortOrder(s);
                                vlvIndexes.add(new VLVIndexDescriptor(index.getName(), null, index.getBaseDN(), index.getScope(), index.getFilter(), sortOrder, index.getMaxBlockSize()));
                            }
                        }
                        catch (OpenDsException oe) {
                            ex.add(oe);
                        }
                    } else {
                        type = backend instanceof LDIFBackendCfgClient ? BackendDescriptor.Type.LDIF : (backend instanceof MemoryBackendCfgClient ? BackendDescriptor.Type.MEMORY : (backend instanceof BackupBackendCfgClient ? BackendDescriptor.Type.BACKUP : (backend instanceof MonitorBackendCfgClient ? BackendDescriptor.Type.MONITOR : (backend instanceof TaskBackendCfgClient ? BackendDescriptor.Type.TASK : BackendDescriptor.Type.OTHER))));
                    }
                    BackendDescriptor desc = new BackendDescriptor(backend.getBackendId(), baseDNs, indexes, vlvIndexes, -1, backend.isEnabled(), type);
                    for (IndexDescriptor indexDescriptor : indexes) {
                        indexDescriptor.setBackend(desc);
                    }
                    for (VLVIndexDescriptor vLVIndexDescriptor : vlvIndexes) {
                        vLVIndexDescriptor.setBackend(desc);
                    }
                    for (BaseDNDescriptor baseDNDescriptor : baseDNs) {
                        baseDNDescriptor.setBackend(desc);
                    }
                    bs.add(desc);
                    continue;
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            boolean isReplicationSecure = false;
            try {
                CryptoManagerCfgClient cryptoManager = root.getCryptoManager();
                isReplicationSecure = cryptoManager.isSSLEncryption();
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
            this.replicationPort = -1;
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (OpenDsException oe) {
                // empty catch block
            }
            if (sync != null) {
                try {
                    String[] domains;
                    ReplicationServerCfgClient replicationServer;
                    if (sync.isEnabled().booleanValue() && sync.hasReplicationServer() && (replicationServer = sync.getReplicationServer()) != null) {
                        this.replicationPort = replicationServer.getReplicationPort();
                        ConnectionHandlerDescriptor.Protocol protocol = isReplicationSecure ? ConnectionHandlerDescriptor.Protocol.REPLICATION_SECURE : ConnectionHandlerDescriptor.Protocol.REPLICATION;
                        Set<CustomSearchResult> emptySet = Collections.emptySet();
                        ConnectionHandlerDescriptor connHandler = new ConnectionHandlerDescriptor(new HashSet<InetAddress>(), this.replicationPort, protocol, ConnectionHandlerDescriptor.State.ENABLED, "Multimaster Synchronization", emptySet);
                        ls.add(connHandler);
                    }
                    if ((domains = sync.listReplicationDomains()) != null) {
                        for (int i = 0; i < domains.length; ++i) {
                            ReplicationDomainCfgClient domain = sync.getReplicationDomain(domains[i]);
                            DN dn = domain.getBaseDN();
                            for (BackendDescriptor backend : bs) {
                                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                                    if (!baseDN.getDn().equals(dn)) continue;
                                    baseDN.setType(BaseDNDescriptor.Type.REPLICATED);
                                    baseDN.setReplicaID(domain.getServerId());
                                }
                            }
                        }
                    }
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            try {
                RootDNCfgClient rootDN = root.getRootDN();
                String[] rootUsers = rootDN.listRootDNUsers();
                if (rootUsers != null) {
                    for (int i = 0; i < rootUsers.length; ++i) {
                        RootDNUserCfgClient rootUser = rootDN.getRootDNUser(rootUsers[i]);
                        as.addAll(rootUser.getAlternateBindDN());
                    }
                }
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
        }
        catch (Throwable t) {
            oupe = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.toString()), t);
            ex.add(oupe);
        }
        for (OpenDsException oe : ex) {
            LOG.log(Level.WARNING, "Error reading configuration: " + oe, oe);
        }
        this.administrativeUsers = Collections.unmodifiableSet(as);
        this.listeners = Collections.unmodifiableSet(ls);
        this.backends = Collections.unmodifiableSet(bs);
        try {
            this.updateMonitorInformation(ctx, ex);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error reading monitoring: " + t, t);
            oupe = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.toString()), t);
            ex.add(oupe);
        }
        try {
            this.updateTaskInformation(ctx, ex, ts);
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error reading task information: " + t, t);
            oupe = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.toString()), t);
            ex.add(oupe);
        }
        this.taskEntries = Collections.unmodifiableSet(ts);
        for (ConnectionHandlerDescriptor ch : this.getConnectionHandlers()) {
            ch.setMonitoringEntries(this.getMonitoringEntries(ch));
        }
        if (this.adminConnector != null) {
            this.adminConnector.setMonitoringEntries(this.getMonitoringEntries(this.adminConnector));
        }
        this.exceptions = Collections.unmodifiableList(ex);
    }

    protected String[] getMonitoringAttributes() {
        return new String[]{"*"};
    }

    private void readSchema(InitialLdapContext ctx) throws OpenDsException {
        if (this.isLocal) {
            super.readSchema();
        } else {
            RemoteSchemaLoader loader = new RemoteSchemaLoader();
            try {
                loader.readSchema(ctx);
            }
            catch (NamingException ne) {
                throw new OnlineUpdateException(AdminToolMessages.ERR_READING_SCHEMA_LDAP.get(ne.toString()), (Throwable)ne);
            }
            this.schema = loader.getSchema();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleMonitoringSearchResult(SearchResult sr, String searchBaseDN) throws NamingException {
        String v;
        if (this.javaVersion == null) {
            this.javaVersion = ConnectionUtils.getFirstValue(sr, "javaVersion");
        }
        if (this.numberConnections == -1 && (v = ConnectionUtils.getFirstValue(sr, "currentConnections")) != null) {
            this.numberConnections = Integer.parseInt(v);
        }
        String dn = ConnectionUtils.getFirstValue(sr, "domain-name");
        String replicaId = ConnectionUtils.getFirstValue(sr, "server-id");
        String missingChanges = ConnectionUtils.getFirstValue(sr, "missing-changes");
        if (dn != null && replicaId != null && missingChanges != null) {
            for (BackendDescriptor backend : this.backends) {
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    try {
                        if (!baseDN.getDn().equals(DN.decode(dn)) || !String.valueOf(baseDN.getReplicaID()).equals(replicaId)) continue;
                        try {
                            baseDN.setAgeOfOldestMissingChange(new Long(ConnectionUtils.getFirstValue(sr, "approx-older-change-not-synchronized-millis")));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            baseDN.setMissingChanges(new Integer(missingChanges));
                        }
                        catch (Throwable t) {
                        }
                    }
                    catch (Throwable t) {}
                }
            }
            return;
        }
        CustomSearchResult csr = new CustomSearchResult(sr, searchBaseDN);
        String backendID = ConnectionUtils.getFirstValue(sr, "ds-backend-id");
        String entryCount = ConnectionUtils.getFirstValue(sr, "ds-backend-entry-count");
        Set<String> baseDnEntries = ConnectionUtils.getValues(sr, "ds-base-dn-entry-count");
        if (backendID != null && (entryCount != null || baseDnEntries != null)) {
            for (BackendDescriptor backend : this.backends) {
                if (!backend.getBackendID().equalsIgnoreCase(backendID)) continue;
                if (entryCount != null) {
                    backend.setEntries(Integer.parseInt(entryCount));
                }
                if (baseDnEntries == null) continue;
                block13: for (String s : baseDnEntries) {
                    int index = s.indexOf(" ");
                    if (index == -1) continue;
                    for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                        dn = s.substring(index + 1);
                        if (!Utilities.areDnsEqual(dn, baseDN.getDn().toString())) continue;
                        try {
                            baseDN.setEntries(Integer.parseInt(s.substring(0, index)));
                        }
                        catch (Throwable t) {}
                        continue block13;
                    }
                }
            }
        } else {
            String cn = ConnectionUtils.getFirstValue(sr, "cn");
            if (cn != null && cn.endsWith(DATABASE_ENVIRONMENT_SUFFIX)) {
                String monitorBackendID = cn.substring(0, cn.length() - DATABASE_ENVIRONMENT_SUFFIX.length());
                for (BackendDescriptor backend : this.backends) {
                    if (!backend.getBackendID().equalsIgnoreCase(monitorBackendID)) continue;
                    backend.setMonitoringEntry(csr);
                }
            }
        }
        try {
            if (this.rootMonitor == null && this.isRootMonitor(csr)) {
                this.rootMonitor = csr;
                return;
            }
            if (this.entryCaches == null && this.isEntryCaches(csr)) {
                this.entryCaches = csr;
                return;
            }
            if (this.workQueue == null && this.isWorkQueue(csr)) {
                this.workQueue = csr;
                return;
            }
            if (this.jvmMemoryUsage == null && this.isJvmMemoryUsage(csr)) {
                this.jvmMemoryUsage = csr;
                return;
            }
            if (this.systemInformation == null && this.isSystemInformation(csr)) {
                this.systemInformation = csr;
                return;
            }
            if (this.versionMonitor == null && this.isVersionMonitor(csr)) {
                this.versionMonitor = csr;
                return;
            }
            if (!this.isConnectionHandler(csr)) return;
            String statistics = " Statistics";
            String cn = ConnectionUtils.getFirstValue(sr, "cn");
            if (!cn.endsWith(statistics)) return;
            String name = cn.substring(0, cn.length() - statistics.length());
            this.hmConnectionHandlersMonitor.put(this.getKey(name), csr);
            return;
        }
        catch (OpenDsException ode) {
            this.exceptions.add(ode);
        }
    }

    protected void handleTaskSearchResult(SearchResult sr, String searchBaseDN, Collection<TaskEntry> taskEntries) throws NamingException {
        CustomSearchResult csr = new CustomSearchResult(sr, searchBaseDN);
        try {
            if (this.isTaskEntry(csr)) {
                taskEntries.add(new TaskEntry(csr.getEntry()));
            }
        }
        catch (OpenDsException ode) {
            this.exceptions.add(ode);
        }
    }

    private void updateMonitorInformation(InitialLdapContext ctx, List<OpenDsException> ex) {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(this.getMonitoringAttributes());
        String filter = "(objectclass=*)";
        try {
            LdapName jndiName = new LdapName("cn=monitor");
            NamingEnumeration<SearchResult> monitorEntries = ctx.search((Name)jndiName, filter, ctls);
            this.javaVersion = null;
            this.numberConnections = -1;
            while (monitorEntries.hasMore()) {
                SearchResult sr = monitorEntries.next();
                this.handleMonitoringSearchResult(sr, "cn=monitor");
            }
        }
        catch (NamingException ne) {
            OnlineUpdateException oue = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(ne.getMessage().toString()), (Throwable)ne);
            ex.add(oue);
        }
    }

    private void updateTaskInformation(InitialLdapContext ctx, List<OpenDsException> ex, Collection<TaskEntry> ts) {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(this.getMonitoringAttributes());
        String filter = "(objectclass=ds-task)";
        try {
            LdapName jndiName = new LdapName("cn=Tasks");
            NamingEnumeration<SearchResult> taskEntries = ctx.search((Name)jndiName, filter, ctls);
            while (taskEntries.hasMore()) {
                SearchResult sr = taskEntries.next();
                this.handleTaskSearchResult(sr, "cn=Tasks", ts);
            }
        }
        catch (NamingException ne) {
            OnlineUpdateException oue = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(ne.getMessage().toString()), (Throwable)ne);
            ex.add(oue);
        }
    }

    private ConnectionHandlerDescriptor getConnectionHandler(ConnectionHandlerCfgClient connHandler, String name) throws OpenDsException {
        int port;
        ConnectionHandlerDescriptor.Protocol protocol;
        ConnectionHandlerDescriptor.State state;
        TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(this.getInetAddressComparator());
        ConnectionHandlerDescriptor.State state2 = state = connHandler.isEnabled() != false ? ConnectionHandlerDescriptor.State.ENABLED : ConnectionHandlerDescriptor.State.DISABLED;
        if (connHandler instanceof LDAPConnectionHandlerCfgClient) {
            LDAPConnectionHandlerCfgClient ldap = (LDAPConnectionHandlerCfgClient)connHandler;
            protocol = ldap.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.LDAPS : (ldap.isAllowStartTLS() ? ConnectionHandlerDescriptor.Protocol.LDAP_STARTTLS : ConnectionHandlerDescriptor.Protocol.LDAP);
            SortedSet<InetAddress> v = ldap.getListenAddress();
            if (v != null) {
                addresses.addAll(v);
            }
            port = ldap.getListenPort();
        } else if (connHandler instanceof JMXConnectionHandlerCfgClient) {
            JMXConnectionHandlerCfgClient jmx = (JMXConnectionHandlerCfgClient)connHandler;
            protocol = jmx.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.JMXS : ConnectionHandlerDescriptor.Protocol.JMX;
            SortedSet<InetAddress> v = jmx.getListenAddress();
            if (v != null) {
                addresses.addAll(v);
            }
            port = jmx.getListenPort();
        } else if (connHandler instanceof LDIFConnectionHandlerCfgClient) {
            protocol = ConnectionHandlerDescriptor.Protocol.LDIF;
            port = -1;
        } else if (connHandler instanceof SNMPConnectionHandlerCfgClient) {
            protocol = ConnectionHandlerDescriptor.Protocol.SNMP;
            SNMPConnectionHandlerCfgClient snmp = (SNMPConnectionHandlerCfgClient)connHandler;
            SortedSet<InetAddress> v = snmp.getListenAddress();
            if (v != null) {
                addresses.addAll(v);
            }
            port = snmp.getListenPort();
        } else {
            protocol = ConnectionHandlerDescriptor.Protocol.OTHER;
            port = -1;
        }
        Set<CustomSearchResult> emptySet = Collections.emptySet();
        return new ConnectionHandlerDescriptor(addresses, port, protocol, state, name, emptySet);
    }

    private ConnectionHandlerDescriptor getConnectionHandler(AdministrationConnectorCfgClient adminConnector) throws OpenDsException {
        TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(this.getInetAddressComparator());
        ConnectionHandlerDescriptor.Protocol protocol = ConnectionHandlerDescriptor.Protocol.ADMINISTRATION_CONNECTOR;
        ConnectionHandlerDescriptor.State state = ConnectionHandlerDescriptor.State.ENABLED;
        SortedSet<InetAddress> v = adminConnector.getListenAddress();
        if (v != null) {
            addresses.addAll(v);
        }
        int port = adminConnector.getListenPort();
        Set<CustomSearchResult> emptySet = Collections.emptySet();
        return new ConnectionHandlerDescriptor(addresses, port, protocol, state, AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_ADMINISTRATION.get().toString(), emptySet);
    }

    private boolean isRootMonitor(CustomSearchResult csr) throws OpenDsException {
        return this.monitorDN.equals(DN.decode(csr.getDN()));
    }

    private boolean isVersionMonitor(CustomSearchResult csr) throws OpenDsException {
        return this.versionDN.equals(DN.decode(csr.getDN()));
    }

    private boolean isSystemInformation(CustomSearchResult csr) throws OpenDsException {
        return this.systemInformationDN.equals(DN.decode(csr.getDN()));
    }

    private boolean isJvmMemoryUsage(CustomSearchResult csr) throws OpenDsException {
        return this.jvmMemoryUsageDN.equals(DN.decode(csr.getDN()));
    }

    private boolean isWorkQueue(CustomSearchResult csr) throws OpenDsException {
        return this.workQueueDN.equals(DN.decode(csr.getDN()));
    }

    private boolean isEntryCaches(CustomSearchResult csr) throws OpenDsException {
        return this.entryCachesDN.equals(DN.decode(csr.getDN()));
    }

    private boolean isConnectionHandler(CustomSearchResult csr) throws OpenDsException {
        String statistics;
        String cn;
        List<Object> vs;
        boolean isConnectionHandler = false;
        DN dn = DN.decode(csr.getDN());
        DN parent = dn.getParent();
        if (parent != null && parent.equals(this.monitorDN) && (vs = csr.getAttributeValues("cn")) != null && !vs.isEmpty() && (cn = (String)vs.iterator().next()).endsWith(statistics = " Statistics")) {
            isConnectionHandler = true;
        }
        return isConnectionHandler;
    }

    private boolean isTaskEntry(CustomSearchResult csr) throws OpenDsException {
        boolean isTaskEntry = false;
        List<Object> vs = csr.getAttributeValues("objectclass");
        if (vs != null && !vs.isEmpty()) {
            for (Object oc : vs) {
                if (!oc.toString().equalsIgnoreCase("ds-task")) continue;
                isTaskEntry = true;
                break;
            }
        }
        return isTaskEntry;
    }

    private String getKey(String value) {
        return value.toLowerCase();
    }

    private Set<CustomSearchResult> getMonitoringEntries(ConnectionHandlerDescriptor ch) {
        HashSet<CustomSearchResult> monitorEntries = new HashSet<CustomSearchResult>();
        if (ch.getState() == ConnectionHandlerDescriptor.State.ENABLED) {
            for (String key : this.hmConnectionHandlersMonitor.keySet()) {
                if (key.indexOf(this.getKey("port " + ch.getPort())) == -1) continue;
                boolean hasAllAddresses = true;
                for (InetAddress a : ch.getAddresses()) {
                    if (key.indexOf(this.getKey(a.getHostAddress())) != -1) continue;
                    hasAllAddresses = false;
                    break;
                }
                if (!hasAllAddresses) continue;
                monitorEntries.add(this.hmConnectionHandlersMonitor.get(key));
            }
        }
        return monitorEntries;
    }
}

