/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.ScheduleType;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.TaskToSchedulePanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class ScheduleSummaryPanel
extends JPanel {
    private static final long serialVersionUID = 3111141404599060028L;
    private ScheduleType schedule = ScheduleType.createLaunchNow();
    private JLabel label;
    private JButton change;
    private TaskToSchedulePanel schedulePanel;
    private GenericDialog scheduleDlg;
    private String taskName;
    private DateFormat formatter = DateFormat.getDateTimeInstance(0, 3);

    public ScheduleSummaryPanel(String taskName) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.taskName = taskName;
        this.createLayout();
    }

    public ScheduleType getSchedule() {
        return this.schedule;
    }

    public void setSchedule(ScheduleType schedule) {
        this.schedule = schedule;
        this.updateLabel(schedule);
    }

    public boolean isChangeEnabled() {
        return this.change.isEnabled();
    }

    public void setChangeEnabled(boolean enable) {
        this.change.setEnabled(enable);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.label = Utilities.createDefaultLabel();
        this.change = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CHANGE_SCHEDULE.get());
        this.change.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ScheduleSummaryPanel.this.changeButtonClicked();
            }
        });
        this.updateLabel(this.schedule);
        gbc.fill = 0;
        this.add((Component)this.label, gbc);
        ++gbc.gridx;
        gbc.insets.left = 10;
        this.add((Component)this.change, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 0;
        this.add(Box.createHorizontalGlue(), gbc);
    }

    private void updateLabel(ScheduleType schedule) {
        ScheduleType.Type type = schedule.getType();
        if (type == ScheduleType.Type.LAUNCH_NOW) {
            this.label.setText(AdminToolMessages.INFO_CTRL_PANEL_LAUNCH_NOW_SUMMARY.get().toString());
        } else if (type == ScheduleType.Type.LAUNCH_LATER) {
            Date date = schedule.getLaunchLaterDate();
            String sDate = this.formatter.format(date);
            this.label.setText(AdminToolMessages.INFO_CTRL_PANEL_LAUNCH_LATER_SUMMARY.get(sDate).toString());
        } else if (type == ScheduleType.Type.LAUNCH_PERIODICALLY) {
            String cron = schedule.getCronValue();
            this.label.setText(AdminToolMessages.INFO_CTRL_PANEL_LAUNCH_PERIODICALLY_SUMMARY.get(cron).toString());
        } else {
            throw new RuntimeException("Unknown schedule type: " + (Object)((Object)type));
        }
    }

    private void changeButtonClicked() {
        if (this.schedulePanel == null) {
            this.schedulePanel = new TaskToSchedulePanel(this.taskName);
            this.scheduleDlg = new GenericDialog(Utilities.getFrame(this), this.schedulePanel);
            Utilities.centerGoldenMean(this.scheduleDlg, Utilities.getParentDialog(this));
            this.scheduleDlg.setModal(true);
        }
        this.scheduleDlg.setVisible(true);
        if (!this.schedulePanel.isCancelled()) {
            this.setSchedule(this.schedulePanel.getSchedule());
        }
    }
}

