/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.opends.guitools.controlpanel.datamodel.ObjectClassValue;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.components.CellEditorButton;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;

public class ObjectClassCellPanel
extends JPanel {
    private static final long serialVersionUID = -2362754512894888888L;
    private JLabel label;
    private CellEditorButton editButton;
    private ObjectClassValue value;
    private JLabel lockLabel = Utilities.createDefaultLabel();
    private ImageIcon lockIcon = Utilities.createImageIcon("org/opends/guitools/controlpanel/images/field-locked.png");

    public ObjectClassCellPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.label = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_VALUE_SPECIFIED.get());
        gbc.weightx = 1.0;
        this.add((Component)this.label, gbc);
        ++gbc.gridx;
        this.editButton = new CellEditorButton(AdminToolMessages.INFO_CTRL_PANEL_EDIT_BUTTON_LABEL.get());
        this.editButton.setForeground(ColorAndFontConstants.buttonForeground);
        this.editButton.setOpaque(false);
        gbc.insets.left = 5;
        gbc.anchor = 11;
        gbc.weightx = 0.0;
        this.add((Component)this.editButton, gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 5;
        ++gbc.gridx;
        this.add((Component)this.lockLabel, gbc);
        this.lockLabel.setVisible(false);
    }

    public void setValue(ObjectClassValue value) {
        this.label.setText(this.getMessage(value).toString());
        this.value = value;
    }

    public ObjectClassValue getValue() {
        return this.value;
    }

    public void setLockIconVisible(boolean visible) {
        if (visible) {
            this.lockLabel.setIcon(this.lockIcon);
            this.lockLabel.setVisible(true);
        } else {
            this.lockLabel.setIcon(null);
            this.lockLabel.setVisible(false);
        }
    }

    public void requestFocusForButton() {
        this.editButton.requestFocusInWindow();
    }

    public void addEditActionListener(ActionListener listener) {
        this.editButton.addActionListener(listener);
    }

    public void removeEditActionListener(ActionListener listener) {
        this.editButton.removeActionListener(listener);
    }

    public void setEditButtonVisible(boolean visible) {
        this.editButton.setVisible(visible);
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return this.editButton.processKeyBinding(ks, e, condition, pressed);
    }

    public Message getMessage(ObjectClassValue value) {
        MessageBuilder sb = new MessageBuilder();
        if (value != null) {
            TreeSet<String> aux = new TreeSet<String>();
            aux.addAll(value.getAuxiliary());
            aux.remove("top");
            if (value.getStructural() != null) {
                sb.append(value.getStructural());
            }
            if (aux.size() > 0) {
                if (sb.length() > 0) {
                    sb.append("<br>");
                }
                sb.append(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_CELL_PANEL_AUXILIARY.get(Utilities.getStringFromCollection(aux, ", ")));
            }
        }
        if (sb.length() > 0) {
            return Message.raw("<html>" + Utilities.applyFont(sb.toString(), ColorAndFontConstants.defaultFont), new Object[0]);
        }
        return AdminToolMessages.INFO_CTRL_PANEL_NO_VALUE_SPECIFIED.get();
    }
}

