/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.Message;

public class LabelWithHelpIcon
extends JPanel {
    private static final long serialVersionUID = 4502977901538910797L;
    protected JLabel label = Utilities.createDefaultLabel();
    protected JLabel iconLabel = new JLabel(icon);
    private static final ImageIcon icon = Utilities.createImageIcon("org/opends/quicksetup/images/help_small.gif");
    protected final int INSET_WITH_ICON = 3;

    public LabelWithHelpIcon(Message text, Message tooltipIcon) {
        super(new GridBagLayout());
        this.setOpaque(false);
        this.label.setText(text.toString());
        this.label.setForeground(ColorAndFontConstants.foreground);
        if (tooltipIcon != null) {
            this.iconLabel.setToolTipText(tooltipIcon.toString());
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        this.add((Component)this.label, gbc);
        ++gbc.gridx;
        gbc.insets.left = 3;
        this.add((Component)this.iconLabel, gbc);
        gbc.insets.left = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add(Box.createHorizontalGlue(), gbc);
        Utilities.addClickTooltipListener(this.iconLabel);
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setFont(Font font) {
        if (this.label != null) {
            this.label.setFont(font);
        }
    }

    public void setHelpTooltip(String tooltip) {
        this.iconLabel.setToolTipText(tooltip);
    }

    public String getHelpTooltip() {
        return this.iconLabel.getToolTipText();
    }

    public void setHelpIconVisible(boolean visible) {
        if (visible) {
            if (this.iconLabel.getIcon() != icon) {
                this.iconLabel.setIcon(icon);
            }
        } else if (this.iconLabel.getIcon() != null) {
            this.iconLabel.setIcon(null);
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    public String getToolTipText(MouseEvent ev) {
        boolean display;
        int x = ev.getPoint().x;
        boolean bl = display = x > this.label.getPreferredSize().width - 10;
        if (display) {
            return this.getHelpTooltip();
        }
        return null;
    }
}

