/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui.components;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.ui.renderer.TreeCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;

public class CustomTree
extends JTree {
    private static final long serialVersionUID = -8351107707374485555L;
    private Set<MouseListener> mouseListeners;
    private JPopupMenu popupMenu;
    private final int MAX_ICON_HEIGHT = 18;

    public void paintComponent(Graphics g) {
        int[] selectedRows = this.getSelectionRows();
        if (selectedRows == null) {
            selectedRows = new int[]{};
        }
        Insets insets = this.getInsets();
        int w = this.getWidth() - insets.left - insets.right;
        int h = this.getHeight() - insets.top - insets.bottom;
        int x = insets.left;
        int y = insets.top;
        int nRows = this.getRowCount();
        for (int i = 0; i < nRows; ++i) {
            int rowHeight = this.getRowBounds((int)i).height;
            boolean isSelected = false;
            for (int j = 0; j < selectedRows.length; ++j) {
                if (selectedRows[j] != i) continue;
                isSelected = true;
                break;
            }
            if (isSelected) {
                g.setColor(TreeCellRenderer.selectionBackground);
            } else {
                g.setColor(TreeCellRenderer.nonselectionBackground);
            }
            g.fillRect(x, y, w, rowHeight);
            y += rowHeight;
        }
        int remainder = insets.top + h - y;
        if (remainder > 0) {
            g.setColor(TreeCellRenderer.nonselectionBackground);
            g.fillRect(x, y, w, remainder);
        }
        boolean isOpaque = this.isOpaque();
        this.setOpaque(false);
        super.paintComponent(g);
        this.setOpaque(isOpaque);
    }

    public void setPopupMenu(JPopupMenu popMenu) {
        this.popupMenu = popMenu;
    }

    public CustomTree() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        MouseAdapter mouseListener = new MouseAdapter(){
            private boolean ignoreEvents;

            public void mousePressed(MouseEvent ev) {
                if (this.ignoreEvents) {
                    return;
                }
                MouseEvent newEvent = this.getTranslatedEvent(ev);
                if (Utilities.isMacOS() && ev.isPopupTrigger() && ev.getButton() != 1) {
                    MouseEvent baseEvent = ev;
                    if (newEvent != null) {
                        baseEvent = newEvent;
                    }
                    int mods = baseEvent.getModifiersEx();
                    mods &= 0x3C0;
                    MouseEvent macEvent = new MouseEvent(baseEvent.getComponent(), baseEvent.getID(), System.currentTimeMillis(), mods |= 0x400, baseEvent.getX(), baseEvent.getY(), baseEvent.getClickCount(), false, 1);
                    this.notifyNewEvent(macEvent, NewEventType.MOUSE_PRESSED);
                }
                if (ev.isPopupTrigger() && CustomTree.this.popupMenu != null && (CustomTree.this.getPathForLocation(ev.getPoint().x, ev.getPoint().y) != null || newEvent != null)) {
                    CustomTree.this.popupMenu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
                if (newEvent != null) {
                    this.notifyNewEvent(newEvent, NewEventType.MOUSE_PRESSED);
                }
            }

            public void mouseReleased(MouseEvent ev) {
                if (this.ignoreEvents) {
                    return;
                }
                MouseEvent newEvent = this.getTranslatedEvent(ev);
                if (ev.isPopupTrigger() && CustomTree.this.popupMenu != null && !CustomTree.this.popupMenu.isVisible() && (CustomTree.this.getPathForLocation(ev.getPoint().x, ev.getPoint().y) != null || newEvent != null)) {
                    CustomTree.this.popupMenu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
                if (newEvent != null) {
                    this.notifyNewEvent(newEvent, NewEventType.MOUSE_RELEASED);
                }
            }

            public void mouseClicked(MouseEvent ev) {
                if (this.ignoreEvents) {
                    return;
                }
                MouseEvent newEvent = this.getTranslatedEvent(ev);
                if (newEvent != null) {
                    this.notifyNewEvent(newEvent, NewEventType.MOUSE_CLICKED);
                }
            }

            private void notifyNewEvent(MouseEvent newEvent, NewEventType type) {
                this.ignoreEvents = true;
                block4: for (MouseListener mouseListener : new ArrayList(CustomTree.this.mouseListeners)) {
                    if (mouseListener == this) continue;
                    switch (type) {
                        case MOUSE_RELEASED: {
                            mouseListener.mouseReleased(newEvent);
                            continue block4;
                        }
                        case MOUSE_CLICKED: {
                            mouseListener.mouseClicked(newEvent);
                            continue block4;
                        }
                    }
                    mouseListener.mousePressed(newEvent);
                }
                this.ignoreEvents = false;
            }

            private MouseEvent getTranslatedEvent(MouseEvent ev) {
                Rectangle r;
                TreePath path;
                MouseEvent newEvent = null;
                int x = ev.getPoint().x;
                int y = ev.getPoint().y;
                if (CustomTree.this.getPathForLocation(x, y) == null && (path = CustomTree.this.getWidePathForLocation(x, y)) != null && (r = CustomTree.this.getPathBounds(path)) != null) {
                    int newX = r.x + r.width / 2;
                    int newY = r.y + r.height / 2;
                    newEvent = new MouseEvent(ev.getComponent(), ev.getID(), ev.getWhen(), ev.getModifiersEx(), newX, newY, ev.getClickCount(), ev.isPopupTrigger(), ev.getButton());
                }
                return newEvent;
            }
        };
        this.addMouseListener(mouseListener);
        if (this.getRowHeight() <= 18) {
            this.setRowHeight(19);
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.mouseListeners == null) {
            this.mouseListeners = new HashSet<MouseListener>();
        }
        this.mouseListeners.add(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.mouseListeners.remove(mouseListener);
    }

    private TreePath getWidePathForLocation(int x, int y) {
        Rectangle pathBounds;
        TreePath path = null;
        TreePath closestPath = this.getClosestPathForLocation(x, y);
        if (closestPath != null && (pathBounds = this.getPathBounds(closestPath)) != null && x >= pathBounds.x && x < this.getX() + this.getWidth() && y >= pathBounds.y && y < pathBounds.y + pathBounds.height) {
            path = closestPath;
        }
        return path;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NewEventType {
        MOUSE_PRESSED,
        MOUSE_CLICKED,
        MOUSE_RELEASED;

    }
}

