/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.LinkedHashSet;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class RefreshOptionsPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 641533296295459469L;
    private JTextField period;
    private JLabel lPeriod;
    private boolean isCancelled = true;
    private int MAX_VALUE = 5000;

    public RefreshOptionsPanel() {
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_REFRESH_PANEL_TITLE.get();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        String text = AdminToolMessages.INFO_CTRL_PANEL_REFRESH_OPTIONS_PANEL_TEXT.get().toString();
        JEditorPane pane = Utilities.makeHtmlPane(text, ColorAndFontConstants.defaultFont);
        Utilities.updatePreferredSize(pane, 60, text, ColorAndFontConstants.defaultFont, false);
        gbc.weighty = 0.0;
        this.add((Component)pane, gbc);
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.lPeriod = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_REFRESH_OPTIONS_LABEL.get());
        gbc.insets.top = 10;
        this.add((Component)this.lPeriod, gbc);
        this.period = Utilities.createShortTextField();
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        this.add((Component)this.period, gbc);
        gbc.gridwidth = 2;
        this.addBottomGlue(gbc);
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.OK_CANCEL;
    }

    public Component getPreferredFocusComponent() {
        return this.period;
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    public void okClicked() {
        this.isCancelled = true;
        this.setPrimaryValid(this.lPeriod);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        long t = -1L;
        try {
            t = Long.parseLong(this.period.getText());
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (t <= 0L || t > (long)this.MAX_VALUE) {
            errors.add(AdminToolMessages.INFO_CTRL_PANEL_INVALID_PERIOD_VALUE.get(this.MAX_VALUE));
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        } else {
            this.isCancelled = false;
            Utilities.getParentDialog(this).setVisible(false);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.isCancelled = true;
            long timeInSeconds = this.getInfo().getPoolingPeriod() / 1000L;
            this.period.setText(String.valueOf(timeInSeconds));
        }
    }

    public long getPoolingPeriod() {
        long t = -1L;
        try {
            t = 1000L * Long.parseLong(this.period.getText());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return t;
    }
}

