/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.html.HTMLDocument;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.PrintStreamListener;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.util.ApplicationPrintStream;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;

public class ProgressDialog
extends GenericDialog {
    private static final long serialVersionUID = -6462866257463062629L;
    private ProgressPanel progressPanel;

    public ProgressDialog(JFrame parentFrame, Component relativeTo, Message title, ControlPanelInfo info) {
        super(parentFrame, ProgressDialog.getPanel(info));
        Utilities.centerGoldenMean(this, relativeTo);
        this.setTitle(title.toString());
        this.progressPanel = (ProgressPanel)this.panel;
        this.getRootPane().setDefaultButton(this.progressPanel.closeButton);
    }

    private static StatusGenericPanel getPanel(ControlPanelInfo info) {
        ProgressPanel panel = new ProgressPanel();
        panel.setInfo(info);
        return panel;
    }

    public void addPrintStreamListeners(ApplicationPrintStream outPrintStream, ApplicationPrintStream errorPrintStream) {
        errorPrintStream.addListener(new PrintStreamListener(){

            public void newLine(final String msg) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressDialog.this.progressPanel.appendErrorLine(msg);
                    }
                });
            }
        });
        outPrintStream.addListener(new PrintStreamListener(){

            public void newLine(final String msg) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProgressDialog.this.progressPanel.appendOutputLine(msg);
                    }
                });
            }
        });
    }

    public JProgressBar getProgressBar() {
        return this.progressPanel.getProgressBar();
    }

    public void appendProgressHtml(String text) {
        this.progressPanel.appendHtml(text);
    }

    public void resetProgressLogs() {
        this.progressPanel.resetLogs();
    }

    public void setSummary(Message text) {
        this.progressPanel.setSummary(text);
    }

    public void setEnabledClose(boolean enable) {
        this.progressPanel.closeButton.setEnabled(enable);
    }

    public void setTaskIsOver(boolean taskIsOver) {
        this.progressPanel.taskIsOver = taskIsOver;
        this.progressPanel.closeWhenOverClicked();
    }

    private static String filterForBugID4988885(String msg) {
        return msg.replaceAll("<br>", "&#10;<br>");
    }

    static class ProgressPanel
    extends StatusGenericPanel {
        private static final long serialVersionUID = -364496083928260306L;
        private BasicExpander details;
        private JEditorPane logs;
        private JScrollPane scroll;
        private JCheckBox closeWhenOver;
        private final String LASTID = "lastid";
        private final String INIT_TEXT = "<span id=\"lastid\" style=\"bold\">&nbsp;</span>";
        private JProgressBar progressBar;
        private Component extraStrut;
        private JButton closeButton;
        private static final String FAKE_PROGRESS_TEXT = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
        private int heightDiff;
        private int lastCollapsedHeight = -1;
        private int lastExpandedHeight = -1;
        private static boolean lastShowDetails = false;
        private static boolean lastCloseWhenOver = false;
        private boolean taskIsOver;

        public ProgressPanel() {
            this.createLayout();
        }

        public Message getTitle() {
            return null;
        }

        public boolean requiresScroll() {
            return false;
        }

        public boolean requiresBorder() {
            return false;
        }

        public boolean isDisposeOnClose() {
            return true;
        }

        public void appendErrorLine(String msg) {
            msg = ProgressDialog.filterForBugID4988885(msg + "<br>");
            msg = Utilities.applyFont(msg, ColorAndFontConstants.progressFont);
            this.appendHtml(msg);
        }

        public void setSummary(Message msg) {
            this.errorPane.setText(msg.toString());
            if (!this.details.isSelected() && this.isVisible()) {
                Message wrappedText = Utilities.wrapHTML(msg, 70);
                JEditorPane pane = new JEditorPane();
                pane.setContentType("text/html");
                pane.setText(wrappedText.toString());
                ProgressDialog dlg = (ProgressDialog)Utilities.getParentDialog(this);
                int width = Math.max(pane.getPreferredSize().width + 40, dlg.getWidth());
                int height = Math.max(pane.getPreferredSize().height + 40 + this.extraStrut.getHeight() + this.details.getPreferredSize().height, dlg.getHeight());
                if (width > dlg.getWidth() || height > dlg.getHeight()) {
                    Dimension newDim = new Dimension(width, height);
                    dlg.setSize(newDim);
                }
            }
        }

        public void appendOutputLine(String msg) {
            this.appendErrorLine(msg);
        }

        public void appendHtml(String msg) {
            HTMLDocument doc = (HTMLDocument)this.logs.getDocument();
            try {
                msg = ProgressDialog.filterForBugID4988885(msg);
                doc.insertBeforeStart(doc.getElement("lastid"), msg);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void resetLogs() {
            this.logs.setText("<span id=\"lastid\" style=\"bold\">&nbsp;</span>");
        }

        private void createLayout() {
            GridBagConstraints gbc = new GridBagConstraints();
            this.addErrorPane(gbc);
            this.errorPane.setVisible(true);
            this.errorPane.setText(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_PLEASE_WAIT_SUMMARY.get().toString(), ColorAndFontConstants.defaultFont));
            gbc.anchor = 17;
            gbc.gridwidth = 1;
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.progressBar = new JProgressBar();
            this.progressBar.setMaximum(100);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(10, 20, 0, 30);
            this.add((Component)this.progressBar, gbc);
            gbc.insets.top = 10;
            gbc.insets.bottom = 5;
            this.details = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_PROGRESS_DIALOG_DETAILS_LABEL.get());
            ++gbc.gridy;
            this.add((Component)this.details, gbc);
            this.logs = Utilities.makeHtmlPane(FAKE_PROGRESS_TEXT, ColorAndFontConstants.progressFont);
            ++gbc.gridy;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets.top = 5;
            gbc.insets.right = 20;
            gbc.insets.bottom = 5;
            this.scroll = Utilities.createScrollPane(this.logs);
            this.scroll.setOpaque(false);
            this.scroll.getViewport().setOpaque(false);
            this.add((Component)this.scroll, gbc);
            Dimension scrollDim = this.scroll.getPreferredSize();
            gbc.weighty = 1.0;
            this.extraStrut = Box.createRigidArea(new Dimension(scrollDim.width, 50));
            this.add(this.extraStrut, gbc);
            ++gbc.gridy;
            gbc.weighty = 0.0;
            this.add(Box.createHorizontalStrut(scrollDim.width), gbc);
            this.heightDiff = scrollDim.height - this.extraStrut.getHeight();
            this.logs.setText("<span id=\"lastid\" style=\"bold\">&nbsp;</span>");
            this.scroll.setPreferredSize(scrollDim);
            this.updateVisibility(lastShowDetails);
            this.details.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    lastShowDetails = ProgressPanel.this.details.isSelected();
                    ProgressPanel.this.updateVisibility(lastShowDetails);
                }
            });
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.createButtonsPanel(), gbc);
        }

        private JPanel createButtonsPanel() {
            JPanel buttonsPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 1;
            gbc.gridy = 0;
            this.closeWhenOver = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_CLOSE_WINDOW_WHEN_OPERATION_COMPLETES_LABEL.get());
            this.closeWhenOver.setOpaque(false);
            this.closeWhenOver.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ProgressPanel.this.closeWhenOverClicked();
                }
            });
            this.closeWhenOver.setSelected(lastCloseWhenOver);
            gbc.insets = new Insets(10, 10, 10, 10);
            buttonsPanel.add((Component)this.closeWhenOver, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            buttonsPanel.add(Box.createHorizontalStrut(150));
            buttonsPanel.add(Box.createHorizontalGlue(), gbc);
            buttonsPanel.setOpaque(true);
            buttonsPanel.setBackground(ColorAndFontConstants.greyBackground);
            ++gbc.gridx;
            gbc.weightx = 0.0;
            buttonsPanel.add(Box.createHorizontalStrut(100));
            ++gbc.gridx;
            this.closeButton = Utilities.createButton(QuickSetupMessages.INFO_CLOSE_BUTTON_LABEL.get());
            this.closeButton.setOpaque(false);
            ++gbc.gridx;
            gbc.insets.left = 5;
            gbc.insets.right = 10;
            buttonsPanel.add((Component)this.closeButton, gbc);
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ProgressPanel.this.closeClicked();
                }
            });
            buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
            return buttonsPanel;
        }

        private void updateVisibility(boolean showDetails) {
            this.scroll.setVisible(showDetails);
            this.extraStrut.setVisible(!showDetails);
            this.details.setSelected(showDetails);
            if (showDetails) {
                final Window dialog = Utilities.getParentDialog(this);
                if (dialog != null) {
                    this.lastCollapsedHeight = dialog.getSize().height;
                    if (this.lastExpandedHeight == -1) {
                        dialog.setSize(new Dimension(dialog.getSize().width, dialog.getSize().height + this.heightDiff));
                    } else {
                        dialog.setSize(new Dimension(dialog.getSize().width, this.lastExpandedHeight));
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ProgressPanel.this.invalidate();
                            dialog.invalidate();
                            dialog.repaint();
                        }
                    });
                }
            } else {
                final Window dialog = Utilities.getParentDialog(this);
                if (dialog != null) {
                    this.lastExpandedHeight = dialog.getSize().height;
                    if (this.lastCollapsedHeight == -1) {
                        this.packParentDialog();
                    } else {
                        dialog.setSize(new Dimension(dialog.getSize().width, this.lastCollapsedHeight));
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ProgressPanel.this.invalidate();
                                dialog.invalidate();
                                dialog.repaint();
                            }
                        });
                    }
                }
            }
        }

        public GenericDialog.ButtonType getButtonType() {
            return GenericDialog.ButtonType.NO_BUTTON;
        }

        public void configurationChanged(ConfigurationChangeEvent ev) {
        }

        public Component getPreferredFocusComponent() {
            return this.details;
        }

        public void okClicked() {
            Utilities.getParentDialog(this).setVisible(false);
        }

        public JProgressBar getProgressBar() {
            return this.progressBar;
        }

        private void closeWhenOverClicked() {
            lastCloseWhenOver = this.closeWhenOver.isSelected();
            if (lastCloseWhenOver && this.taskIsOver) {
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(2000L);
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    if (ProgressPanel.this.closeWhenOver.isSelected() && ProgressPanel.this.taskIsOver) {
                                        ProgressPanel.this.closeClicked();
                                    }
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
                t.start();
            }
        }
    }
}

