/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ScheduleType;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BrowseActionListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.InclusionExclusionPanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.components.ScheduleSummaryPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.server.tools.ExportLDIF;

public class ExportLDIFPanel
extends InclusionExclusionPanel {
    private static final long serialVersionUID = 2256902594454214644L;
    private JComboBox backends;
    private JTextField file;
    private JCheckBox overwrite;
    private JCheckBox compressData;
    private JCheckBox encryptData;
    private JCheckBox generateSignedHash;
    private JCheckBox wrapText;
    private JTextField wrapColumn;
    private JButton bBrowse;
    private JLabel lBackend;
    private JLabel lNoBackendsFound;
    private JLabel lFile;
    private JLabel lExportOptions;
    private JLabel lRemoteFileHelp;
    private JCheckBox excludeOperationalAttrs;
    private DocumentListener documentListener;
    private ScheduleSummaryPanel schedulePanel;

    public ExportLDIFPanel() {
        this.createLayout();
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_EXPORT_LDIF_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.file;
    }

    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.documentListener.changedUpdate(null);
        }
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        this.addErrorPane(gbc);
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        this.lBackend = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKEND_LABEL.get());
        this.add((Component)this.lBackend, gbc);
        gbc.insets.left = 10;
        gbc.gridx = 1;
        this.backends = Utilities.createComboBox();
        this.backends.setModel(new DefaultComboBoxModel<String>(new String[0]));
        gbc.gridwidth = 3;
        this.add((Component)this.backends, gbc);
        this.lNoBackendsFound = Utilities.createDefaultLabel(AdminToolMessages.INFO_CTRL_PANEL_NO_BACKENDS_FOUND_LABEL.get());
        this.add((Component)this.lNoBackendsFound, gbc);
        this.lNoBackendsFound.setVisible(false);
        gbc.insets.top = 10;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.gridwidth = 1;
        this.lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_EXPORT_TO_FILE_LABEL.get());
        this.add((Component)this.lFile, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        gbc.gridwidth = 2;
        this.file = Utilities.createTextField();
        this.documentListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                String text = ExportLDIFPanel.this.file.getText().trim();
                ExportLDIFPanel.this.setEnabledOK(text != null && text.length() > 0 && !ExportLDIFPanel.this.errorPane.isVisible());
            }

            public void removeUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }

            public void insertUpdate(DocumentEvent ev) {
                this.changedUpdate(ev);
            }
        };
        this.file.getDocument().addDocumentListener(this.documentListener);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.file, gbc);
        this.bBrowse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.bBrowse.addActionListener(new BrowseActionListener(this.file, BrowseActionListener.BrowseType.CREATE_LDIF_FILE, this));
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        this.bBrowse.setOpaque(false);
        this.add((Component)this.bBrowse, gbc);
        this.lRemoteFileHelp = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_REMOTE_SERVER_PATH.get());
        gbc.gridx = 1;
        gbc.insets.top = 3;
        gbc.insets.left = 10;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        this.add((Component)this.lRemoteFileHelp, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.insets.left = 30;
        gbc.insets.top = 5;
        gbc.gridwidth = 3;
        this.overwrite = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_EXPORT_OVERWRITE_LABEL.get());
        this.overwrite.setOpaque(false);
        this.add((Component)this.overwrite, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 0;
        gbc.insets.top = 10;
        gbc.gridwidth = 1;
        this.lExportOptions = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_EXPORT_OPTIONS.get());
        this.add((Component)this.lExportOptions, gbc);
        this.schedulePanel = new ScheduleSummaryPanel(AdminToolMessages.INFO_CTRL_PANEL_EXPORT_LDIF_TITLE.get().toString());
        this.schedulePanel.setSchedule(ScheduleType.createLaunchNow());
        gbc.insets.left = 10;
        gbc.gridx = 1;
        gbc.gridwidth = 3;
        this.add((Component)this.schedulePanel, gbc);
        this.compressData = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_COMPRESS_DATA_LABEL.get());
        this.compressData.setSelected(false);
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.add((Component)this.compressData, gbc);
        this.encryptData = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_ENCRYPT_DATA_LABEL.get());
        this.generateSignedHash = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_EXPORT_GENERATE_SIGNED_HASH.get());
        this.encryptData.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ExportLDIFPanel.this.generateSignedHash.setEnabled(ExportLDIFPanel.this.encryptData.isSelected());
            }
        });
        this.encryptData.setSelected(false);
        this.generateSignedHash.setEnabled(false);
        this.wrapText = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_EXPORT_WRAP_TEXT.get());
        this.wrapText.setOpaque(false);
        gbc.insets.left = 10;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.wrapText, gbc);
        gbc.insets.left = 5;
        gbc.gridx = 2;
        this.wrapColumn = Utilities.createTextField("80", 4);
        gbc.fill = 0;
        this.add((Component)this.wrapColumn, gbc);
        gbc.fill = 2;
        this.wrapText.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent ev) {
                ExportLDIFPanel.this.wrapColumn.setEnabled(ExportLDIFPanel.this.wrapText.isSelected());
            }
        });
        this.wrapColumn.setEnabled(false);
        this.wrapText.setSelected(false);
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        this.excludeOperationalAttrs = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_EXCLUDE_OPERATIONAL_ATTRIBUTES.get());
        this.excludeOperationalAttrs.setOpaque(false);
        this.add(this.createDataExclusionOptions(new JLabel[]{null}, new Component[]{this.excludeOperationalAttrs}), gbc);
        ++gbc.gridy;
        gbc.insets.top = 15;
        this.add(this.createDataInclusionOptions(new JLabel[0], new Component[0]), gbc);
        this.addBottomGlue(gbc);
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        this.updateSimpleBackendComboBoxModel(this.backends, this.lNoBackendsFound, ev.getNewDescriptor());
        this.updateErrorPaneAndOKButtonIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_EXPORT.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExportLDIFPanel.this.lRemoteFileHelp.setVisible(!ExportLDIFPanel.this.isLocal());
                ExportLDIFPanel.this.bBrowse.setVisible(ExportLDIFPanel.this.isLocal());
            }
        });
    }

    protected void checkOKButtonEnable() {
        this.documentListener.changedUpdate(null);
    }

    public void okClicked() {
        File f;
        String ldifPath;
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lFile);
        this.setPrimaryValid(this.lExportOptions);
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        String backendName = (String)this.backends.getSelectedItem();
        if (backendName == null) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_NO_BACKEND_SELECTED.get());
            this.setPrimaryInvalid(this.lBackend);
        }
        if ((ldifPath = this.file.getText()) == null || ldifPath.trim().equals("")) {
            errors.add(QuickSetupMessages.INFO_NO_LDIF_PATH.get());
            this.setPrimaryInvalid(this.lFile);
        } else if (this.isLocal() && (f = new File(ldifPath)).isDirectory()) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_EXPORT_DIRECTORY_PROVIDED.get(ldifPath));
        }
        this.addScheduleErrors(this.getSchedule(), errors, this.lExportOptions);
        if (this.wrapText.isSelected()) {
            String cols = this.wrapColumn.getText();
            int minValue = 1;
            int maxValue = 1000;
            Message errMsg = AdminToolMessages.ERR_CTRL_PANEL_INVALID_WRAP_COLUMN.get(minValue, maxValue);
            int size1 = errors.size();
            this.checkIntValue(errors, cols, minValue, maxValue, errMsg);
            if (errors.size() > size1) {
                this.setPrimaryInvalid(this.lExportOptions);
            }
        }
        this.updateIncludeExclude(errors, backendName);
        if (errors.isEmpty()) {
            ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
            ExportTask newTask = new ExportTask(this.getInfo(), progressDialog);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            boolean confirmed = true;
            if (errors.isEmpty()) {
                File f2 = new File(ldifPath);
                if (this.overwrite.isSelected() && f2.exists()) {
                    confirmed = this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_EXPORT_LDIF_DETAILS.get(ldifPath));
                }
            }
            if (errors.isEmpty() && confirmed) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_EXPORTING_LDIF_SUMMARY.get(this.backends.getSelectedItem().toString()), AdminToolMessages.INFO_CTRL_PANEL_EXPORTING_LDIF_SUCCESSFUL_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_EXPORTING_LDIF_SUCCESSFUL_DETAILS.get(), AdminToolMessages.ERR_CTRL_PANEL_EXPORTING_LDIF_ERROR_SUMMARY.get(), null, AdminToolMessages.ERR_CTRL_PANEL_EXPORTING_LDIF_ERROR_DETAILS, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    public void cancelClicked() {
        this.setPrimaryValid(this.lBackend);
        this.setPrimaryValid(this.lFile);
        this.setPrimaryValid(this.lExportOptions);
        super.cancelClicked();
    }

    private ScheduleType getSchedule() {
        return this.schedulePanel.getSchedule();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExportTask
    extends InclusionExclusionPanel.InclusionExclusionTask {
        private Set<String> backendSet;
        private String fileName;

        public ExportTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(ExportLDIFPanel.this, info, dlg);
            this.backendSet = new HashSet<String>();
            this.backendSet.add((String)ExportLDIFPanel.this.backends.getSelectedItem());
            this.fileName = ExportLDIFPanel.this.file.getText();
        }

        @Override
        public Task.Type getType() {
            return Task.Type.EXPORT_LDIF;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_EXPORT_TASK_DESCRIPTION.get(this.backendSet.iterator().next(), this.fileName);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING && this.runningOnSameServer(taskToBeLaunched)) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                List arguments = this.getCommandLineArguments();
                String[] args = new String[((ArrayList)arguments).size()];
                ((ArrayList)arguments).toArray(args);
                this.returnCode = this.isServerRunning() ? Integer.valueOf(ExportLDIF.mainExportLDIF(args, false, this.outPrintStream, this.errorPrintStream)) : Integer.valueOf(this.executeCommandLine(this.getCommandLinePath(), args));
                this.state = this.returnCode != 0 ? Task.State.FINISHED_WITH_ERROR : Task.State.FINISHED_SUCCESSFULLY;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        @Override
        protected ArrayList<String> getCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("--ldifFile");
            args.add(this.fileName);
            args.add("--backendID");
            args.add(this.backendSet.iterator().next());
            if (!ExportLDIFPanel.this.overwrite.isSelected()) {
                args.add("--appendToLDIF");
            }
            if (ExportLDIFPanel.this.compressData.isSelected()) {
                args.add("--compress");
            }
            if (ExportLDIFPanel.this.wrapText.isSelected()) {
                args.add("--wrapColumn");
                args.add(ExportLDIFPanel.this.wrapColumn.getText().trim());
            }
            if (ExportLDIFPanel.this.excludeOperationalAttrs.isSelected()) {
                args.add("--excludeOperational");
            }
            args.addAll(super.getCommandLineArguments());
            args.addAll(ExportLDIFPanel.this.getScheduleArgs(ExportLDIFPanel.this.getSchedule()));
            if (this.isServerRunning()) {
                args.addAll(this.getConfigCommandLineArguments());
            }
            args.add(this.getNoPropertiesFileArgument());
            return args;
        }

        @Override
        protected String getCommandLinePath() {
            return this.getCommandLinePath("export-ldif");
        }
    }
}

