/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.task.DeleteBaseDNAndBackendTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.CustomListCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteBaseDNPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 2182662824496761087L;
    protected JList list;
    protected JLabel lNoElementsFound;
    protected JPanel mainPanel;

    public DeleteBaseDNPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_DELETE_BASE_DN_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.list;
    }

    @Override
    public boolean requiresScroll() {
        return false;
    }

    protected Message getNoElementsFoundLabel() {
        return AdminToolMessages.INFO_CTRL_PANEL_NO_BASE_DNS_FOUND_LABEL.get();
    }

    protected Message getListLabel() {
        return AdminToolMessages.INFO_CTRL_PANEL_SELECT_BASE_DNS_TO_DELETE.get();
    }

    protected void updateList(final Collection<?> newElements) {
        boolean changed;
        DefaultListModel model = (DefaultListModel)this.list.getModel();
        boolean bl = changed = newElements.size() != model.getSize();
        if (!changed) {
            int i = 0;
            for (Object newElement : newElements) {
                boolean bl2 = changed = !newElement.equals(model.getElementAt(i));
                if (changed) break;
                ++i;
            }
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object[] s = DeleteBaseDNPanel.this.list.getSelectedValues();
                    HashSet<Object> selected = new HashSet<Object>();
                    if (s != null) {
                        for (Object o : s) {
                            selected.add(o);
                        }
                    }
                    DefaultListModel model = (DefaultListModel)DeleteBaseDNPanel.this.list.getModel();
                    model.clear();
                    TreeSet<Integer> indices = new TreeSet<Integer>();
                    int i = 0;
                    for (Object newElement : newElements) {
                        model.addElement(newElement);
                        if (selected.contains(newElement)) {
                            indices.add(i);
                        }
                        ++i;
                    }
                    if (selected.size() > 0) {
                        int[] indArray = new int[indices.size()];
                        i = 0;
                        for (Integer index : indices) {
                            indArray[i] = index;
                            ++i;
                        }
                        DeleteBaseDNPanel.this.list.setSelectedIndices(indArray);
                    }
                    DeleteBaseDNPanel.this.checkVisibility();
                }
            });
        }
    }

    private void checkVisibility() {
        this.mainPanel.setVisible(this.list.getModel().getSize() > 0);
        this.lNoElementsFound.setVisible(this.list.getModel().getSize() == 0);
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        this.addErrorPane(gbc);
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setOpaque(false);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.mainPanel, gbc);
        gbc.anchor = 10;
        gbc.fill = 0;
        this.lNoElementsFound = Utilities.createPrimaryLabel(this.getNoElementsFoundLabel());
        this.add((Component)this.lNoElementsFound, gbc);
        this.lNoElementsFound.setVisible(false);
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        JLabel lBaseDNs = Utilities.createPrimaryLabel(this.getListLabel());
        this.mainPanel.add((Component)lBaseDNs, gbc);
        gbc.insets.top = 5;
        this.list = new JList(new DefaultListModel());
        this.list.setCellRenderer(new CustomListCellRenderer(this.list));
        this.list.setVisibleRowCount(15);
        ++gbc.gridy;
        gbc.gridheight = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.mainPanel.add((Component)Utilities.createScrollPane(this.list), gbc);
        JButton selectAllButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SELECT_ALL_BUTTON.get());
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int[] indices = new int[DeleteBaseDNPanel.this.list.getModel().getSize()];
                for (int i = 0; i < indices.length; ++i) {
                    indices[i] = i;
                }
                DeleteBaseDNPanel.this.list.setSelectedIndices(indices);
            }
        });
        ++gbc.gridx;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.insets.left = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.mainPanel.add((Component)selectAllButton, gbc);
        ++gbc.gridy;
        JButton unselectAllButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CLEAR_SELECTION_BUTTON.get());
        unselectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DeleteBaseDNPanel.this.list.clearSelection();
            }
        });
        this.mainPanel.add((Component)unselectAllButton, gbc);
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                DeleteBaseDNPanel.this.checkOKButtonEnable();
            }
        });
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.insets.top = 0;
        gbc.weighty = 1.0;
        this.mainPanel.add(Box.createVerticalGlue(), gbc);
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible) {
            this.list.clearSelection();
            this.checkVisibility();
        }
    }

    @Override
    protected void checkOKButtonEnable() {
        this.setEnabledOK(!this.list.isSelectionEmpty() && this.mainPanel.isVisible());
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        TreeSet<DN> newElements = new TreeSet<DN>();
        for (BackendDescriptor backend : desc.getBackends()) {
            if (backend.isConfigBackend()) continue;
            for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                newElements.add(baseDN.getDn());
            }
        }
        this.updateList(newElements);
        this.updateErrorPaneAndOKButtonIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_BASE_DN_DELETE.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
    }

    @Override
    public void okClicked() {
        LinkedHashSet<Message> errors = new LinkedHashSet<Message>();
        ProgressDialog progressDialog = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), this.getTitle(), this.getInfo());
        Object[] dns = this.list.getSelectedValues();
        ArrayList<BaseDNDescriptor> baseDNsToDelete = new ArrayList<BaseDNDescriptor>();
        block0: for (Object o : dns) {
            DN dn = (DN)o;
            boolean found = false;
            for (BackendDescriptor backend : this.getInfo().getServerDescriptor().getBackends()) {
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    if (!baseDN.getDn().equals(dn)) continue;
                    baseDNsToDelete.add(baseDN);
                    found = true;
                    break;
                }
                if (!found) continue;
                continue block0;
            }
        }
        DeleteBaseDNAndBackendTask newTask = new DeleteBaseDNAndBackendTask(this.getInfo(), progressDialog, new HashSet<BackendDescriptor>(), baseDNsToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.isEmpty()) {
            Message confirmationMessage = this.getConfirmationMessage(baseDNsToDelete);
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_BASE_DNS_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_BASE_DNS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_BASE_DNS_SUCCESSFUL.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_BASE_DNS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_BASE_DNS_ERROR_DETAILS.get(), null, progressDialog);
                progressDialog.setVisible(true);
                Utilities.getParentDialog(this).setVisible(false);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    private Message getConfirmationMessage(Collection<BaseDNDescriptor> baseDNsToDelete) {
        MessageBuilder mb = new MessageBuilder();
        HashMap<String, HashSet<BaseDNDescriptor>> hmBackends = new HashMap<String, HashSet<BaseDNDescriptor>>();
        for (BaseDNDescriptor baseDN : baseDNsToDelete) {
            String backendID = baseDN.getBackend().getBackendID();
            HashSet<BaseDNDescriptor> set = (HashSet<BaseDNDescriptor>)hmBackends.get(backendID);
            if (set == null) {
                set = new HashSet<BaseDNDescriptor>();
                hmBackends.put(backendID, set);
            }
            set.add(baseDN);
        }
        ArrayList<String> indirectBackendsToDelete = new ArrayList<String>();
        for (Set set : hmBackends.values()) {
            BackendDescriptor backend = ((BaseDNDescriptor)set.iterator().next()).getBackend();
            if (set.size() != backend.getBaseDns().size()) continue;
            indirectBackendsToDelete.add(backend.getBackendID());
        }
        mb.append(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_BASE_DNS_DETAILS.get());
        for (BaseDNDescriptor baseDN : baseDNsToDelete) {
            mb.append("<br> - " + baseDN.getDn());
        }
        if (indirectBackendsToDelete.size() > 0) {
            mb.append("<br><br>");
            mb.append(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_BASE_DNS_INDIRECT_DETAILS.get());
            for (String backendID : indirectBackendsToDelete) {
                mb.append("<br> - " + backendID);
            }
        }
        mb.append("<br><br>");
        mb.append(AdminToolMessages.INFO_CTRL_PANEL_DO_YOU_WANT_TO_CONTINUE.get());
        return mb.toMessage();
    }
}

