/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.datamodel.SortableListModel;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ConfigurationElementCreatedListener;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.ModifyObjectClassTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.NewAttributePanel;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.SchemaElementPanel;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.ui.components.BasicExpander;
import org.opends.guitools.controlpanel.ui.components.DoubleAddRemovePanel;
import org.opends.guitools.controlpanel.ui.components.TitlePanel;
import org.opends.guitools.controlpanel.ui.renderer.SchemaElementComboBoxCellRenderer;
import org.opends.guitools.controlpanel.util.LowerCaseComparator;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ObjectClassType;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomObjectClassPanel
extends SchemaElementPanel {
    private static final long serialVersionUID = 2105520588901380L;
    private JButton delete;
    private JButton saveChanges;
    private ObjectClass objectClass;
    private String ocName;
    private ScrollPaneBorderListener scrollListener;
    private TitlePanel titlePanel = new TitlePanel(Message.EMPTY, Message.EMPTY);
    private JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_NAME_LABEL.get());
    private JLabel lParent = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_PARENT_LABEL.get());
    private JLabel lOID = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OID_LABEL.get());
    private JLabel lAliases = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ALIASES_LABEL.get());
    private JLabel lOrigin = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ORIGIN_LABEL.get());
    private JLabel lFile = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_FILE_LABEL.get());
    private JTextField aliases = Utilities.createLongTextField();
    private JLabel lDescription = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_DESCRIPTION_LABEL.get());
    private JLabel lType = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_TYPE_LABEL.get());
    private JLabel lAttributes = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_ATTRIBUTES_LABEL.get());
    private Set<AttributeType> inheritedOptionalAttributes = new HashSet<AttributeType>();
    private Set<AttributeType> inheritedRequiredAttributes = new HashSet<AttributeType>();
    private JLabel[] labels = new JLabel[]{this.lName, this.lParent, this.lOID, this.lAliases, this.lOrigin, this.lFile, this.lDescription, this.lType, this.lAttributes};
    private JTextField name = Utilities.createMediumTextField();
    private JComboBox parent = Utilities.createComboBox();
    private JComboBox type = Utilities.createComboBox();
    private JTextField oid = Utilities.createMediumTextField();
    private JTextField description = Utilities.createLongTextField();
    private JTextField origin = Utilities.createLongTextField();
    private JTextField file = Utilities.createLongTextField();
    private JCheckBox obsolete = Utilities.createCheckBox(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_OBSOLETE_LABEL.get());
    private DoubleAddRemovePanel<AttributeType> attributes;
    private Schema schema;
    private Set<String> lastAliases = new LinkedHashSet<String>();
    private boolean ignoreChangeEvents;

    public CustomObjectClassPanel() {
        this.createLayout();
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_CUSTOM_OBJECTCLASS_TITLE.get();
    }

    protected void createLayout() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        p.setOpaque(false);
        p.setBorder(this.PANEL_BORDER);
        this.createBasicLayout(p, gbc);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(p);
        this.scrollListener = ScrollPaneBorderListener.createBottomBorderListener(scroll);
        this.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.gridwidth = 1;
        this.delete = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_DELETE_OBJECTCLASS_BUTTON.get());
        this.delete.setOpaque(false);
        this.add((Component)this.delete, gbc);
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CustomObjectClassPanel.this.deleteObjectclass();
            }
        });
        gbc.anchor = 13;
        ++gbc.gridx;
        this.saveChanges = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_SAVE_CHANGES_LABEL.get());
        this.saveChanges.setOpaque(false);
        this.add((Component)this.saveChanges, gbc);
        this.saveChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                ArrayList errors = new ArrayList();
                CustomObjectClassPanel.this.saveChanges(false, errors);
            }
        });
    }

    protected void createBasicLayout(Container c, GridBagConstraints gbc) {
        JComboBox[] combos;
        JTextField[] tfs;
        SchemaElementComboBoxCellRenderer renderer = new SchemaElementComboBoxCellRenderer(this.parent);
        DefaultComboBoxModel<ObjectClassType> model = new DefaultComboBoxModel<ObjectClassType>();
        this.parent.setModel(model);
        this.parent.setRenderer(renderer);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent ev) {
                if (CustomObjectClassPanel.this.ignoreChangeEvents) {
                    return;
                }
                CustomObjectClassPanel.this.updateAttributesWithParent(true);
            }
        };
        this.parent.addItemListener(itemListener);
        model = new DefaultComboBoxModel();
        for (ObjectClassType t : ObjectClassType.values()) {
            model.addElement(t);
        }
        this.type.setModel(model);
        this.type.setSelectedItem((Object)ObjectClassType.STRUCTURAL);
        this.type.setRenderer(renderer);
        this.attributes = new DoubleAddRemovePanel<AttributeType>(0, AttributeType.class);
        Comparator<AttributeType> comparator = new Comparator<AttributeType>(){

            @Override
            public int compare(AttributeType attr1, AttributeType attr2) {
                return attr1.getNameOrOID().toLowerCase().compareTo(attr2.getNameOrOID().toLowerCase());
            }
        };
        this.attributes.getAvailableListModel().setComparator(comparator);
        this.attributes.getSelectedListModel1().setComparator(comparator);
        this.attributes.getSelectedListModel2().setComparator(comparator);
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        this.addErrorPane(c, gbc);
        ++gbc.gridy;
        gbc.anchor = 17;
        this.titlePanel.setTitle(AdminToolMessages.INFO_CTRL_PANEL_OBJECTCLASS_DETAILS.get());
        gbc.fill = 0;
        gbc.insets.top = 5;
        gbc.insets.bottom = 7;
        c.add((Component)this.titlePanel, gbc);
        gbc.insets.bottom = 0;
        gbc.insets.top = 8;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        Component[] basicComps = new Component[]{this.name, this.oid, this.description, this.parent};
        JLabel[] basicLabels = new JLabel[]{this.lName, this.lOID, this.lDescription, this.lParent};
        JLabel[] basicInlineHelp = new JLabel[]{null, null, null, null};
        this.add(basicLabels, basicComps, basicInlineHelp, c, gbc);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        c.add((Component)this.lAttributes, gbc);
        ++gbc.gridx;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets.left = 10;
        c.add(this.attributes, gbc);
        this.attributes.getAvailableLabel().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_AVAILABLE_ATTRIBUTES.get().toString());
        this.attributes.getSelectedLabel1().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_REQUIRED_ATTRIBUTES.get().toString());
        this.attributes.getSelectedLabel2().setText(AdminToolMessages.INFO_CTRL_PANEL_ADDREMOVE_OPTIONAL_ATTRIBUTES.get().toString());
        AttributeTypeCellRenderer listRenderer = new AttributeTypeCellRenderer();
        this.attributes.getAvailableList().setCellRenderer(listRenderer);
        this.attributes.getSelectedList1().setCellRenderer(listRenderer);
        this.attributes.getSelectedList2().setCellRenderer(listRenderer);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.insets.top = 3;
        JLabel explanation = Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_INHERITED_ATTRIBUTES_HELP.get());
        gbc.insets.top = 3;
        c.add((Component)explanation, gbc);
        final BasicExpander expander = new BasicExpander(AdminToolMessages.INFO_CTRL_PANEL_EXTRA_OPTIONS_EXPANDER.get());
        this.obsolete.setText("Obsolete");
        Component[] comps = new Component[]{this.aliases, this.origin, this.file, this.type, this.obsolete};
        JLabel[] labels = new JLabel[]{this.lAliases, this.lOrigin, this.lFile, this.lType, null};
        JLabel[] inlineHelps = new JLabel[]{Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SEPARATED_WITH_COMMAS_HELP.get()), null, Utilities.createInlineHelpLabel(AdminToolMessages.INFO_CTRL_PANEL_SCHEMA_FILE_OBJECTCLASS_HELP.get(File.separator)), null, null};
        gbc.gridwidth = 2;
        gbc.gridx = 0;
        gbc.weighty = 0.0;
        gbc.insets.left = 0;
        ++gbc.gridy;
        c.add((Component)expander, gbc);
        final JPanel p = new JPanel(new GridBagLayout());
        gbc.insets.left = 15;
        ++gbc.gridy;
        c.add((Component)p, gbc);
        ++gbc.gridy;
        p.setOpaque(false);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.fill = 2;
        gbc1.gridy = 0;
        this.add(labels, comps, inlineHelps, p, gbc1);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                p.setVisible(expander.isSelected());
            }
        };
        expander.addChangeListener(changeListener);
        expander.setSelected(false);
        changeListener.stateChanged(null);
        DocumentListener docListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }

            public void removeUpdate(DocumentEvent ev) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }

            public void changedUpdate(DocumentEvent arg0) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }
        };
        for (JTextField tf : tfs = new JTextField[]{this.name, this.description, this.oid, this.aliases, this.origin, this.file}) {
            tf.getDocument().addDocumentListener(docListener);
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }
        };
        for (JComboBox combo : combos = new JComboBox[]{this.parent, this.type}) {
            combo.addActionListener(actionListener);
        }
        ListDataListener dataListener = new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }

            public void intervalAdded(ListDataEvent e) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }

            public void intervalRemoved(ListDataEvent e) {
                CustomObjectClassPanel.this.checkEnableSaveChanges();
            }
        };
        SortableListModel<AttributeType> list1 = this.attributes.getSelectedListModel1();
        SortableListModel<AttributeType> list2 = this.attributes.getSelectedListModel2();
        list1.addListDataListener(dataListener);
        list2.addListDataListener(dataListener);
        this.obsolete.addActionListener(actionListener);
    }

    public void update(ObjectClass oc, Schema schema) {
        this.ignoreChangeEvents = true;
        this.objectClass = oc;
        if (oc == null || schema == null) {
            return;
        }
        String n = oc.getPrimaryName();
        if (n == null) {
            n = NOT_APPLICABLE.toString();
        }
        this.titlePanel.setDetails(Message.raw(n, new Object[0]));
        this.name.setText(n);
        SortableListModel<AttributeType> modelRequired = this.attributes.getSelectedListModel1();
        SortableListModel<AttributeType> modelAvailable = this.attributes.getSelectedListModel2();
        SortableListModel<AttributeType> availableModel = this.attributes.getAvailableListModel();
        availableModel.addAll(modelRequired.getData());
        availableModel.addAll(modelAvailable.getData());
        modelRequired.clear();
        modelAvailable.clear();
        this.parent.setSelectedItem(oc.getSuperiorClass());
        this.updateAttributesWithParent(false);
        for (AttributeType attr : oc.getRequiredAttributes()) {
            availableModel.remove(attr);
            modelRequired.add(attr);
        }
        for (AttributeType attr : oc.getOptionalAttributes()) {
            availableModel.remove(attr);
            modelAvailable.add(attr);
        }
        this.notifyAttributesChanged();
        this.oid.setText(oc.getOID());
        n = oc.getDescription();
        if (n == null) {
            n = "";
        }
        this.description.setText(n);
        Set<String> aliases = this.getAliases(oc);
        this.lastAliases.clear();
        this.lastAliases.addAll(aliases);
        this.aliases.setText(Utilities.getStringFromCollection(aliases, ", "));
        String sOrigin = Utilities.getOrigin(oc);
        if (sOrigin == null) {
            sOrigin = "";
        }
        this.origin.setText(sOrigin);
        String sFile = oc.getSchemaFile();
        if (sFile == null) {
            sFile = "";
        }
        this.file.setText(sFile);
        this.type.setSelectedItem((Object)oc.getObjectClassType());
        this.obsolete.setSelected(oc.isObsolete());
        this.ocName = this.objectClass.getNameOrOID();
        this.scrollListener.updateBorder();
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        this.saveChanges.setEnabled(false);
        this.ignoreChangeEvents = false;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        final ServerDescriptor desc = ev.getNewDescriptor();
        Schema s = desc.getSchema();
        final boolean schemaChanged = this.schema != null && s != null ? !ServerDescriptor.areSchemasEqual(s, this.schema) : (this.schema == null && s != null ? true : (s == null && this.schema != null ? false : false));
        if (schemaChanged) {
            this.schema = s;
            HashMap<String, ObjectClass> objectClassNameMap = new HashMap<String, ObjectClass>();
            for (String key : this.schema.getObjectClasses().keySet()) {
                ObjectClass oc = this.schema.getObjectClass(key);
                objectClassNameMap.put(oc.getNameOrOID(), oc);
            }
            TreeSet<String> orderedKeys = new TreeSet<String>(new LowerCaseComparator());
            orderedKeys.addAll(objectClassNameMap.keySet());
            ArrayList newParents = new ArrayList();
            for (String key : orderedKeys) {
                newParents.add(objectClassNameMap.get(key));
            }
            this.updateComboBoxModel(newParents, (DefaultComboBoxModel)this.parent.getModel(), new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    return String.valueOf(arg0).compareTo(String.valueOf(arg1));
                }
            });
            this.updateErrorPaneIfAuthRequired(desc, this.isLocal() ? AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_OBJECTCLASS_EDIT.get() : AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(desc.getHostname()));
        } else if (this.schema == null) {
            this.updateErrorPane(this.errorPane, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get(), ColorAndFontConstants.defaultFont);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CustomObjectClassPanel.this.delete.setEnabled(!CustomObjectClassPanel.this.authenticationRequired(desc) && !CustomObjectClassPanel.this.authenticationRequired(desc) && CustomObjectClassPanel.this.schema != null);
                CustomObjectClassPanel.this.checkEnableSaveChanges();
                CustomObjectClassPanel.this.saveChanges.setEnabled(CustomObjectClassPanel.this.saveChanges.isEnabled() && !CustomObjectClassPanel.this.authenticationRequired(desc) && !CustomObjectClassPanel.this.authenticationRequired(desc) && CustomObjectClassPanel.this.schema != null);
                if (schemaChanged) {
                    CustomObjectClassPanel.this.updateAttributes();
                }
            }
        });
    }

    @Override
    public boolean mustCheckUnsavedChanges() {
        return this.saveChanges.isEnabled();
    }

    @Override
    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        UnsavedChangesDialog unsavedChangesDlg = new UnsavedChangesDialog((Component)Utilities.getParentDialog(this), this.getInfo());
        unsavedChangesDlg.setMessage(AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_CHANGES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_OBJECTCLASS_CHANGES_DETAILS.get(this.objectClass.getNameOrOID()));
        Utilities.centerGoldenMean(unsavedChangesDlg, Utilities.getParentDialog(this));
        unsavedChangesDlg.setVisible(true);
        UnsavedChangesDialog.Result result = unsavedChangesDlg.getResult();
        if (result == UnsavedChangesDialog.Result.SAVE) {
            ArrayList<Message> errors = new ArrayList<Message>();
            this.saveChanges(true, errors);
            if (!errors.isEmpty()) {
                result = UnsavedChangesDialog.Result.CANCEL;
            }
        }
        return result;
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    public void okClicked() {
    }

    private void deleteObjectclass() {
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_OBJECTCLASS_TITLE.get(), this.getInfo());
        LinkedHashSet<ObjectClass> ocsToDelete = new LinkedHashSet<ObjectClass>();
        ocsToDelete.add(this.objectClass);
        LinkedHashSet<AttributeType> attrsToDelete = new LinkedHashSet<AttributeType>(0);
        DeleteSchemaElementsTask newTask = new DeleteSchemaElementsTask(this.getInfo(), dlg, ocsToDelete, attrsToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        ArrayList<String> childClasses = new ArrayList<String>();
        if (schema != null) {
            for (ObjectClass o : schema.getObjectClasses().values()) {
                if (!this.objectClass.equals(o.getSuperiorClass())) continue;
                childClasses.add(o.getNameOrOID());
            }
        } else {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_SCHEMA_NOT_FOUND_DETAILS.get());
        }
        if (errors.size() == 0) {
            MessageBuilder mb = new MessageBuilder();
            if (!childClasses.isEmpty()) {
                mb.append(AdminToolMessages.INFO_OBJECTCLASS_IS_SUPERIOR.get(this.ocName, Utilities.getStringFromCollection(childClasses, ", ")));
                mb.append("<br>");
            }
            Message confirmationMessage = AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_DELETE_OBJECTCLASS_DETAILS.get(this.ocName);
            mb.append(confirmationMessage);
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), confirmationMessage)) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS_SUMMARY.get(this.ocName), AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_OBJECTCLASS_SUCCESSFUL.get(this.ocName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_OBJECTCLASS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_OBJECTCLASS_ERROR_DETAILS.get(this.ocName), null, dlg);
                dlg.setVisible(true);
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void saveChanges(boolean modal, ArrayList<Message> errors) {
        ObjectClass superior;
        Set<String> oldAliases;
        Set<String> aliases;
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        String n = this.getObjectClassName();
        MessageBuilder err = new MessageBuilder();
        if (n.length() == 0) {
            errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_NAME_REQUIRED.get());
            this.setPrimaryInvalid(this.lName);
        } else if (!n.equalsIgnoreCase(this.objectClass.getNameOrOID())) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_INVALID_OBJECTCLASS_NAME.get(err.toString()));
                this.setPrimaryInvalid(this.lName);
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_NAME_ALREADY_IN_USE.get(n, elementType.toString()));
                    this.setPrimaryInvalid(this.lName);
                }
            }
        }
        n = this.oid.getText().trim();
        if (n.length() > 0 && !n.equalsIgnoreCase(this.objectClass.getOID())) {
            if (!StaticUtils.isValidSchemaElement(n, 0, n.length(), err)) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_NOT_VALID.get(err.toString()));
                this.setPrimaryInvalid(this.lOID);
                err = new MessageBuilder();
            } else {
                Message elementType = NewAttributePanel.getSchemaElementType(n, this.schema);
                if (elementType != null) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OID_ALREADY_IN_USE.get(n, elementType.toString()));
                    this.setPrimaryInvalid(this.lOID);
                }
            }
        }
        if (!((Object)(aliases = this.getAliases())).equals(oldAliases = this.getAliases(this.objectClass))) {
            for (String alias : aliases) {
                Message elementType;
                if (alias.trim().length() == 0) {
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_EMPTY_ALIAS.get());
                    this.setPrimaryInvalid(this.lAliases);
                    continue;
                }
                boolean notPreviouslyDefined = true;
                for (String oldAlias : oldAliases) {
                    if (!oldAlias.equalsIgnoreCase(alias)) continue;
                    notPreviouslyDefined = false;
                    break;
                }
                if (!notPreviouslyDefined || (elementType = NewAttributePanel.getSchemaElementType(alias, this.schema)) == null) continue;
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_ALIAS_ALREADY_IN_USE.get(n, elementType.toString()));
                this.setPrimaryInvalid(this.lAliases);
            }
        }
        if ((superior = this.getSuperior()) != null) {
            if (superior.getNameOrOID().equalsIgnoreCase(this.objectClass.getNameOrOID())) {
                errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_CANNOT_BE_ITS_SUPERIOR.get());
                this.setPrimaryInvalid(this.lParent);
            } else {
                for (superior = superior.getSuperiorClass(); superior != null; superior = superior.getSuperiorClass()) {
                    if (!superior.getNameOrOID().equalsIgnoreCase(this.objectClass.getNameOrOID())) continue;
                    errors.add(AdminToolMessages.ERR_CTRL_PANEL_OBJECTCLASS_IS_SUPERIOR_OF_SUPERIOR.get(this.getSuperior().getNameOrOID()));
                    this.setPrimaryInvalid(this.lParent);
                    break;
                }
            }
        }
        if (errors.size() == 0) {
            ProgressDialog dlg = new ProgressDialog(Utilities.createFrame(), Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_MODIFY_ATTRIBUTE_TITLE.get(), this.getInfo());
            ModifyObjectClassTask newTask = new ModifyObjectClassTask(this.getInfo(), dlg, this.objectClass, this.getNewObjectClass());
            for (ConfigurationElementCreatedListener listener : this.getConfigurationElementCreatedListeners()) {
                newTask.addConfigurationElementCreatedListener(listener);
            }
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(newTask, errors);
            }
            if (errors.size() == 0) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_OBJECTCLASS_SUMMARY.get(this.ocName), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_OBJECTCLASS_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_OBJECTCLASS_SUCCESSFUL.get(this.ocName), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_OBJECTCLASS_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_OBJECTCLASS_ERROR_DETAILS.get(this.ocName), null, dlg);
                dlg.setVisible(true);
            }
        }
        if (!errors.isEmpty()) {
            this.displayErrorDialog(errors);
        }
    }

    private void checkEnableSaveChanges() {
        boolean changed;
        if (this.ignoreChangeEvents) {
            return;
        }
        if (this.objectClass != null) {
            try {
                changed = !this.objectClass.toString().equals(this.getNewObjectClass().toString());
            }
            catch (Throwable t) {
                changed = true;
            }
        } else {
            changed = false;
        }
        this.saveChanges.setEnabled(changed);
    }

    private Set<String> getAliases() {
        LinkedHashSet<String> al = new LinkedHashSet<String>();
        String s = this.aliases.getText().trim();
        if (s.length() > 0) {
            String[] a;
            for (String alias : a = s.split(",")) {
                al.add(alias.trim());
            }
        }
        return al;
    }

    private String getObjectClassName() {
        return this.name.getText().trim();
    }

    private String getOID() {
        String o = this.oid.getText().trim();
        if (o.length() == 0) {
            o = this.getObjectClassName() + "-oid";
        }
        return o;
    }

    private Map<String, List<String>> getExtraProperties() {
        String or;
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        String f = this.file.getText().trim();
        if (f.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(f);
            map.put("X-SCHEMA-FILE", list);
        }
        if ((or = this.origin.getText().trim()).length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(or);
            map.put("X-ORIGIN", list);
        }
        return map;
    }

    private ArrayList<String> getAllNames() {
        ArrayList<String> al = new ArrayList<String>();
        al.add(this.getObjectClassName());
        al.addAll(this.getAliases());
        return al;
    }

    private String getDescription() {
        return this.description.getText().trim();
    }

    private ObjectClass getSuperior() {
        return (ObjectClass)this.parent.getSelectedItem();
    }

    private ObjectClassType getObjectClassType() {
        return (ObjectClassType)((Object)this.type.getSelectedItem());
    }

    private Set<AttributeType> getRequiredAttributes() {
        HashSet<AttributeType> attrs = new HashSet<AttributeType>();
        attrs.addAll(this.attributes.getSelectedListModel1().getData());
        attrs.removeAll(this.inheritedRequiredAttributes);
        return attrs;
    }

    private Set<AttributeType> getOptionalAttributes() {
        HashSet<AttributeType> attrs = new HashSet<AttributeType>();
        attrs.addAll(this.attributes.getSelectedListModel2().getData());
        attrs.removeAll(this.inheritedOptionalAttributes);
        return attrs;
    }

    private ObjectClass getNewObjectClass() {
        ObjectClass newObjectClass = new ObjectClass("", this.getObjectClassName(), this.getAllNames(), this.getOID(), this.getDescription(), this.getSuperior(), this.getRequiredAttributes(), this.getOptionalAttributes(), this.getObjectClassType(), this.obsolete.isSelected(), this.getExtraProperties());
        return newObjectClass;
    }

    private void updateAttributes() {
        int[][] selected = new int[][]{this.attributes.getAvailableList().getSelectedIndices(), this.attributes.getSelectedList1().getSelectedIndices(), this.attributes.getSelectedList2().getSelectedIndices()};
        JList[] lists = new JList[]{this.attributes.getAvailableList(), this.attributes.getSelectedList1(), this.attributes.getSelectedList2()};
        this.attributes.getAvailableListModel().clear();
        Collection<AttributeType> allAttrs = this.schema.getAttributeTypes().values();
        this.attributes.getAvailableListModel().addAll(allAttrs);
        HashSet<AttributeType> toDelete = new HashSet<AttributeType>();
        for (AttributeType attr : this.attributes.getSelectedListModel1().getData()) {
            if (!allAttrs.contains(attr)) {
                toDelete.add(attr);
                continue;
            }
            this.attributes.getAvailableListModel().remove(attr);
        }
        for (AttributeType attr : toDelete) {
            this.attributes.getSelectedListModel1().remove(attr);
        }
        toDelete = new HashSet();
        for (AttributeType attr : this.attributes.getSelectedListModel2().getData()) {
            if (!allAttrs.contains(attr)) {
                toDelete.add(attr);
                continue;
            }
            this.attributes.getAvailableListModel().remove(attr);
        }
        for (AttributeType attr : toDelete) {
            this.attributes.getSelectedListModel1().remove(attr);
        }
        int i = 0;
        for (int[] sel : selected) {
            if (sel != null) {
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (int j = 0; j < sel.length; ++j) {
                    if (sel[j] >= lists[i].getModel().getSize()) continue;
                    indexes.add(sel[j]);
                }
                int[] newSelection = new int[indexes.size()];
                for (int j = 0; j < newSelection.length; ++j) {
                    newSelection[j] = (Integer)indexes.get(j);
                }
                lists[i].setSelectedIndices(newSelection);
            }
            ++i;
        }
    }

    private void updateAttributesWithParent(boolean notify) {
        for (AttributeType attr : this.inheritedRequiredAttributes) {
            this.attributes.getAvailableListModel().add(attr);
            this.attributes.getSelectedListModel1().remove(attr);
        }
        for (AttributeType attr : this.inheritedOptionalAttributes) {
            this.attributes.getAvailableListModel().add(attr);
            this.attributes.getSelectedListModel2().remove(attr);
        }
        this.inheritedOptionalAttributes.clear();
        this.inheritedRequiredAttributes.clear();
        ObjectClass p = (ObjectClass)this.parent.getSelectedItem();
        if (p != null) {
            for (AttributeType attr : p.getRequiredAttributeChain()) {
                this.inheritedRequiredAttributes.add(attr);
            }
            for (AttributeType attr : p.getOptionalAttributeChain()) {
                this.inheritedOptionalAttributes.add(attr);
            }
        }
        for (AttributeType attr : this.inheritedRequiredAttributes) {
            this.attributes.getAvailableListModel().remove(attr);
            this.attributes.getSelectedListModel1().add(attr);
        }
        for (AttributeType attr : this.inheritedOptionalAttributes) {
            this.attributes.getAvailableListModel().remove(attr);
            this.attributes.getSelectedListModel2().add(attr);
        }
        ArrayList<AttributeType> unmovableItems = new ArrayList<AttributeType>(this.inheritedRequiredAttributes);
        unmovableItems.addAll(this.inheritedOptionalAttributes);
        this.attributes.setUnmovableItems(unmovableItems);
        if (notify) {
            this.notifyAttributesChanged();
        }
    }

    private void notifyAttributesChanged() {
        this.attributes.getAvailableListModel().fireContentsChanged(this.attributes.getAvailableList(), 0, this.attributes.getAvailableListModel().getSize() - 1);
        this.attributes.getSelectedListModel1().fireContentsChanged(this.attributes.getSelectedList1(), 0, this.attributes.getSelectedListModel1().getSize() - 1);
        this.attributes.getSelectedListModel2().fireContentsChanged(this.attributes.getSelectedList2(), 0, this.attributes.getSelectedListModel2().getSize() - 1);
    }

    private class AttributeTypeCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer defaultRenderer;

        public AttributeTypeCellRenderer() {
            this.defaultRenderer = CustomObjectClassPanel.this.attributes.getAvailableList().getCellRenderer();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof AttributeType) {
                AttributeType attr = (AttributeType)value;
                value = CustomObjectClassPanel.this.inheritedOptionalAttributes.contains(value) || CustomObjectClassPanel.this.inheritedRequiredAttributes.contains(value) ? attr.getNameOrOID() + " (*)" : attr.getNameOrOID();
            }
            return this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

