/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class ConfirmInitializeAndImportDialog
extends GenericDialog {
    private static final long serialVersionUID = -442311801035162311L;

    public ConfirmInitializeAndImportDialog(Component parentDialog, ControlPanelInfo info) {
        super(Utilities.getFrame(parentDialog), ConfirmInitializeAndImportDialog.getPanel(info));
        Utilities.centerGoldenMean(this, parentDialog);
        this.getRootPane().setDefaultButton(((ConfirmInitializeAndImportPanel)this.panel).initializeAllButton);
        this.setModal(true);
    }

    public void setMessage(Message title, Message details) {
        this.panel.updateConfirmationPane(this.panel.errorPane, title, ColorAndFontConstants.errorTitleFont, details, ColorAndFontConstants.defaultFont);
        this.invalidate();
        this.pack();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            ((ConfirmInitializeAndImportPanel)this.panel).result = Result.CANCEL;
        }
        super.setVisible(visible);
    }

    public Result getResult() {
        return ((ConfirmInitializeAndImportPanel)this.panel).result;
    }

    private static StatusGenericPanel getPanel(ControlPanelInfo info) {
        ConfirmInitializeAndImportPanel panel = new ConfirmInitializeAndImportPanel();
        panel.setInfo(info);
        return panel;
    }

    private static class ConfirmInitializeAndImportPanel
    extends StatusGenericPanel {
        private static final long serialVersionUID = -9890116762604059L;
        private JButton initializeAllButton;
        private JButton importOnlyButton;
        private JButton cancelButton;
        private Result result;

        public ConfirmInitializeAndImportPanel() {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.addErrorPane(gbc);
            this.errorPane.setVisible(true);
            ++gbc.gridy;
            gbc.fill = 3;
            gbc.weighty = 1.0;
            this.add(Box.createVerticalGlue(), gbc);
            gbc.fill = 2;
            ++gbc.gridy;
            gbc.weighty = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.createButtonsPanel(), gbc);
        }

        public boolean requiresBorder() {
            return false;
        }

        public boolean requiresScroll() {
            return false;
        }

        private JPanel createButtonsPanel() {
            JPanel buttonsPanel = new JPanel(new GridBagLayout());
            buttonsPanel.setOpaque(true);
            buttonsPanel.setBackground(ColorAndFontConstants.greyBackground);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            ++gbc.gridx;
            buttonsPanel.add(Box.createHorizontalStrut(150));
            buttonsPanel.add(Box.createHorizontalGlue(), gbc);
            this.initializeAllButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_INITIALIZE_ALL_BUTTON_LABEL.get());
            this.initializeAllButton.setOpaque(false);
            gbc.insets = new Insets(10, 10, 10, 10);
            gbc.weightx = 0.0;
            ++gbc.gridx;
            buttonsPanel.add((Component)this.initializeAllButton, gbc);
            this.initializeAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ConfirmInitializeAndImportPanel.this.result = Result.INITIALIZE_ALL;
                    ConfirmInitializeAndImportPanel.this.cancelClicked();
                }
            });
            ++gbc.gridx;
            this.importOnlyButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_IMPORT_ONLY_BUTTON_LABEL.get());
            this.importOnlyButton.setOpaque(false);
            ++gbc.gridx;
            gbc.insets.left = 0;
            gbc.insets.right = 10;
            buttonsPanel.add((Component)this.importOnlyButton, gbc);
            this.importOnlyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ConfirmInitializeAndImportPanel.this.result = Result.IMPORT_ONLY;
                    ConfirmInitializeAndImportPanel.this.cancelClicked();
                }
            });
            this.cancelButton = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_CANCEL_BUTTON_LABEL.get());
            this.cancelButton.setOpaque(false);
            gbc.insets.right = 10;
            ++gbc.gridx;
            buttonsPanel.add((Component)this.cancelButton, gbc);
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ConfirmInitializeAndImportPanel.this.result = Result.CANCEL;
                    ConfirmInitializeAndImportPanel.this.cancelClicked();
                }
            });
            buttonsPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, ColorAndFontConstants.defaultBorderColor));
            return buttonsPanel;
        }

        public Component getPreferredFocusComponent() {
            return this.initializeAllButton;
        }

        public void okClicked() {
        }

        public Message getTitle() {
            return AdminToolMessages.INFO_CTRL_PANEL_CONFIRM_INITIALIZE_TITLE.get();
        }

        public void configurationChanged(ConfigurationChangeEvent ev) {
        }

        public GenericDialog.ButtonType getButtonType() {
            return GenericDialog.ButtonType.NO_BUTTON;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Result {
        INITIALIZE_ALL,
        IMPORT_ONLY,
        CANCEL;

    }
}

