/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GeneralMonitoringRightPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.GenericFrame;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.components.TreePanel;
import org.opends.guitools.controlpanel.ui.nodes.GeneralMonitoringTreeNode;
import org.opends.guitools.controlpanel.ui.renderer.TreeCellRenderer;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.guitools.controlpanel.util.ViewPositions;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;

public class BrowseGeneralMonitoringPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = 6462914563746678830L;
    private TreePanel treePane;
    private JScrollPane treeScroll;
    private ServerDescriptor lastServer;
    private String lastServerName;
    private boolean ignoreSelectionEvents;
    private Message NO_ELEMENT_SELECTED = AdminToolMessages.INFO_CTRL_PANEL_GENERAL_MONITORING_NO_ITEM_SELECTED.get();
    private Message MULTIPLE_ITEMS_SELECTED = AdminToolMessages.INFO_CTRL_PANEL_MULTIPLE_ITEMS_SELECTED_LABEL.get();
    protected GeneralMonitoringRightPanel entryPane;
    private HashMap<Object, ImageIcon> hmImages = new HashMap();

    public BrowseGeneralMonitoringPanel() {
        NodeType[] identifiers = new NodeType[]{NodeType.ROOT, NodeType.SYSTEM_INFORMATION, NodeType.JAVA_INFORMATION, NodeType.WORK_QUEUE, NodeType.ENTRY_CACHES, NodeType.DB_ENVIRONMENT};
        Message[] ocPaths = new Message[]{AdminToolMessages.INFO_CTRL_PANEL_GENERAL_MONITORING_ROOT_TREE_NODE.get(), AdminToolMessages.INFO_CTRL_PANEL_SYSTEM_INFORMATION_TREE_NODE.get(), AdminToolMessages.INFO_CTRL_PANEL_JVM_MEMORY_USAGE_TREE_NODE.get(), AdminToolMessages.INFO_CTRL_PANEL_WORK_QUEUE_TREE_NODE.get(), AdminToolMessages.INFO_CTRL_PANEL_ENTRY_CACHES_TREE_NODE.get(), AdminToolMessages.INFO_CTRL_PANEL_DB_ENVIRONMENT_TREE_NODE.get()};
        for (int i = 0; i < identifiers.length; ++i) {
            this.hmImages.put((Object)identifiers[i], Utilities.createImageIcon("org/opends/guitools/controlpanel/images/" + ocPaths[i], this.getClass().getClassLoader()));
        }
        this.createLayout();
    }

    public boolean requiresBorder() {
        return false;
    }

    public boolean requiresScroll() {
        return false;
    }

    public boolean callConfigurationChangedInBackground() {
        return true;
    }

    public void toBeDisplayed(boolean visible) {
        Window w = Utilities.getParentDialog(this);
        if (w instanceof GenericDialog) {
            ((GenericDialog)w).getRootPane().setDefaultButton(null);
        } else if (w instanceof GenericFrame) {
            ((GenericFrame)w).getRootPane().setDefaultButton(null);
        }
    }

    private void createLayout() {
        this.setBackground(ColorAndFontConstants.greyBackground);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.addErrorPane(gbc);
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridwidth = 7;
        this.add(this.createSplitPane(), gbc);
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_GENERAL_MONITORING_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.treePane;
    }

    public void okClicked() {
    }

    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.CLOSE;
    }

    private GeneralMonitoringRightPanel createBrowserRightPanel() {
        return new GeneralMonitoringRightPanel();
    }

    private Component createSplitPane() {
        this.treePane = new TreePanel();
        this.entryPane = this.createBrowserRightPanel();
        JPanel p = new JPanel(new GridBagLayout());
        p.setBackground(ColorAndFontConstants.background);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        Utilities.setBorder(this.treePane, new EmptyBorder(10, 0, 10, 0));
        p.add((Component)this.treePane, gbc);
        this.treeScroll = Utilities.createScrollPane(p);
        this.treePane.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                if (!BrowseGeneralMonitoringPanel.this.ignoreSelectionEvents) {
                    BrowseGeneralMonitoringPanel.this.ignoreSelectionEvents = true;
                    BrowseGeneralMonitoringPanel.this.updateEntryPane();
                    BrowseGeneralMonitoringPanel.this.ignoreSelectionEvents = false;
                }
            }
        });
        JTree tree = this.treePane.getTree();
        this.repopulateTree(tree, true);
        tree.setRootVisible(true);
        tree.setVisibleRowCount(20);
        tree.expandPath(new TreePath(this.getRoot(tree)));
        tree.setCellRenderer(new GeneralMonitoringTreeCellRenderer());
        this.treeScroll.setPreferredSize(new Dimension(this.treeScroll.getPreferredSize().width + 30, 3 * this.treeScroll.getPreferredSize().height));
        this.entryPane.displayMessage(this.NO_ELEMENT_SELECTED);
        this.entryPane.setBorder(this.getRightPanelBorder());
        this.entryPane.setPreferredSize(new Dimension(this.treeScroll.getPreferredSize().width * 2, this.treeScroll.getPreferredSize().height));
        JSplitPane pane = new JSplitPane(1);
        pane.setOpaque(true);
        pane.setLeftComponent(this.treeScroll);
        pane.setRightComponent(this.entryPane);
        pane.setResizeWeight(0.0);
        pane.setDividerLocation(this.treeScroll.getPreferredSize().width);
        return pane;
    }

    public void setInfo(ControlPanelInfo info) {
        super.setInfo(info);
        this.treePane.setInfo(info);
        this.entryPane.setInfo(info);
    }

    public void configurationChanged(ConfigurationChangeEvent ev) {
        MessageBuilder mb;
        ServerDescriptor server = ev.getNewDescriptor();
        if (this.serverChanged(server)) {
            final boolean firstTimeCalled = this.lastServer == null;
            this.lastServer = server;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String serverName = BrowseGeneralMonitoringPanel.this.getServerName(BrowseGeneralMonitoringPanel.this.lastServer);
                    if (!serverName.equals(BrowseGeneralMonitoringPanel.this.lastServerName)) {
                        BrowseGeneralMonitoringPanel.this.repopulateTree(BrowseGeneralMonitoringPanel.this.treePane.getTree(), false);
                        BrowseGeneralMonitoringPanel.this.lastServerName = serverName;
                    }
                    if (firstTimeCalled) {
                        BrowseGeneralMonitoringPanel.this.treePane.getTree().setSelectionInterval(0, 0);
                    } else {
                        BrowseGeneralMonitoringPanel.this.updateEntryPane();
                    }
                }
            });
        } else {
            this.lastServer = server;
        }
        boolean displayErrorPane = false;
        Message errorTitle = Message.EMPTY;
        Message errorDetails = Message.EMPTY;
        ServerDescriptor.ServerStatus status = server.getStatus();
        if (status == ServerDescriptor.ServerStatus.STARTED) {
            if (!server.isAuthenticated()) {
                mb = new MessageBuilder();
                mb.append(AdminToolMessages.INFO_CTRL_PANEL_AUTH_REQUIRED_TO_BROWSE_MONITORING_SUMMARY.get());
                mb.append("<br><br>" + this.getAuthenticateHTML());
                errorDetails = mb.toMessage();
                errorTitle = AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get();
                displayErrorPane = true;
            }
        } else if (status == ServerDescriptor.ServerStatus.NOT_CONNECTED_TO_REMOTE) {
            mb = new MessageBuilder();
            mb.append(AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_DETAILS.get(server.getHostname()));
            mb.append("<br><br>" + this.getAuthenticateHTML());
            errorDetails = mb.toMessage();
            errorTitle = AdminToolMessages.INFO_CTRL_PANEL_CANNOT_CONNECT_TO_REMOTE_SUMMARY.get();
            displayErrorPane = true;
        } else {
            errorTitle = AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_SUMMARY.get();
            mb = new MessageBuilder();
            mb.append(AdminToolMessages.INFO_CTRL_PANEL_SERVER_MUST_RUN_TO_BROWSE_MONITORING_SUMMARY.get());
            mb.append("<br><br>");
            mb.append(this.getStartServerHTML());
            errorDetails = mb.toMessage();
            displayErrorPane = true;
        }
        final boolean fDisplayErrorPane = displayErrorPane;
        final Message fErrorTitle = errorTitle;
        final Message fErrorDetails = errorDetails;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BrowseGeneralMonitoringPanel.this.errorPane.setVisible(fDisplayErrorPane);
                if (fDisplayErrorPane) {
                    BrowseGeneralMonitoringPanel.this.updateErrorPane(BrowseGeneralMonitoringPanel.this.errorPane, fErrorTitle, ColorAndFontConstants.errorTitleFont, fErrorDetails, ColorAndFontConstants.defaultFont);
                }
            }
        });
    }

    private void repopulateTree(JTree tree, boolean forceScroll) {
        this.ignoreSelectionEvents = true;
        ViewPositions pos = Utilities.getViewPositions(this.treeScroll);
        ServerDescriptor server = null;
        if (this.getInfo() != null) {
            server = this.getInfo().getServerDescriptor();
        }
        GeneralMonitoringTreeNode root = server == null ? new GeneralMonitoringTreeNode(AdminToolMessages.INFO_CTRL_PANEL_GENERAL_MONITORING_ROOT.get().toString(), (Object)NodeType.ROOT, true) : new GeneralMonitoringTreeNode(this.getServerName(server), (Object)NodeType.ROOT, true);
        Message[] messages = this.getNodeMessages();
        NodeType[] identifiers = this.getNodeTypes();
        for (int i = 0; i < messages.length; ++i) {
            root.add(new GeneralMonitoringTreeNode(messages[i].toString(), (Object)identifiers[i], false));
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        tree.setModel(model);
        Utilities.updateViewPositions(pos);
        this.ignoreSelectionEvents = false;
    }

    private void updateEntryPane() {
        ViewPositions pos = Utilities.getViewPositions(this.entryPane);
        boolean canDisplayMonitorInformation = true;
        if (this.getInfo() == null) {
            return;
        }
        ServerDescriptor server = this.getInfo().getServerDescriptor();
        ServerDescriptor.ServerStatus status = server.getStatus();
        if (status == ServerDescriptor.ServerStatus.STARTED) {
            if (!server.isAuthenticated()) {
                canDisplayMonitorInformation = false;
                this.entryPane.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_SUMMARY.get());
            }
        } else {
            canDisplayMonitorInformation = false;
            this.entryPane.displayMessage(AdminToolMessages.INFO_CTRL_PANEL_SERVER_NOT_RUNNING_SUMMARY.get());
        }
        if (canDisplayMonitorInformation) {
            TreePath[] paths = this.treePane.getTree().getSelectionPaths();
            TreePath path = null;
            if (paths != null && paths.length == 1) {
                path = paths[0];
            }
            if (path != null) {
                GeneralMonitoringTreeNode node = (GeneralMonitoringTreeNode)path.getLastPathComponent();
                NodeType type = (NodeType)((Object)node.getIdentifier());
                switch (type) {
                    case ROOT: {
                        this.entryPane.updateRoot();
                        break;
                    }
                    case SYSTEM_INFORMATION: {
                        this.entryPane.updateSystemInformation();
                        break;
                    }
                    case WORK_QUEUE: {
                        this.entryPane.updateWorkQueue();
                        break;
                    }
                    case ENTRY_CACHES: {
                        this.entryPane.updateEntryCaches();
                        break;
                    }
                    case DB_ENVIRONMENT: {
                        this.entryPane.updateDBEnvironment();
                        break;
                    }
                    case JAVA_INFORMATION: {
                        this.entryPane.updateJavaInformation();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown node type: " + (Object)((Object)type));
                    }
                }
            } else if (paths != null && paths.length > 1) {
                this.entryPane.displayMessage(this.MULTIPLE_ITEMS_SELECTED);
            } else {
                this.entryPane.displayMessage(this.NO_ELEMENT_SELECTED);
            }
        }
        Utilities.updateViewPositions(pos);
    }

    private DefaultMutableTreeNode getRoot(JTree tree) {
        return (DefaultMutableTreeNode)tree.getModel().getRoot();
    }

    private boolean serverChanged(ServerDescriptor desc) {
        boolean changed = false;
        if (this.lastServer != null) {
            boolean bl = changed = !((Object)desc.getBackends()).equals(this.lastServer.getBackends());
            if (!changed) {
                CustomSearchResult[] monitor1 = new CustomSearchResult[]{this.lastServer.getEntryCachesMonitor(), this.lastServer.getJvmMemoryUsageMonitor(), this.lastServer.getRootMonitor(), this.lastServer.getSystemInformationMonitor(), this.lastServer.getWorkQueueMonitor()};
                CustomSearchResult[] monitor2 = new CustomSearchResult[]{desc.getEntryCachesMonitor(), desc.getJvmMemoryUsageMonitor(), desc.getRootMonitor(), desc.getSystemInformationMonitor(), desc.getWorkQueueMonitor()};
                for (int i = 0; i < monitor1.length && !changed; ++i) {
                    changed = monitor1[i] == null ? monitor2[i] != null : !monitor1[i].equals(monitor2[i]);
                }
            }
        } else {
            changed = true;
        }
        return changed;
    }

    private String getServerName(ServerDescriptor server) {
        String serverName = server.getHostname();
        if (server.getAdminConnector() != null) {
            serverName = serverName + ":" + server.getAdminConnector().getPort();
        }
        return serverName;
    }

    protected Message[] getNodeMessages() {
        return new Message[]{AdminToolMessages.INFO_CTRL_PANEL_SYSTEM_INFORMATION.get(), AdminToolMessages.INFO_CTRL_PANEL_JAVA_INFORMATION.get(), AdminToolMessages.INFO_CTRL_PANEL_WORK_QUEUE.get(), AdminToolMessages.INFO_CTRL_PANEL_ENTRY_CACHES.get(), AdminToolMessages.INFO_CTRL_PANEL_DB_ENVIRONMENT.get()};
    }

    protected NodeType[] getNodeTypes() {
        return new NodeType[]{NodeType.SYSTEM_INFORMATION, NodeType.JAVA_INFORMATION, NodeType.WORK_QUEUE, NodeType.ENTRY_CACHES, NodeType.DB_ENVIRONMENT};
    }

    protected class GeneralMonitoringTreeCellRenderer
    extends TreeCellRenderer {
        private static final long serialVersionUID = -3390566664259441766L;

        protected GeneralMonitoringTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            this.setIcon(this.getIcon(value));
            return this;
        }

        private ImageIcon getIcon(Object value) {
            ImageIcon icon = null;
            if (!(value instanceof GeneralMonitoringTreeNode)) {
                throw new RuntimeException("Unexpected tree node: " + value);
            }
            icon = (ImageIcon)BrowseGeneralMonitoringPanel.this.hmImages.get(((GeneralMonitoringTreeNode)value).getIdentifier());
            return icon;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum NodeType {
        ROOT,
        SYSTEM_INFORMATION,
        JAVA_INFORMATION,
        WORK_QUEUE,
        ENTRY_CACHES,
        DB_ENVIRONMENT;

    }
}

