/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.io.File;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.StartStopTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

public class StopServerTask
extends StartStopTask {
    public StopServerTask(ControlPanelInfo info, ProgressDialog dlg) {
        super(info, dlg);
    }

    public Task.Type getType() {
        return Task.Type.STOP_SERVER;
    }

    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_STOP_SERVER_TASK_DESCRIPTION.get();
    }

    public void runTask() {
        super.runTask();
        if (this.state == Task.State.FINISHED_SUCCESSFULLY) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StopServerTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<b>" + AdminToolMessages.INFO_CTRL_PANEL_SERVER_STOPPED.get() + "</b><br><br>", ColorAndFontConstants.progressFont));
                }
            });
        }
    }

    protected String getCommandLinePath() {
        return this.getCommandLinePath("stop-ds");
    }

    protected void postCommandLine() {
        if (this.returnCode != 0) {
            this.state = Task.State.FINISHED_WITH_ERROR;
        } else {
            File f = new File(this.getInfo().getServerDescriptor().getInstancePath());
            boolean stopped = !Utilities.isServerRunning(f);
            for (int nTries = 20; !stopped && nTries > 0; --nTries) {
                try {
                    Thread.sleep(700L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                stopped = !Utilities.isServerRunning(f);
            }
            if (!stopped) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StopServerTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br>" + AdminToolMessages.ERR_CTRL_PANEL_STOPPING_SERVER_POST_CMD_LINE.get(StopServerTask.this.getCommandLinePath("stop-ds")) + "<br>", ColorAndFontConstants.progressFont));
                    }
                });
                this.returnCode = -1;
                this.state = Task.State.FINISHED_WITH_ERROR;
            } else {
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
        }
    }
}

