/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.NewSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyObjectClassTask
extends Task {
    private ObjectClass oldObjectClass;
    private ObjectClass newObjectClass;

    public ModifyObjectClassTask(ControlPanelInfo info, ProgressDialog dlg, ObjectClass oldObjectClass, ObjectClass newObjectClass) {
        super(info, dlg);
        this.oldObjectClass = oldObjectClass;
        this.newObjectClass = newObjectClass;
        if (oldObjectClass == null) {
            throw new IllegalArgumentException("oldObjectClass cannot be null.");
        }
        if (newObjectClass == null) {
            throw new IllegalArgumentException("newObjectClass cannot be null.");
        }
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_SCHEMA_ELEMENT;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_MODIFY_OBJECTCLASS_TASK_DESCRIPTION.get(this.oldObjectClass.getNameOrOID());
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING && (taskToBeLaunched.getType() == Task.Type.DELETE_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.MODIFY_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.NEW_SCHEMA_ELEMENT)) {
            incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
            canLaunch = false;
        }
        return canLaunch;
    }

    @Override
    public Set<String> getBackends() {
        return Collections.emptySet();
    }

    @Override
    protected List<String> getCommandLineArguments() {
        return Collections.emptyList();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    @Override
    public void runTask() {
        try {
            this.updateSchema();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private ObjectClass getObjectClassToAdd(ObjectClass ocToDelete) {
        ObjectClass ocToAdd;
        if (ocToDelete.equals(this.oldObjectClass)) {
            ocToAdd = this.newObjectClass;
        } else if (this.oldObjectClass.equals(ocToDelete.getSuperiorClass())) {
            ArrayList<String> allNames = new ArrayList<String>();
            for (String str : ocToDelete.getNormalizedNames()) {
                allNames.add(str);
            }
            Map<String, List<String>> extraProperties = DeleteSchemaElementsTask.cloneExtraProperties(ocToDelete);
            ocToAdd = new ObjectClass("", ocToDelete.getPrimaryName(), allNames, ocToDelete.getOID(), ocToDelete.getDescription(), this.newObjectClass, ocToDelete.getRequiredAttributes(), ocToDelete.getOptionalAttributes(), ocToDelete.getObjectClassType(), ocToDelete.isObsolete(), extraProperties);
        } else {
            ocToAdd = ocToDelete;
        }
        return ocToAdd;
    }

    private void updateSchema() throws OpenDsException {
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        ArrayList<ObjectClass> ocs = new ArrayList<ObjectClass>();
        ocs.add(this.oldObjectClass);
        LinkedHashSet<ObjectClass> ocsToDelete = DeleteSchemaElementsTask.getOrderedObjectClassesToDelete(ocs, schema);
        ArrayList<ObjectClass> lOcsToDelete = new ArrayList<ObjectClass>(ocsToDelete);
        LinkedHashSet<ObjectClass> ocsToAdd = new LinkedHashSet<ObjectClass>();
        for (int i = lOcsToDelete.size() - 1; i >= 0; --i) {
            ocsToAdd.add(this.getObjectClassToAdd(lOcsToDelete.get(i)));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModifyObjectClassTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EXPLANATION_TO_MODIFY_OBJECTCLASS.get(ModifyObjectClassTask.this.oldObjectClass.getNameOrOID()) + "<br><br>", ColorAndFontConstants.progressFont));
            }
        });
        DeleteSchemaElementsTask deleteTask = new DeleteSchemaElementsTask(this.getInfo(), this.getProgressDialog(), ocsToDelete, new LinkedHashSet<AttributeType>(0));
        deleteTask.runTask();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModifyObjectClassTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br><br>", ColorAndFontConstants.progressFont));
            }
        });
        NewSchemaElementsTask createTask = new NewSchemaElementsTask(this.getInfo(), this.getProgressDialog(), ocsToAdd, new LinkedHashSet<AttributeType>(0));
        createTask.runTask();
        this.notifyConfigurationElementCreated(this.newObjectClass);
    }
}

