/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.task.DeleteSchemaElementsTask;
import org.opends.guitools.controlpanel.task.NewSchemaElementsTask;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyAttributeTask
extends Task {
    private AttributeType oldAttribute;
    private AttributeType newAttribute;

    public ModifyAttributeTask(ControlPanelInfo info, ProgressDialog dlg, AttributeType oldAttribute, AttributeType newAttribute) {
        super(info, dlg);
        if (oldAttribute == null) {
            throw new IllegalArgumentException("oldAttribute cannot be null.");
        }
        if (newAttribute == null) {
            throw new IllegalArgumentException("newAttribute cannot be null.");
        }
        this.oldAttribute = oldAttribute;
        this.newAttribute = newAttribute;
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_SCHEMA_ELEMENT;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_MODIFY_ATTRIBUTE_TASK_DESCRIPTION.get(this.oldAttribute.getNameOrOID());
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (this.state == Task.State.RUNNING && (taskToBeLaunched.getType() == Task.Type.DELETE_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.MODIFY_SCHEMA_ELEMENT || taskToBeLaunched.getType() == Task.Type.NEW_SCHEMA_ELEMENT)) {
            incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
            canLaunch = false;
        }
        return canLaunch;
    }

    @Override
    public Set<String> getBackends() {
        return Collections.emptySet();
    }

    @Override
    protected List<String> getCommandLineArguments() {
        return Collections.emptyList();
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    @Override
    public void runTask() {
        try {
            this.updateSchema();
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private AttributeType getAttributeToAdd(AttributeType attrToDelete) {
        AttributeType attrToAdd;
        if (attrToDelete.equals(this.oldAttribute)) {
            attrToAdd = this.newAttribute;
        } else if (this.oldAttribute.equals(attrToDelete.getSuperiorType())) {
            ArrayList<String> allNames = new ArrayList<String>();
            for (String str : attrToDelete.getNormalizedNames()) {
                allNames.add(str);
            }
            Map<String, List<String>> extraProperties = DeleteSchemaElementsTask.cloneExtraProperties(attrToDelete);
            AttributeType newSuperior = this.newAttribute;
            attrToAdd = new AttributeType("", attrToDelete.getPrimaryName(), allNames, attrToDelete.getOID(), attrToDelete.getDescription(), newSuperior, attrToDelete.getSyntax(), attrToDelete.getApproximateMatchingRule(), attrToDelete.getEqualityMatchingRule(), attrToDelete.getOrderingMatchingRule(), attrToDelete.getSubstringMatchingRule(), attrToDelete.getUsage(), attrToDelete.isCollective(), attrToDelete.isNoUserModification(), attrToDelete.isObsolete(), attrToDelete.isSingleValue(), extraProperties);
        } else {
            attrToAdd = attrToDelete;
        }
        return attrToAdd;
    }

    private ObjectClass getObjectClassToAdd(ObjectClass ocToDelete) {
        ObjectClass ocToAdd;
        boolean containsAttribute;
        boolean bl = containsAttribute = ocToDelete.getRequiredAttributeChain().contains(this.oldAttribute) || ocToDelete.getOptionalAttributeChain().contains(this.oldAttribute);
        if (containsAttribute) {
            ArrayList<String> allNames = new ArrayList<String>();
            for (String str : ocToDelete.getNormalizedNames()) {
                allNames.add(str);
            }
            Map<String, List<String>> extraProperties = DeleteSchemaElementsTask.cloneExtraProperties(ocToDelete);
            HashSet<AttributeType> required = new HashSet<AttributeType>(ocToDelete.getRequiredAttributes());
            HashSet<AttributeType> optional = new HashSet<AttributeType>(ocToDelete.getOptionalAttributes());
            if (required.contains(this.oldAttribute)) {
                required.remove(this.oldAttribute);
                required.add(this.newAttribute);
            } else if (optional.contains(this.oldAttribute)) {
                optional.remove(this.oldAttribute);
                optional.add(this.newAttribute);
            }
            ocToAdd = new ObjectClass("", ocToDelete.getPrimaryName(), allNames, ocToDelete.getOID(), ocToDelete.getDescription(), ocToDelete.getSuperiorClass(), required, optional, ocToDelete.getObjectClassType(), ocToDelete.isObsolete(), extraProperties);
        } else {
            ocToAdd = ocToDelete;
        }
        return ocToAdd;
    }

    private void updateSchema() throws OpenDsException {
        Schema schema = this.getInfo().getServerDescriptor().getSchema();
        ArrayList<AttributeType> attrs = new ArrayList<AttributeType>();
        attrs.add(this.oldAttribute);
        LinkedHashSet<AttributeType> attrsToDelete = DeleteSchemaElementsTask.getOrderedAttributesToDelete(attrs, schema);
        LinkedHashSet<ObjectClass> ocsToDelete = DeleteSchemaElementsTask.getOrderedObjectClassesToDeleteFromAttrs(attrsToDelete, schema);
        LinkedHashSet<AttributeType> attrsToAdd = new LinkedHashSet<AttributeType>();
        ArrayList<AttributeType> lAttrsToDelete = new ArrayList<AttributeType>(attrsToDelete);
        for (int i = lAttrsToDelete.size() - 1; i >= 0; --i) {
            AttributeType attrToAdd = this.getAttributeToAdd(lAttrsToDelete.get(i));
            if (attrToAdd == null) continue;
            attrsToAdd.add(attrToAdd);
        }
        ArrayList<ObjectClass> lOcsToDelete = new ArrayList<ObjectClass>(ocsToDelete);
        LinkedHashSet<ObjectClass> ocsToAdd = new LinkedHashSet<ObjectClass>();
        for (int i = lOcsToDelete.size() - 1; i >= 0; --i) {
            ocsToAdd.add(this.getObjectClassToAdd(lOcsToDelete.get(i)));
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModifyAttributeTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EXPLANATION_TO_MODIFY_ATTRIBUTE.get(ModifyAttributeTask.this.oldAttribute.getNameOrOID()) + "<br><br>", ColorAndFontConstants.progressFont));
            }
        });
        DeleteSchemaElementsTask deleteTask = new DeleteSchemaElementsTask(this.getInfo(), this.getProgressDialog(), ocsToDelete, attrsToDelete);
        deleteTask.runTask();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModifyAttributeTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont("<br><br>", ColorAndFontConstants.progressFont));
            }
        });
        NewSchemaElementsTask createTask = new NewSchemaElementsTask(this.getInfo(), this.getProgressDialog(), ocsToAdd, attrsToAdd);
        createTask.runTask();
        this.notifyConfigurationElementCreated(this.newAttribute);
    }
}

