/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.event;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.table.TableCellRenderer;

public class ClickTooltipDisplayer
extends MouseAdapter {
    private boolean isTooltipVisible = false;
    private Popup tipWindow;

    public void mouseExited(MouseEvent event) {
        this.hideToolTip(event);
    }

    public void mousePressed(MouseEvent event) {
        if (this.isTooltipVisible) {
            this.hideToolTip(event);
        } else {
            this.displayToolTip(event);
        }
    }

    private void displayToolTip(MouseEvent event) {
        String toolTipText;
        JComponent component = (JComponent)event.getSource();
        if (component instanceof JTable) {
            JTable table = (JTable)component;
            int row = table.rowAtPoint(event.getPoint());
            int column = table.columnAtPoint(event.getPoint());
            if (row != -1 && column != -1) {
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, column), true, true, row, column);
                if (comp instanceof JComponent) {
                    Rectangle rect = table.getCellRect(row, column, true);
                    int x = event.getPoint().x - rect.x;
                    int y = event.getPoint().y - rect.y;
                    MouseEvent tEv = new MouseEvent(table, event.getID(), event.getWhen(), event.getModifiers(), x, y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
                    toolTipText = ((JComponent)comp).getToolTipText(tEv);
                } else {
                    toolTipText = null;
                }
            } else {
                toolTipText = null;
            }
        } else {
            toolTipText = component.getToolTipText();
        }
        if (toolTipText != null) {
            Point preferredLocation = component.getToolTipLocation(event);
            Rectangle sBounds = component.getGraphicsConfiguration().getBounds();
            JToolTip tip = component.createToolTip();
            tip.setTipText(toolTipText);
            Dimension size = tip.getPreferredSize();
            Point location = new Point();
            Point screenLocation = component.getLocationOnScreen();
            if (preferredLocation != null) {
                location.x = screenLocation.x + preferredLocation.x;
                location.y = screenLocation.y + preferredLocation.y;
            } else {
                location.x = screenLocation.x + event.getX();
                location.y = screenLocation.y + event.getY() + 20;
            }
            if (location.x < sBounds.x) {
                location.x = sBounds.x;
            } else if (location.x - sBounds.x + size.width > sBounds.width) {
                location.x = sBounds.x + Math.max(0, sBounds.width - size.width);
            }
            if (location.y < sBounds.y) {
                location.y = sBounds.y;
            } else if (location.y - sBounds.y + size.height > sBounds.height) {
                location.y = sBounds.y + Math.max(0, sBounds.height - size.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(component, tip, location.x, location.y);
            this.tipWindow.show();
            this.isTooltipVisible = true;
        }
    }

    private void hideToolTip(MouseEvent event) {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.isTooltipVisible = false;
        }
    }
}

