/*
 * Decompiled with CFR 0.152.
 */
package org.opends.admin.ads.util;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.opends.admin.ads.util.OpendsCertificateException;
import org.opends.server.util.Platform;

public class ApplicationTrustManager
implements X509TrustManager {
    private static final Logger LOG = Logger.getLogger(ApplicationTrustManager.class.getName());
    private X509TrustManager trustManager;
    private String lastRefusedAuthType;
    private X509Certificate[] lastRefusedChain;
    private Cause lastRefusedCause = null;
    private KeyStore keystore = null;
    private ArrayList<X509Certificate[]> acceptedChains = new ArrayList();
    private ArrayList<String> acceptedAuthTypes = new ArrayList();
    private ArrayList<String> acceptedHosts = new ArrayList();
    private String host;

    public ApplicationTrustManager(KeyStore keystore) {
        TrustManagerFactory tmf = null;
        this.keystore = keystore;
        String userSpecifiedAlgo = System.getProperty("org.opends.admin.trustmanageralgo");
        String userSpecifiedProvider = System.getProperty("org.opends.admin.trustmanagerprovider");
        if (userSpecifiedAlgo == null && Platform.isVendor("IBM")) {
            userSpecifiedAlgo = "IbmX509";
        }
        if (userSpecifiedProvider == null && Platform.isVendor("IBM")) {
            userSpecifiedProvider = "IBMJSSE2";
        }
        String[] preferredProvider = new String[]{userSpecifiedProvider, "SunJSSE", null, null};
        String[] preferredAlgo = new String[]{userSpecifiedAlgo, "SunX509", "SunX509", TrustManagerFactory.getDefaultAlgorithm()};
        block4: for (int i = 0; i < preferredProvider.length && this.trustManager == null; ++i) {
            String provider = preferredProvider[i];
            String algo = preferredAlgo[i];
            if (algo == null) continue;
            try {
                tmf = provider != null ? TrustManagerFactory.getInstance(algo, provider) : TrustManagerFactory.getInstance(algo);
                tmf.init(keystore);
                TrustManager[] trustManagers = tmf.getTrustManagers();
                for (int j = 0; j < trustManagers.length; ++j) {
                    if (!(trustManagers[j] instanceof X509TrustManager)) continue;
                    this.trustManager = (X509TrustManager)trustManagers[j];
                    continue block4;
                }
                continue;
            }
            catch (NoSuchProviderException e) {
                LOG.log(Level.WARNING, "Error with the provider: " + provider, e);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.WARNING, "Error with the algorithm: " + algo, e);
                continue;
            }
            catch (KeyStoreException e) {
                LOG.log(Level.WARNING, "Error with the keystore", e);
            }
        }
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean explicitlyAccepted = false;
        try {
            if (this.trustManager != null) {
                try {
                    this.trustManager.checkClientTrusted(chain, authType);
                }
                catch (CertificateException ce) {
                    this.verifyAcceptedCertificates(chain, authType);
                    explicitlyAccepted = true;
                }
            } else {
                this.verifyAcceptedCertificates(chain, authType);
                explicitlyAccepted = true;
            }
        }
        catch (CertificateException ce) {
            this.lastRefusedChain = chain;
            this.lastRefusedAuthType = authType;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            OpendsCertificateException e = new OpendsCertificateException(chain);
            e.initCause(ce);
            throw e;
        }
        if (!explicitlyAccepted) {
            try {
                this.verifyHostName(chain, authType);
            }
            catch (CertificateException ce) {
                this.lastRefusedChain = chain;
                this.lastRefusedAuthType = authType;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                OpendsCertificateException e = new OpendsCertificateException(chain);
                e.initCause(ce);
                throw e;
            }
        }
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        boolean explicitlyAccepted = false;
        try {
            if (this.trustManager != null) {
                try {
                    this.trustManager.checkServerTrusted(chain, authType);
                }
                catch (CertificateException ce) {
                    this.verifyAcceptedCertificates(chain, authType);
                    explicitlyAccepted = true;
                }
            } else {
                this.verifyAcceptedCertificates(chain, authType);
                explicitlyAccepted = true;
            }
        }
        catch (CertificateException ce) {
            this.lastRefusedChain = chain;
            this.lastRefusedAuthType = authType;
            this.lastRefusedCause = Cause.NOT_TRUSTED;
            OpendsCertificateException e = new OpendsCertificateException(chain);
            e.initCause(ce);
            throw e;
        }
        if (!explicitlyAccepted) {
            try {
                this.verifyHostName(chain, authType);
            }
            catch (CertificateException ce) {
                this.lastRefusedChain = chain;
                this.lastRefusedAuthType = authType;
                this.lastRefusedCause = Cause.HOST_NAME_MISMATCH;
                OpendsCertificateException e = new OpendsCertificateException(chain);
                e.initCause(ce);
                throw e;
            }
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        if (this.trustManager != null) {
            return this.trustManager.getAcceptedIssuers();
        }
        return new X509Certificate[0];
    }

    public void acceptCertificate(X509Certificate[] chain, String authType, String host) {
        this.acceptedChains.add(chain);
        this.acceptedAuthTypes.add(authType);
        this.acceptedHosts.add(host);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void resetLastRefusedItems() {
        this.lastRefusedAuthType = null;
        this.lastRefusedChain = null;
        this.lastRefusedCause = null;
    }

    public ApplicationTrustManager createCopy() {
        ApplicationTrustManager copy = new ApplicationTrustManager(this.keystore);
        copy.lastRefusedAuthType = this.lastRefusedAuthType;
        copy.lastRefusedChain = this.lastRefusedChain;
        copy.lastRefusedCause = this.lastRefusedCause;
        copy.acceptedChains.addAll(this.acceptedChains);
        copy.acceptedAuthTypes.addAll(this.acceptedAuthTypes);
        copy.acceptedHosts.addAll(this.acceptedHosts);
        copy.host = this.host;
        return copy;
    }

    private void verifyAcceptedCertificates(X509Certificate[] chain, String authType) throws CertificateException {
        boolean found = false;
        for (int i = 0; i < this.acceptedChains.size() && !found; ++i) {
            if (!authType.equals(this.acceptedAuthTypes.get(i))) continue;
            X509Certificate[] current = this.acceptedChains.get(i);
            found = current.length == chain.length;
            for (int j = 0; j < chain.length && found; ++j) {
                found = chain[j].equals(current[j]);
            }
        }
        if (!found) {
            throw new OpendsCertificateException("Certificate not in list of accepted certificates", chain);
        }
    }

    private void verifyHostName(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.host != null) {
            boolean matches = false;
            try {
                LdapName dn = new LdapName(chain[0].getSubjectX500Principal().getName());
                Rdn rdn = dn.getRdn(dn.getRdns().size() - 1);
                String value = rdn.getValue().toString();
                matches = this.hostMatch(value, this.host);
                if (!matches) {
                    LOG.log(Level.WARNING, "Subject DN RDN value is: " + value + " and does not match host value: " + this.host);
                    for (int i = 0; i < this.acceptedHosts.size() && !matches; ++i) {
                        if (!this.hostMatch(this.acceptedHosts.get(i), this.host)) continue;
                        X509Certificate[] current = this.acceptedChains.get(i);
                        matches = current.length == chain.length;
                        for (int j = 0; j < chain.length && matches; ++j) {
                            matches = chain[j].equals(current[j]);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error parsing subject dn: " + chain[0].getSubjectX500Principal(), t);
            }
            if (!matches) {
                throw new OpendsCertificateException("Hostname mismatch between host name " + this.host + " and subject DN: " + chain[0].getSubjectX500Principal(), chain);
            }
        }
    }

    public String getLastRefusedAuthType() {
        return this.lastRefusedAuthType;
    }

    public Cause getLastRefusedCause() {
        return this.lastRefusedCause;
    }

    public X509Certificate[] getLastRefusedChain() {
        return this.lastRefusedChain;
    }

    private boolean hostMatch(String host1, String host2) {
        String[] h2;
        if (host1 == null) {
            throw new IllegalArgumentException("The host1 parameter cannot be null");
        }
        if (host2 == null) {
            throw new IllegalArgumentException("The host2 parameter cannot be null");
        }
        String[] h1 = host1.split("\\.");
        boolean hostMatch = h1.length == (h2 = host2.split("\\.")).length;
        for (int i = 0; i < h1.length && hostMatch; ++i) {
            if (h1[i].equals("*") || h2.equals("*")) continue;
            hostMatch = h1[i].equalsIgnoreCase(h2[i]);
        }
        return hostMatch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Cause {
        NOT_TRUSTED,
        HOST_NAME_MISMATCH;

    }
}

