/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.SshToolsApplicationApplet;
import com.sshtools.common.ui.SshToolsApplicationClientPanel;
import com.sshtools.common.util.PropertyUtil;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationClientApplet
extends SshToolsApplicationApplet {
    public static final String[][] CLIENT_PARAMETER_INFO = new String[][]{{"sshapps.connection.url", "string", "The URL of a connection profile to open"}, {"sshapps.connection.host", "string", "The host to connect to"}, {"sshapps.connection.userName", "string", "The user to connect as"}, {"sshapps.connection.authenticationMethod", "string", "Authentication method. password,publickey etc."}, {"sshapps.connection.connectImmediately", "boolean", "Connect immediately."}, {"sshapps.connection.showConnectionDialog", "boolean", "Show connection dialog."}, {"sshapps.connection.disableHostKeyVerification", "boolean", "Disable the host key verification dialog."}};
    protected Log log = LogFactory.getLog((Class)(class$com$sshtools$common$ui$SshToolsApplicationClientApplet == null ? (class$com$sshtools$common$ui$SshToolsApplicationClientApplet = SshToolsApplicationClientApplet.class$("com.sshtools.common.ui.SshToolsApplicationClientApplet")) : class$com$sshtools$common$ui$SshToolsApplicationClientApplet));
    private String connectionProfileLocation;
    protected String authenticationMethod;
    protected String host;
    protected int port;
    protected String user;
    protected boolean connectImmediately;
    protected boolean showConnectionDialog;
    protected boolean disableHostKeyVerification;
    protected SshToolsConnectionProfile profile;
    static /* synthetic */ Class class$com$sshtools$common$ui$SshToolsApplicationClientApplet;

    public void initApplet() throws IOException {
        super.initApplet();
        this.connectionProfileLocation = this.getParameter("sshapps.connectionProfile.url", "");
        this.host = this.getParameter("sshapps.connection.host", "");
        this.port = PropertyUtil.stringToInt(this.getParameter("sshapps.connection.port", ""), 22);
        this.user = this.getParameter("sshapps.connection.userName", ConfigurationLoader.checkAndGetProperty((String)"user.home", (String)""));
        this.authenticationMethod = this.getParameter("sshapps.connection.authenticationMethod", "");
        this.connectImmediately = this.getParameter("sshapps.connection.connectImmediately", "false").equalsIgnoreCase("true");
        this.showConnectionDialog = this.getParameter("sshapps.connection.showConnectionDialog", "false").equalsIgnoreCase("true");
        this.disableHostKeyVerification = this.getParameter("sshapps.connection.disableHostKeyVerification", "false").equalsIgnoreCase("true");
        this.buildProfile();
    }

    public void startApplet() {
        if (this.disableHostKeyVerification) {
            ((SshToolsApplicationClientPanel)this.applicationPanel).setHostHostVerification(null);
            ((SshToolsApplicationClientPanel)this.applicationPanel).application.removeAdditionalOptionsTab("Hosts");
            this.log.debug((Object)"Host key verification disabled");
        } else {
            this.log.debug((Object)"Host key verification enabled");
        }
        if (this.connectImmediately) {
            this.loadingPanel.setStatus("Connecting");
            if (this.showConnectionDialog) {
                SshToolsConnectionProfile sshToolsConnectionProfile = ((SshToolsApplicationClientPanel)this.applicationPanel).newConnectionProfile(this.profile);
                if (sshToolsConnectionProfile != null) {
                    this.profile = sshToolsConnectionProfile;
                    ((SshToolsApplicationClientPanel)this.applicationPanel).connect(this.profile, true);
                }
            } else {
                ((SshToolsApplicationClientPanel)this.applicationPanel).connect(this.profile, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildProfile() throws IOException {
        InputStream inputStream;
        this.profile = new SshToolsConnectionProfile();
        if (!this.connectionProfileLocation.equals("")) {
            this.log.info((Object)("Loading connection profile " + this.connectionProfileLocation));
            this.loadingPanel.setStatus("Loading connection profile");
            inputStream = null;
            try {
                URL uRL = null;
                try {
                    uRL = new URL(this.connectionProfileLocation);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = new URL(this.getCodeBase() + "/" + this.connectionProfileLocation);
                }
                this.log.info((Object)("Full URL of connection profile is " + uRL));
                inputStream = uRL.openStream();
                this.profile.open(inputStream);
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                IOUtil.closeStream(inputStream);
                throw throwable;
            }
            IOUtil.closeStream((InputStream)inputStream);
            {
            }
        }
        if (!this.host.equals("")) {
            this.log.info((Object)"Building connection profile from parameters ");
            this.log.debug((Object)("Setting host to " + this.host));
            this.profile.setHost(this.host);
            this.log.debug((Object)("Setting port to " + this.port));
            this.profile.setPort(this.port);
            this.log.debug((Object)("Setting username to " + this.user));
            this.profile.setUsername(this.user);
            if (!this.authenticationMethod.equals("")) {
                try {
                    this.log.debug((Object)("Adding authentication method " + this.authenticationMethod));
                    inputStream = SshAuthenticationClientFactory.newInstance((String)this.authenticationMethod);
                    this.profile.addAuthenticationMethod((SshAuthenticationClient)inputStream);
                }
                catch (Exception exception) {
                    this.log.error((Object)"Could not add authentication method.", (Throwable)exception);
                }
            }
        }
    }

    public void destroy() {
        if (this.applicationPanel.isConnected()) {
            ((SshToolsApplicationClientPanel)this.applicationPanel).closeConnection(true);
        }
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = super.getParameterInfo();
        String[][] stringArray2 = new String[stringArray.length + CLIENT_PARAMETER_INFO.length][];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        System.arraycopy(CLIENT_PARAMETER_INFO, 0, stringArray2, stringArray.length, CLIENT_PARAMETER_INFO.length);
        return stringArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

