/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.javascript.taglib;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.springframework.util.Assert;
import org.springframework.web.servlet.tags.RequestContextAwareTag;
import org.springmodules.validation.valang.javascript.ValangJavaScriptTranslator;

public class ValangCodebaseTag
extends RequestContextAwareTag {
    private boolean includeScriptTags;

    public void setIncludeScriptTags(String includeScriptTags) {
        this.includeScriptTags = "true".equalsIgnoreCase(includeScriptTags);
    }

    protected int doStartTagInternal() throws ServletException, JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.pageContext.getOut();
            if (this.includeScriptTags) {
                out.write("<script type=\"text/javascript\">\n");
            }
            this.copy(ValangJavaScriptTranslator.getCodebaseReader(), (Writer)out);
            if (this.includeScriptTags) {
                out.write("\n</script>");
            }
            return 6;
        }
        catch (IOException e) {
            throw new JspException("Could not write validation codebase", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(Reader in, Writer out) throws IOException {
        Assert.notNull((Object)in, (String)"No Reader specified");
        Assert.notNull((Object)out, (String)"No Writer specified");
        try {
            int bytesRead;
            char[] buffer = new char[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                this.logger.warn((Object)"Could not close Reader", (Throwable)ex);
            }
        }
    }

    public void doFinally() {
        super.doFinally();
        this.includeScriptTags = false;
    }
}

