/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.theme;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.web.util.WebUtils;

public class CookieThemeResolver
extends AbstractThemeResolver {
    public static final String THEME_REQUEST_ATTRIBUTE_NAME = (class$org$springframework$web$servlet$theme$CookieThemeResolver == null ? (class$org$springframework$web$servlet$theme$CookieThemeResolver = CookieThemeResolver.class$("org.springframework.web.servlet.theme.CookieThemeResolver")) : class$org$springframework$web$servlet$theme$CookieThemeResolver).getName() + ".THEME";
    public static final String DEFAULT_COOKIE_NAME = (class$org$springframework$web$servlet$theme$CookieThemeResolver == null ? (class$org$springframework$web$servlet$theme$CookieThemeResolver = CookieThemeResolver.class$("org.springframework.web.servlet.theme.CookieThemeResolver")) : class$org$springframework$web$servlet$theme$CookieThemeResolver).getName() + ".THEME";
    public static final String DEFAULT_COOKIE_PATH = "/";
    public static final int DEFAULT_COOKIE_MAX_AGE = Integer.MAX_VALUE;
    private String cookieName = DEFAULT_COOKIE_NAME;
    private int cookieMaxAge = Integer.MAX_VALUE;
    private String cookiePath = "/";
    static /* synthetic */ Class class$org$springframework$web$servlet$theme$CookieThemeResolver;

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookiePath(String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookieMaxAge(int cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public int getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public String resolveThemeName(HttpServletRequest request) {
        String theme = (String)request.getAttribute(THEME_REQUEST_ATTRIBUTE_NAME);
        if (theme != null) {
            return theme;
        }
        Cookie cookie = WebUtils.getCookie(request, this.getCookieName());
        if (cookie != null) {
            return cookie.getValue();
        }
        return this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
        Cookie cookie = null;
        if (themeName != null) {
            request.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)themeName);
            cookie = new Cookie(this.getCookieName(), themeName);
            cookie.setPath(this.getCookiePath());
            cookie.setMaxAge(this.getCookieMaxAge());
        } else {
            request.setAttribute(THEME_REQUEST_ATTRIBUTE_NAME, (Object)this.getDefaultThemeName());
            cookie = new Cookie(this.getCookieName(), "");
            cookie.setPath(this.getCookiePath());
            cookie.setMaxAge(0);
        }
        response.addCookie(cookie);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

