/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.BaseCommandController;

public abstract class AbstractFormController
extends BaseCommandController {
    private boolean bindOnNewForm = false;
    private boolean sessionForm = false;

    public final void setBindOnNewForm(boolean bindOnNewForm) {
        this.bindOnNewForm = bindOnNewForm;
    }

    protected final boolean isBindOnNewForm() {
        return this.bindOnNewForm;
    }

    public final void setSessionForm(boolean sessionForm) {
        this.sessionForm = sessionForm;
    }

    protected final boolean isSessionForm() {
        return this.sessionForm;
    }

    protected final String getFormSessionAttributeName() {
        return this.isSessionForm() ? this.getClass().getName() + ".form." + this.getCommandName() : null;
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isFormSubmission(request)) {
            if (this.isSessionForm() && request.getSession().getAttribute(this.getFormSessionAttributeName()) == null) {
                return this.handleInvalidSubmit(request, response);
            }
            Object command = this.getCommand(request);
            ServletRequestDataBinder binder = this.bindAndValidate(request, command);
            return this.processFormSubmission(request, response, command, binder.getErrors());
        }
        return this.showNewForm(request, response);
    }

    protected boolean isFormSubmission(HttpServletRequest request) {
        return "POST".equals(request.getMethod());
    }

    protected final ModelAndView showNewForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.logger.debug((Object)"Displaying new form");
        Object formObject = this.formBackingObject(request);
        if (formObject == null) {
            throw new ServletException("Form object returned by formBackingObject() may not be null");
        }
        if (!this.checkCommand(formObject)) {
            throw new ServletException("Form object returned by formBackingObject() must match commandClass");
        }
        ServletRequestDataBinder binder = this.createBinder(request, formObject);
        if (this.isBindOnNewForm()) {
            this.logger.debug((Object)"Binding to new form");
            binder.bind((ServletRequest)request);
        }
        return this.showForm(request, response, binder.getErrors());
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        return this.createCommand();
    }

    protected abstract ModelAndView showForm(HttpServletRequest var1, HttpServletResponse var2, BindException var3) throws Exception;

    protected final ModelAndView showForm(HttpServletRequest request, BindException errors, String viewName) throws Exception {
        return this.showForm(request, errors, viewName, null);
    }

    protected final ModelAndView showForm(HttpServletRequest request, BindException errors, String viewName, Map controlModel) throws Exception {
        if (this.isSessionForm()) {
            request.getSession().setAttribute(this.getFormSessionAttributeName(), errors.getTarget());
        }
        Map model = errors.getModel();
        Map referenceData = this.referenceData(request, errors.getTarget(), errors);
        if (referenceData != null) {
            model.putAll(referenceData);
        }
        if (controlModel != null) {
            model.putAll(controlModel);
        }
        return new ModelAndView(viewName, model);
    }

    protected Map referenceData(HttpServletRequest request, Object command, Errors errors) throws Exception {
        return null;
    }

    protected ModelAndView handleInvalidSubmit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object command = this.formBackingObject(request);
        ServletRequestDataBinder binder = this.bindAndValidate(request, command);
        return this.processFormSubmission(request, response, command, binder.getErrors());
    }

    protected final Object getCommand(HttpServletRequest request) throws Exception {
        if (!this.isSessionForm()) {
            return this.formBackingObject(request);
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new ServletException("Must have session when trying to bind");
        }
        Object formObject = session.getAttribute(this.getFormSessionAttributeName());
        session.removeAttribute(this.getFormSessionAttributeName());
        if (formObject == null) {
            throw new ServletException("Form object not found in session");
        }
        return formObject;
    }

    protected abstract ModelAndView processFormSubmission(HttpServletRequest var1, HttpServletResponse var2, Object var3, BindException var4) throws Exception;
}

