/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.JdoCallback;
import org.springframework.orm.jdo.JdoOperations;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JdoTemplate
extends JdoAccessor
implements JdoOperations {
    private boolean allowCreate = true;
    private boolean exposeNativePersistenceManager = true;
    static /* synthetic */ Class class$javax$jdo$PersistenceManager;

    public JdoTemplate() {
    }

    public JdoTemplate(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
        this.afterPropertiesSet();
    }

    public JdoTemplate(PersistenceManagerFactory pmf, boolean allowCreate) {
        this.setPersistenceManagerFactory(pmf);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setExposeNativePersistenceManager(boolean exposeNativePersistenceManager) {
        this.exposeNativePersistenceManager = exposeNativePersistenceManager;
    }

    public boolean isExposeNativePersistenceManager() {
        return this.exposeNativePersistenceManager;
    }

    public Object execute(JdoCallback action) throws DataAccessException {
        return this.execute(action, this.isExposeNativePersistenceManager());
    }

    public Collection executeFind(JdoCallback action) throws DataAccessException {
        return (Collection)this.execute(action, this.isExposeNativePersistenceManager());
    }

    public Object execute(JdoCallback action, boolean exposeNativePersistenceManager) throws DataAccessException {
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), this.isAllowCreate());
        boolean existingTransaction = TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory());
        try {
            PersistenceManager pmToExpose = exposeNativePersistenceManager ? pm : this.createPersistenceManagerProxy(pm);
            Object result = action.doInJdo(pmToExpose);
            this.flushIfNecessary(pm, existingTransaction);
            Object object = result;
            return object;
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, this.getPersistenceManagerFactory());
        }
    }

    protected PersistenceManager createPersistenceManagerProxy(PersistenceManager pm) {
        return (PersistenceManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$javax$jdo$PersistenceManager == null ? (class$javax$jdo$PersistenceManager = JdoTemplate.class$("javax.jdo.PersistenceManager")) : class$javax$jdo$PersistenceManager}, (InvocationHandler)new CloseSuppressingInvocationHandler(pm));
    }

    public Object getObjectById(final Serializable objectId) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.getObjectById((Object)objectId, true);
            }
        });
    }

    public Object getObjectById(final Class entityClass, final Serializable idValue) throws DataAccessException {
        return this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Object oid = pm.newObjectIdInstance(entityClass, idValue.toString());
                return pm.getObjectById(oid, true);
            }
        });
    }

    public void evict(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evict(entity);
                return null;
            }
        });
    }

    public void evictAll() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evictAll();
                return null;
            }
        });
    }

    public void refresh(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refresh(entity);
                return null;
            }
        });
    }

    public void refreshAll() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refreshAll();
                return null;
            }
        });
    }

    public void makePersistent(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.makePersistent(entity);
                return null;
            }
        });
    }

    public void deletePersistent(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistent(entity);
                return null;
            }
        });
    }

    public void deletePersistentAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistentAll(entities);
                return null;
            }
        });
    }

    public void flush() throws DataAccessException {
        this.execute(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                JdoTemplate.this.getJdoDialect().flush(pm);
                return null;
            }
        });
    }

    public Collection find(Class entityClass) throws DataAccessException {
        return this.find(entityClass, null, null);
    }

    public Collection find(Class entityClass, String filter) throws DataAccessException {
        return this.find(entityClass, filter, null);
    }

    public Collection find(final Class entityClass, final String filter, final String ordering) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = filter != null ? pm.newQuery(entityClass, filter) : pm.newQuery(entityClass);
                JdoTemplate.this.prepareQuery(query);
                if (ordering != null) {
                    query.setOrdering(ordering);
                }
                return query.execute();
            }
        });
    }

    public Collection find(Class entityClass, String filter, String parameters, Object[] values) throws DataAccessException {
        return this.find(entityClass, filter, parameters, values, null);
    }

    public Collection find(final Class entityClass, final String filter, final String parameters, final Object[] values, final String ordering) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                JdoTemplate.this.prepareQuery(query);
                query.declareParameters(parameters);
                if (ordering != null) {
                    query.setOrdering(ordering);
                }
                return query.executeWithArray(values);
            }
        });
    }

    public Collection find(Class entityClass, String filter, String parameters, Map values) throws DataAccessException {
        return this.find(entityClass, filter, parameters, values, null);
    }

    public Collection find(final Class entityClass, final String filter, final String parameters, final Map values, final String ordering) throws DataAccessException {
        return this.executeFind(new JdoCallback(){

            public Object doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                JdoTemplate.this.prepareQuery(query);
                query.declareParameters(parameters);
                if (ordering != null) {
                    query.setOrdering(ordering);
                }
                return query.executeWithMap(values);
            }
        });
    }

    public void prepareQuery(Query query) throws JDOException {
        PersistenceManagerFactoryUtils.applyTransactionTimeout(query, this.getPersistenceManagerFactory(), this.getJdoDialect());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private static final String PERSISTENCE_MANAGER_CLOSE_METHOD_NAME = "close";
        private final PersistenceManager target;

        public CloseSuppressingInvocationHandler(PersistenceManager target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals(PERSISTENCE_MANAGER_CLOSE_METHOD_NAME)) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    JdoTemplate.this.prepareQuery((Query)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

