/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.access;

import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import javax.ejb.EJBObject;
import javax.naming.NamingException;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.ejb.access.AbstractSlsbInvokerInterceptor;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;

public abstract class AbstractRemoteSlsbInvokerInterceptor
extends AbstractSlsbInvokerInterceptor {
    private boolean refreshHomeOnConnectFailure = false;

    public void setRefreshHomeOnConnectFailure(boolean refreshHomeOnConnectFailure) {
        this.refreshHomeOnConnectFailure = refreshHomeOnConnectFailure;
    }

    protected boolean isHomeRefreshable() {
        return this.refreshHomeOnConnectFailure;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.doInvoke(invocation);
        }
        catch (RemoteConnectFailureException ex) {
            return this.handleRemoteConnectFailure(invocation, ex);
        }
        catch (RemoteException ex) {
            if (this.isConnectFailure(ex)) {
                return this.handleRemoteConnectFailure(invocation, ex);
            }
            throw ex;
        }
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return RmiClientInterceptorUtils.isConnectFailure(ex);
    }

    private Object handleRemoteConnectFailure(MethodInvocation invocation, Exception ex) throws Throwable {
        if (this.refreshHomeOnConnectFailure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying"), (Throwable)ex);
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not connect to remote EJB [" + this.getJndiName() + "] - retrying"));
            }
            return this.refreshAndRetry(invocation);
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object refreshAndRetry(MethodInvocation invocation) throws Throwable {
        AbstractRemoteSlsbInvokerInterceptor abstractRemoteSlsbInvokerInterceptor = this;
        synchronized (abstractRemoteSlsbInvokerInterceptor) {
            try {
                this.refreshHome();
            }
            catch (Throwable ex) {
                throw new RemoteLookupFailureException("Failed to locate remote EJB [" + this.getJndiName() + "]", ex);
            }
        }
        return this.doInvoke(invocation);
    }

    protected abstract Object doInvoke(MethodInvocation var1) throws Throwable;

    protected EJBObject newSessionBeanInstance() throws NamingException, InvocationTargetException {
        Object ejbInstance;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Trying to create reference to remote EJB");
        }
        if (!((ejbInstance = this.create()) instanceof EJBObject)) {
            throw new AspectException("EJB instance [" + ejbInstance + "] is not a remote SLSB");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Obtained reference to remote EJB: " + ejbInstance));
        }
        return (EJBObject)ejbInstance;
    }

    protected void removeSessionBeanInstance(EJBObject ejb) {
        if (ejb != null) {
            try {
                ejb.remove();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)"Could not invoke 'remove' on remote EJB proxy", ex);
            }
        }
    }
}

