/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.beans.PropertyEditorSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractPathResolvingPropertyEditor
extends PropertyEditorSupport {
    public static final String PLACEHOLDER_PREFIX = "${";
    public static final String PLACEHOLDER_SUFFIX = "}";
    protected static final Log logger = LogFactory.getLog((Class)(class$org$springframework$core$io$AbstractPathResolvingPropertyEditor == null ? (class$org$springframework$core$io$AbstractPathResolvingPropertyEditor = AbstractPathResolvingPropertyEditor.class$("org.springframework.core.io.AbstractPathResolvingPropertyEditor")) : class$org$springframework$core$io$AbstractPathResolvingPropertyEditor));
    static /* synthetic */ Class class$org$springframework$core$io$AbstractPathResolvingPropertyEditor;

    protected String resolvePath(String path) {
        StringBuffer buf = new StringBuffer(path);
        int startIndex = buf.indexOf(PLACEHOLDER_PREFIX);
        while (startIndex != -1) {
            int endIndex = buf.indexOf(PLACEHOLDER_SUFFIX, startIndex + PLACEHOLDER_PREFIX.length());
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + PLACEHOLDER_PREFIX.length(), endIndex);
                String propVal = System.getProperty(placeholder);
                if (propVal != null) {
                    buf.replace(startIndex, endIndex + PLACEHOLDER_SUFFIX.length(), propVal);
                    startIndex = buf.indexOf(PLACEHOLDER_PREFIX, startIndex + propVal.length());
                    continue;
                }
                logger.warn((Object)("Could not resolve placeholder '" + placeholder + "' in resource path [" + path + "] as system property"));
                startIndex = buf.indexOf(PLACEHOLDER_PREFIX, endIndex + PLACEHOLDER_SUFFIX.length());
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

