/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;

public abstract class PropertyResourceConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private Properties properties;
    private Resource[] locations;
    private boolean ignoreResourceNotFound = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setLocation(Resource location) {
        this.locations = new Resource[]{location};
    }

    public void setLocations(Resource[] locations) {
        this.locations = locations;
    }

    public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
        this.ignoreResourceNotFound = ignoreResourceNotFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        Properties mergedProps = new Properties();
        if (this.properties != null) {
            Enumeration<?> enumeration = this.properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                mergedProps.setProperty(key, this.properties.getProperty(key));
            }
        }
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                Resource location = this.locations[i];
                this.logger.info((Object)("Loading properties from " + location + ""));
                try {
                    InputStream is = location.getInputStream();
                    try {
                        mergedProps.load(is);
                        continue;
                    }
                    finally {
                        is.close();
                    }
                }
                catch (IOException ex) {
                    String msg = "Could not load properties from " + location;
                    if (this.ignoreResourceNotFound) {
                        this.logger.warn((Object)(msg + ": " + ex.getMessage()));
                        continue;
                    }
                    throw new BeanInitializationException(msg, ex);
                }
            }
        }
        this.processProperties(beanFactory, mergedProps);
    }

    protected abstract void processProperties(ConfigurableListableBeanFactory var1, Properties var2) throws BeansException;
}

