/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.OrderComparator;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.servlet.FrameworkServlet;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.throwaway.ThrowawayControllerHandlerAdapter;
import org.springframework.web.servlet.theme.FixedThemeResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class DispatcherServlet
extends FrameworkServlet {
    public static final String MULTIPART_RESOLVER_BEAN_NAME = "multipartResolver";
    public static final String LOCALE_RESOLVER_BEAN_NAME = "localeResolver";
    public static final String THEME_RESOLVER_BEAN_NAME = "themeResolver";
    public static final String HANDLER_MAPPING_BEAN_NAME = "handlerMapping";
    public static final String HANDLER_EXCEPTION_RESOLVER_BEAN_NAME = "handlerExceptionResolver";
    public static final String VIEW_RESOLVER_BEAN_NAME = "viewResolver";
    public static final String WEB_APPLICATION_CONTEXT_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".CONTEXT";
    public static final String MULTIPART_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".MULTIPART";
    public static final String LOCALE_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".LOCALE";
    public static final String THEME_RESOLVER_ATTRIBUTE = (class$org$springframework$web$servlet$DispatcherServlet == null ? (class$org$springframework$web$servlet$DispatcherServlet = DispatcherServlet.class$("org.springframework.web.servlet.DispatcherServlet")) : class$org$springframework$web$servlet$DispatcherServlet).getName() + ".THEME";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private boolean detectAllHandlerMappings = true;
    private boolean detectAllHandlerExceptionResolvers = true;
    private boolean detectAllViewResolvers = true;
    private MultipartResolver multipartResolver;
    private LocaleResolver localeResolver;
    private ThemeResolver themeResolver;
    private List handlerMappings;
    private List handlerAdapters;
    private List handlerExceptionResolvers;
    private List viewResolvers;
    static /* synthetic */ Class class$org$springframework$web$servlet$DispatcherServlet;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerMapping;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerAdapter;
    static /* synthetic */ Class class$org$springframework$web$servlet$HandlerExceptionResolver;
    static /* synthetic */ Class class$org$springframework$web$servlet$ViewResolver;

    public void setDetectAllHandlerMappings(boolean detectAllHandlerMappings) {
        this.detectAllHandlerMappings = detectAllHandlerMappings;
    }

    public void setDetectAllHandlerExceptionResolvers(boolean detectAllHandlerExceptionResolvers) {
        this.detectAllHandlerExceptionResolvers = detectAllHandlerExceptionResolvers;
    }

    public void setDetectAllViewResolvers(boolean detectAllViewResolvers) {
        this.detectAllViewResolvers = detectAllViewResolvers;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
        this.initMultipartResolver();
        this.initLocaleResolver();
        this.initThemeResolver();
        this.initHandlerMappings();
        this.initHandlerAdapters();
        this.initHandlerExceptionResolvers();
        this.initViewResolvers();
    }

    private void initMultipartResolver() throws BeansException {
        try {
            this.multipartResolver = (MultipartResolver)this.getWebApplicationContext().getBean(MULTIPART_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Using MultipartResolver [" + this.multipartResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.multipartResolver = null;
            this.logger.info((Object)"Unable to locate MultipartResolver with name [multipartResolver]: no multipart handling provided");
        }
    }

    private void initLocaleResolver() throws BeansException {
        try {
            this.localeResolver = (LocaleResolver)this.getWebApplicationContext().getBean(LOCALE_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Using LocaleResolver [" + this.localeResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.localeResolver = new AcceptHeaderLocaleResolver();
            this.logger.info((Object)("Unable to locate LocaleResolver with name 'localeResolver': using default [" + this.localeResolver + "]"));
        }
    }

    private void initThemeResolver() throws BeansException {
        try {
            this.themeResolver = (ThemeResolver)this.getWebApplicationContext().getBean(THEME_RESOLVER_BEAN_NAME);
            this.logger.info((Object)("Using ThemeResolver [" + this.themeResolver + "]"));
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.themeResolver = new FixedThemeResolver();
            this.logger.info((Object)("Unable to locate ThemeResolver with name 'themeResolver': using default [" + this.themeResolver + "]"));
        }
    }

    private void initHandlerMappings() throws BeansException {
        this.handlerMappings = new ArrayList();
        if (this.detectAllHandlerMappings) {
            Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$HandlerMapping == null ? (class$org$springframework$web$servlet$HandlerMapping = DispatcherServlet.class$("org.springframework.web.servlet.HandlerMapping")) : class$org$springframework$web$servlet$HandlerMapping, true, false);
            this.handlerMappings = new ArrayList(matchingBeans.values());
            Collections.sort(this.handlerMappings, new OrderComparator());
        } else {
            try {
                Object vr = this.getWebApplicationContext().getBean(HANDLER_MAPPING_BEAN_NAME);
                this.handlerMappings.add(vr);
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
        }
        if (this.handlerMappings.isEmpty()) {
            BeanNameUrlHandlerMapping hm = new BeanNameUrlHandlerMapping();
            hm.setApplicationContext(this.getWebApplicationContext());
            this.handlerMappings.add(hm);
            this.logger.info((Object)("No HandlerMappings found in servlet '" + this.getServletName() + "': using default"));
        }
    }

    private void initHandlerAdapters() throws BeansException {
        Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$HandlerAdapter == null ? (class$org$springframework$web$servlet$HandlerAdapter = DispatcherServlet.class$("org.springframework.web.servlet.HandlerAdapter")) : class$org$springframework$web$servlet$HandlerAdapter, true, false);
        this.handlerAdapters = new ArrayList(matchingBeans.values());
        if (this.handlerAdapters.isEmpty()) {
            this.handlerAdapters.add(new SimpleControllerHandlerAdapter());
            this.handlerAdapters.add(new ThrowawayControllerHandlerAdapter());
            this.logger.info((Object)("No HandlerAdapters found in servlet '" + this.getServletName() + "': using default"));
        } else {
            Collections.sort(this.handlerAdapters, new OrderComparator());
        }
    }

    private void initHandlerExceptionResolvers() throws BeansException {
        this.handlerExceptionResolvers = new ArrayList();
        if (this.detectAllHandlerExceptionResolvers) {
            Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$HandlerExceptionResolver == null ? (class$org$springframework$web$servlet$HandlerExceptionResolver = DispatcherServlet.class$("org.springframework.web.servlet.HandlerExceptionResolver")) : class$org$springframework$web$servlet$HandlerExceptionResolver, true, false);
            this.handlerExceptionResolvers = new ArrayList(matchingBeans.values());
            Collections.sort(this.handlerExceptionResolvers, new OrderComparator());
        } else {
            try {
                Object her = this.getWebApplicationContext().getBean(HANDLER_EXCEPTION_RESOLVER_BEAN_NAME);
                this.handlerExceptionResolvers.add(her);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
    }

    private void initViewResolvers() throws BeansException {
        Object vr;
        this.viewResolvers = new ArrayList();
        if (this.detectAllViewResolvers) {
            Map matchingBeans = this.getWebApplicationContext().getBeansOfType(class$org$springframework$web$servlet$ViewResolver == null ? (class$org$springframework$web$servlet$ViewResolver = DispatcherServlet.class$("org.springframework.web.servlet.ViewResolver")) : class$org$springframework$web$servlet$ViewResolver, true, false);
            this.viewResolvers.addAll(matchingBeans.values());
            Collections.sort(this.viewResolvers, new OrderComparator());
        } else {
            try {
                vr = this.getWebApplicationContext().getBean(VIEW_RESOLVER_BEAN_NAME);
                this.viewResolvers.add(vr);
            }
            catch (NoSuchBeanDefinitionException ex) {
                // empty catch block
            }
        }
        if (this.viewResolvers.isEmpty()) {
            vr = new InternalResourceViewResolver();
            ((ApplicationObjectSupport)vr).setApplicationContext(this.getWebApplicationContext());
            this.viewResolvers.add(vr);
            this.logger.info((Object)("No ViewResolvers found in servlet '" + this.getServletName() + "': using default"));
        }
    }

    /*
     * Exception decompiling
     */
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            HandlerExecutionChain mappedHandler = this.getHandler(request);
            if (mappedHandler == null || mappedHandler.getHandler() == null) {
                this.logger.debug((Object)"No handler found in getLastModified");
                return -1L;
            }
            HandlerAdapter ha = this.getHandlerAdapter(mappedHandler.getHandler());
            long lastModified = ha.getLastModified(request, mappedHandler.getHandler());
            this.logger.debug((Object)("Last-Modified value for [" + request.getRequestURI() + "] is [" + lastModified + "]"));
            return lastModified;
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Exception thrown in getLastModified", (Throwable)ex);
            return -1L;
        }
    }

    private HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        Iterator itr = this.handlerMappings.iterator();
        while (itr.hasNext()) {
            HandlerMapping hm = (HandlerMapping)itr.next();
            this.logger.debug((Object)("Testing handler map [" + hm + "] in DispatcherServlet with name '" + this.getServletName() + "'"));
            HandlerExecutionChain handler = hm.getHandler(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    private HandlerAdapter getHandlerAdapter(Object handler) throws ServletException {
        Iterator itr = this.handlerAdapters.iterator();
        while (itr.hasNext()) {
            HandlerAdapter ha = (HandlerAdapter)itr.next();
            this.logger.debug((Object)("Testing handler adapter [" + ha + "]"));
            if (!ha.supports(handler)) continue;
            return ha;
        }
        throw new ServletException("No adapter for handler [" + handler + "]: Does your handler implement a supported interface like Controller?");
    }

    private void render(ModelAndView mv, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        View view = null;
        if (mv.isReference()) {
            Iterator it = this.viewResolvers.iterator();
            while (it.hasNext() && view == null) {
                ViewResolver viewResolver = (ViewResolver)it.next();
                view = viewResolver.resolveViewName(mv.getViewName(), locale);
            }
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + mv.getViewName() + "' in servlet with name '" + this.getServletName() + "'");
            }
        } else {
            view = mv.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + mv + "] neither contains a view name nor a View object " + " in servlet with name '" + this.getServletName() + "'");
            }
        }
        view.render(mv.getModel(), request, response);
    }

    private void triggerAfterCompletion(HandlerExecutionChain mappedHandler, int interceptorIndex, HttpServletRequest request, HttpServletResponse response, Exception ex) throws Exception {
        Exception currEx = ex;
        if (mappedHandler != null && mappedHandler.getInterceptors() != null) {
            for (int i = interceptorIndex; i >= 0; --i) {
                HandlerInterceptor interceptor = mappedHandler.getInterceptors()[i];
                try {
                    interceptor.afterCompletion(request, response, mappedHandler.getHandler(), ex);
                    continue;
                }
                catch (Exception ex2) {
                    if (currEx != null) {
                        this.logger.error((Object)"Exception overridden by HandlerInterceptor.afterCompletion exception", (Throwable)currEx);
                    }
                    currEx = ex2;
                }
            }
        }
        if (currEx != null) {
            throw currEx;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

