/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo.support;

import java.io.IOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.orm.jdo.PersistenceManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class OpenPersistenceManagerInViewFilter
extends OncePerRequestFilter {
    public static final String DEFAULT_PERSISTENCE_MANAGER_FACTORY_BEAN_NAME = "persistenceManagerFactory";
    private String persistenceManagerFactoryBeanName = "persistenceManagerFactory";

    public void setPersistenceManagerFactoryBeanName(String persistenceManagerFactoryBeanName) {
        this.persistenceManagerFactoryBeanName = persistenceManagerFactoryBeanName;
    }

    protected String getPersistenceManagerFactoryBeanName() {
        return this.persistenceManagerFactoryBeanName;
    }

    protected String getAlreadyFilteredAttributeName() {
        return this.getClass().getName() + "." + this.persistenceManagerFactoryBeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        PersistenceManagerFactory pmf = this.lookupPersistenceManagerFactory();
        this.logger.debug((Object)"Opening JDO persistence manager in OpenPersistenceManagerInViewFilter");
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(pmf, true);
        TransactionSynchronizationManager.bindResource(pmf, new PersistenceManagerHolder(pm));
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            TransactionSynchronizationManager.unbindResource(pmf);
            this.logger.debug((Object)"Closing JDO persistence manager in OpenPersistenceManagerInViewFilter");
            PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, pmf);
            throw throwable;
        }
        TransactionSynchronizationManager.unbindResource(pmf);
        this.logger.debug((Object)"Closing JDO persistence manager in OpenPersistenceManagerInViewFilter");
        PersistenceManagerFactoryUtils.closePersistenceManagerIfNecessary(pm, pmf);
    }

    protected PersistenceManagerFactory lookupPersistenceManagerFactory() {
        this.logger.info((Object)("Using persistence manager factory '" + this.getPersistenceManagerFactoryBeanName() + "' for OpenPersistenceManagerInViewFilter"));
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext(this.getServletContext());
        return (PersistenceManagerFactory)wac.getBean(this.getPersistenceManagerFactoryBeanName());
    }
}

