/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.nativejdbc;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingResultSet;
import org.apache.commons.dbcp.DelegatingStatement;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractorAdapter;

public class CommonsDbcpNativeJdbcExtractor
extends NativeJdbcExtractorAdapter {
    private static final String GET_INNERMOST_DELEGATE_METHOD_NAME = "getInnermostDelegate";

    protected Connection doGetNativeConnection(Connection con) throws SQLException {
        if (con instanceof DelegatingConnection) {
            Connection nativeCon = ((DelegatingConnection)con).getInnermostDelegate();
            return nativeCon != null ? nativeCon : con.getMetaData().getConnection();
        }
        return con;
    }

    public Statement getNativeStatement(Statement stmt) throws SQLException {
        if (stmt instanceof DelegatingStatement) {
            return ((DelegatingStatement)stmt).getInnermostDelegate();
        }
        return stmt;
    }

    public PreparedStatement getNativePreparedStatement(PreparedStatement ps) throws SQLException {
        if (ps instanceof DelegatingPreparedStatement) {
            try {
                Method getInnermostDelegate = ps.getClass().getMethod(GET_INNERMOST_DELEGATE_METHOD_NAME, null);
                return (PreparedStatement)getInnermostDelegate.invoke((Object)ps, null);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not retrieve innermost delegate", ex);
            }
        }
        return ps;
    }

    public CallableStatement getNativeCallableStatement(CallableStatement cs) throws SQLException {
        if (cs instanceof DelegatingCallableStatement) {
            try {
                Method getInnermostDelegate = cs.getClass().getMethod(GET_INNERMOST_DELEGATE_METHOD_NAME, null);
                return (CallableStatement)getInnermostDelegate.invoke((Object)cs, null);
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not retrieve innermost delegate", ex);
            }
        }
        return cs;
    }

    public ResultSet getNativeResultSet(ResultSet rs) throws SQLException {
        if (rs instanceof DelegatingResultSet) {
            return ((DelegatingResultSet)rs).getInnermostDelegate();
        }
        return rs;
    }
}

