/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionHolder;
import org.springframework.core.Constants;
import org.springframework.util.ObjectUtils;

public class PropertyPlaceholderConfigurer
extends PropertyResourceConfigurer {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    private static final Constants constants = new Constants(class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer == null ? (class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer = PropertyPlaceholderConfigurer.class$("org.springframework.beans.factory.config.PropertyPlaceholderConfigurer")) : class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer);
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private int systemPropertiesMode = 1;
    private boolean ignoreUnresolvablePlaceholders = false;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer;

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSystemPropertiesMode(int systemPropertiesMode) {
        this.systemPropertiesMode = systemPropertiesMode;
    }

    public void setSystemPropertiesModeName(String constantName) throws IllegalArgumentException {
        this.systemPropertiesMode = constants.asNumber(constantName).intValue();
    }

    public void setIgnoreUnresolvablePlaceholders(boolean ignoreUnresolvablePlaceholders) {
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) throws BeansException {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition bd = beanFactory.getBeanDefinition(beanNames[i]);
            try {
                this.parseBeanDefinition(props, bd);
                continue;
            }
            catch (BeanDefinitionStoreException ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanNames[i], ex.getMessage());
            }
        }
    }

    protected void parseBeanDefinition(Properties props, BeanDefinition beanDefinition) {
        ConstructorArgumentValues cas;
        MutablePropertyValues pvs = beanDefinition.getPropertyValues();
        if (pvs != null) {
            this.parsePropertyValues(props, pvs);
        }
        if ((cas = beanDefinition.getConstructorArgumentValues()) != null) {
            this.parseIndexedArgumentValues(props, cas.getIndexedArgumentValues());
            this.parseGenericArgumentValues(props, cas.getGenericArgumentValues());
        }
    }

    protected void parsePropertyValues(Properties props, MutablePropertyValues pvs) {
        for (int j = 0; j < pvs.getPropertyValues().length; ++j) {
            PropertyValue pv = pvs.getPropertyValues()[j];
            Object newVal = this.parseValue(props, pv.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, pv.getValue())) continue;
            pvs.addPropertyValue(pv.getName(), newVal);
        }
    }

    protected void parseIndexedArgumentValues(Properties props, Map ias) {
        Iterator it = ias.keySet().iterator();
        while (it.hasNext()) {
            Integer index = (Integer)it.next();
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)ias.get(index);
            Object newVal = this.parseValue(props, valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected void parseGenericArgumentValues(Properties props, Set gas) {
        Iterator it = gas.iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)it.next();
            Object newVal = this.parseValue(props, valueHolder.getValue());
            if (ObjectUtils.nullSafeEquals(newVal, valueHolder.getValue())) continue;
            valueHolder.setValue(newVal);
        }
    }

    protected Object parseValue(Properties props, Object value) {
        if (value instanceof String) {
            return this.parseString(props, (String)value, null);
        }
        if (value instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref = (RuntimeBeanReference)value;
            String newBeanName = this.parseString(props, ref.getBeanName(), null);
            if (!newBeanName.equals(ref.getBeanName())) {
                return new RuntimeBeanReference(newBeanName);
            }
        } else if (value instanceof List) {
            this.parseList(props, (List)value);
        } else if (value instanceof Set) {
            this.parseSet(props, (Set)value);
        } else if (value instanceof Map) {
            this.parseMap(props, (Map)value);
        } else if (value instanceof BeanDefinition) {
            this.parseBeanDefinition(props, (BeanDefinition)value);
        } else if (value instanceof BeanDefinitionHolder) {
            this.parseBeanDefinition(props, ((BeanDefinitionHolder)value).getBeanDefinition());
        }
        return value;
    }

    protected void parseList(Properties props, List listVal) {
        for (int i = 0; i < listVal.size(); ++i) {
            Object elem = listVal.get(i);
            Object newVal = this.parseValue(props, elem);
            if (ObjectUtils.nullSafeEquals(newVal, elem)) continue;
            listVal.set(i, newVal);
        }
    }

    protected void parseSet(Properties props, Set setVal) {
        Iterator it = new HashSet(setVal).iterator();
        while (it.hasNext()) {
            Object elem = it.next();
            Object newVal = this.parseValue(props, elem);
            if (ObjectUtils.nullSafeEquals(newVal, elem)) continue;
            setVal.remove(elem);
            setVal.add(newVal);
        }
    }

    protected void parseMap(Properties props, Map mapVal) {
        Iterator it = new HashMap(mapVal).keySet().iterator();
        while (it.hasNext()) {
            Object newKey;
            Object key = it.next();
            boolean isNewKey = !ObjectUtils.nullSafeEquals(key, newKey = this.parseValue(props, key));
            Object val = mapVal.get(key);
            Object newVal = this.parseValue(props, val);
            if (isNewKey) {
                mapVal.remove(key);
            }
            if (!isNewKey && ObjectUtils.nullSafeEquals(newVal, val)) continue;
            mapVal.put(newKey, newVal);
        }
    }

    protected String parseString(Properties props, String strVal, String originalPlaceholder) throws BeansException {
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = strVal.indexOf(this.placeholderSuffix, startIndex + this.placeholderPrefix.length());
            if (endIndex != -1) {
                String placeholder = strVal.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholderToUse = null;
                if (originalPlaceholder != null) {
                    originalPlaceholderToUse = originalPlaceholder;
                    if (placeholder.equals(originalPlaceholder)) {
                        throw new BeanDefinitionStoreException("Circular placeholder reference '" + placeholder + "' in property definitions [" + props + "]");
                    }
                } else {
                    originalPlaceholderToUse = placeholder;
                }
                String propVal = null;
                if (this.systemPropertiesMode == 2) {
                    propVal = System.getProperty(placeholder);
                }
                if (propVal == null) {
                    propVal = this.resolvePlaceholder(placeholder, props);
                }
                if (propVal == null && this.systemPropertiesMode == 1) {
                    propVal = System.getProperty(placeholder);
                }
                if (propVal != null) {
                    propVal = this.parseString(props, propVal, originalPlaceholderToUse);
                    this.logger.debug((Object)("Resolving placeholder '" + placeholder + "' to [" + propVal + "]"));
                    strVal = strVal.substring(0, startIndex) + propVal + strVal.substring(endIndex + 1);
                    startIndex = strVal.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                    continue;
                }
                if (this.ignoreUnresolvablePlaceholders) {
                    return strVal;
                }
                throw new BeanDefinitionStoreException("Could not resolve placeholder '" + placeholder + "'");
            }
            startIndex = -1;
        }
        return strVal;
    }

    protected String resolvePlaceholder(String placeholder, Properties props) {
        return props.getProperty(placeholder);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

