/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.jaxrpc.LocalJaxRpcServiceFactory;

public class JaxRpcPortClientInterceptor
extends LocalJaxRpcServiceFactory
implements MethodInterceptor,
InitializingBean {
    private Service jaxRpcService;
    private String portName;
    private String username;
    private String password;
    private String endpointAddress;
    private boolean maintainSession;
    private Properties customProperties;
    private Class serviceInterface;
    private Class portInterface;
    private QName portQName;
    private Remote portProxy;
    static /* synthetic */ Class class$java$rmi$Remote;
    static /* synthetic */ Class class$java$rmi$RemoteException;

    public void setJaxRpcService(Service jaxRpcService) {
        this.jaxRpcService = jaxRpcService;
    }

    public Service getJaxRpcService() {
        return this.jaxRpcService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
    }

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("serviceInterface must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setPortInterface(Class portInterface) {
        if (!(portInterface == null || portInterface.isInterface() && (class$java$rmi$Remote == null ? (class$java$rmi$Remote = JaxRpcPortClientInterceptor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(portInterface))) {
            throw new IllegalArgumentException("portInterface must be an interface derived from java.rmi.Remote");
        }
        this.portInterface = portInterface;
    }

    public Class getPortInterface() {
        return this.portInterface;
    }

    public void afterPropertiesSet() throws ServiceException {
        if (this.portName == null) {
            throw new IllegalArgumentException("portName is required");
        }
        if (this.jaxRpcService == null) {
            this.jaxRpcService = this.createJaxRpcService();
            this.postProcessJaxRpcService(this.jaxRpcService);
        }
        this.portQName = this.getQName(this.portName);
        Class actualInterface = this.portInterface != null ? this.portInterface : this.getServiceInterface();
        Remote remoteObj = this.jaxRpcService.getPort(this.portQName, actualInterface);
        if (this.getServiceInterface() != null) {
            boolean isImpl = this.getServiceInterface().isInstance(remoteObj);
            this.logger.info((Object)("Using service interface [" + this.getServiceInterface().getName() + "] for JAX-RPC object [" + this.portQName + "] - " + (!isImpl ? "not" : "") + " directly implemented"));
        }
        Stub stub = (Stub)remoteObj;
        if (this.username != null) {
            stub._setProperty("javax.xml.rpc.security.auth.username", (Object)this.username);
        }
        if (this.password != null) {
            stub._setProperty("javax.xml.rpc.security.auth.password", (Object)this.password);
        }
        if (this.endpointAddress != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.endpointAddress);
        }
        if (this.maintainSession) {
            stub._setProperty("javax.xml.rpc.session.maintain", (Object)new Boolean(this.maintainSession));
        }
        if (this.customProperties != null) {
            Iterator<Object> it = this.customProperties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                stub._setProperty(key, (Object)this.customProperties.getProperty(key));
            }
        }
        this.portProxy = remoteObj;
        this.postProcessPortProxy(this.portProxy);
    }

    protected void postProcessJaxRpcService(Service service) {
    }

    protected void postProcessPortProxy(Remote portProxy) {
    }

    public Remote getPortProxy() {
        return this.portProxy;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            Method method = invocation.getMethod();
            if (method.getDeclaringClass().isInstance(this.portProxy)) {
                return method.invoke((Object)this.portProxy, invocation.getArguments());
            }
            Method proxyMethod = this.portProxy.getClass().getMethod(method.getName(), method.getParameterTypes());
            return proxyMethod.invoke((Object)this.portProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            Throwable targetException = ex.getTargetException();
            this.logger.debug((Object)("JAX-RPC method of service [" + this.portQName + "] threw exception"), targetException);
            if (targetException instanceof RemoteException && !Arrays.asList(invocation.getMethod().getExceptionTypes()).contains(class$java$rmi$RemoteException == null ? (class$java$rmi$RemoteException = JaxRpcPortClientInterceptor.class$("java.rmi.RemoteException")) : class$java$rmi$RemoteException)) {
                throw new RemoteAccessException("Cannot access JAX-RPC service [" + this.portQName + "]", targetException);
            }
            throw targetException;
        }
        catch (RuntimeException ex) {
            throw new RemoteAccessException("Failed to invoke JAX-RPC service [" + this.portQName + "]", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

