/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ParameterMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;

public class CallableStatementCreatorFactory {
    private final String callString;
    private List declaredParameters = new LinkedList();
    private int resultSetType = 1003;
    private boolean updatableResults = false;

    public CallableStatementCreatorFactory(String callString) {
        this.callString = callString;
    }

    public CallableStatementCreatorFactory(String callString, List declaredParameters) {
        this.callString = callString;
        this.declaredParameters = declaredParameters;
    }

    public void addParameter(SqlParameter param) {
        this.declaredParameters.add(param);
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setUpdatableResults(boolean updatableResults) {
        this.updatableResults = updatableResults;
    }

    public CallableStatementCreator newCallableStatementCreator(Map inParams) {
        return new CallableStatementCreatorImpl(inParams != null ? inParams : new HashMap());
    }

    public CallableStatementCreator newCallableStatementCreator(ParameterMapper inParamMapper) {
        return new CallableStatementCreatorImpl(inParamMapper);
    }

    private class CallableStatementCreatorImpl
    implements CallableStatementCreator,
    SqlProvider {
        private Map inParameters;
        private ParameterMapper inParameterMapper;

        private CallableStatementCreatorImpl(Map inParams) {
            this.inParameters = inParams;
            this.inParameterMapper = null;
        }

        private CallableStatementCreatorImpl(ParameterMapper inParamMapper) {
            this.inParameters = null;
            this.inParameterMapper = inParamMapper;
        }

        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            if (this.inParameterMapper != null) {
                this.inParameters = this.inParameterMapper.createMap(con);
            } else if (this.inParameters == null) {
                throw new InvalidDataAccessApiUsageException("A ParameterMapper or a Map of parameters must be provided");
            }
            CallableStatement cs = null;
            cs = CallableStatementCreatorFactory.this.resultSetType == 1003 && !CallableStatementCreatorFactory.this.updatableResults ? con.prepareCall(CallableStatementCreatorFactory.this.callString) : con.prepareCall(CallableStatementCreatorFactory.this.callString, CallableStatementCreatorFactory.this.resultSetType, CallableStatementCreatorFactory.this.updatableResults ? 1008 : 1007);
            int sqlColIndx = 1;
            for (int i = 0; i < CallableStatementCreatorFactory.this.declaredParameters.size(); ++i) {
                SqlParameter p = (SqlParameter)CallableStatementCreatorFactory.this.declaredParameters.get(i);
                if (!(this.inParameters.containsKey(p.getName()) || p instanceof SqlOutParameter || p instanceof SqlReturnResultSet)) {
                    throw new InvalidDataAccessApiUsageException("Required input parameter '" + p.getName() + "' is missing");
                }
                Object in = this.inParameters.get(p.getName());
                if (!(p instanceof SqlOutParameter) && !(p instanceof SqlReturnResultSet)) {
                    if (in == null && p.getTypeName() != null) {
                        cs.setNull(sqlColIndx, p.getSqlType(), p.getTypeName());
                    } else if (in != null) {
                        cs.setObject(sqlColIndx, in, p.getSqlType());
                    } else {
                        cs.setNull(sqlColIndx, p.getSqlType());
                    }
                } else if (p instanceof SqlOutParameter) {
                    if (p.getTypeName() != null) {
                        cs.registerOutParameter(sqlColIndx, p.getSqlType(), p.getTypeName());
                    } else {
                        cs.registerOutParameter(sqlColIndx, p.getSqlType());
                    }
                    if (in != null) {
                        cs.setObject(sqlColIndx, in, p.getSqlType());
                    }
                }
                if (p instanceof SqlReturnResultSet) continue;
                ++sqlColIndx;
            }
            return cs;
        }

        public String getSql() {
            return CallableStatementCreatorFactory.this.callString;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("CallableStatementCreatorFactory.CallableStatementCreatorImpl: sql=[");
            buf.append(CallableStatementCreatorFactory.this.callString);
            buf.append("]: params=[");
            if (this.inParameters != null) {
                buf.append(this.inParameters.toString());
            }
            buf.append(']');
            return buf.toString();
        }
    }
}

