/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Date;
import org.springframework.util.ResponseTimeMonitor;

public class ResponseTimeMonitorImpl
implements ResponseTimeMonitor {
    private int accessCount;
    private long initedMillis;
    private int totalResponseTimeMillis = 0;
    private int bestResponseTimeMillis = Integer.MAX_VALUE;
    private int worstResponseTimeMillis = Integer.MIN_VALUE;

    public ResponseTimeMonitorImpl() {
        this.initedMillis = System.currentTimeMillis();
    }

    public final int getAccessCount() {
        return this.accessCount;
    }

    public final long getUptime() {
        return System.currentTimeMillis() - this.initedMillis;
    }

    public final Date getLoadDate() {
        return new Date(this.initedMillis);
    }

    public final int getAverageResponseTimeMillis() {
        if (this.getAccessCount() == 0) {
            return 0;
        }
        return this.totalResponseTimeMillis / this.getAccessCount();
    }

    public final int getBestResponseTimeMillis() {
        return this.bestResponseTimeMillis;
    }

    public final int getWorstResponseTimeMillis() {
        return this.worstResponseTimeMillis;
    }

    public final void recordResponseTime(long responseTime) {
        ++this.accessCount;
        int iResponseTime = (int)responseTime;
        this.totalResponseTimeMillis += iResponseTime;
        if (iResponseTime < this.bestResponseTimeMillis) {
            this.bestResponseTimeMillis = iResponseTime;
        }
        if (iResponseTime > this.worstResponseTimeMillis) {
            this.worstResponseTimeMillis = iResponseTime;
        }
    }

    public String toString() {
        return "hits=" + this.getAccessCount() + "; avg=" + this.getAverageResponseTimeMillis() + "; best=" + this.getBestResponseTimeMillis() + "; worst=" + this.getWorstResponseTimeMillis();
    }
}

