/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.context.support.AbstractNestingMessageSource;
import org.springframework.util.StringUtils;

public class ResourceBundleMessageSource
extends AbstractNestingMessageSource {
    private String[] basenames;
    private final Map cachedMessageFormats = new HashMap();

    public void setBasename(String basename) {
        this.setBasenames(new String[]{basename});
    }

    public void setBasenames(String[] basenames) {
        this.basenames = basenames;
    }

    protected final MessageFormat resolve(String code, Locale locale) {
        MessageFormat messageFormat = null;
        for (int i = 0; messageFormat == null && i < this.basenames.length; ++i) {
            messageFormat = this.resolve(this.basenames[i], code, locale);
        }
        return messageFormat;
    }

    protected MessageFormat resolve(String basename, String code, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, Thread.currentThread().getContextClassLoader());
            try {
                return this.getMessageFormat(bundle, code);
            }
            catch (MissingResourceException ex) {
                return null;
            }
        }
        catch (MissingResourceException ex) {
            this.logger.warn((Object)("ResourceBundle [" + basename + "] not found for MessageSource: " + ex.getMessage()));
            return null;
        }
    }

    protected synchronized MessageFormat getMessageFormat(ResourceBundle bundle, String code) throws MissingResourceException {
        MessageFormat result;
        HashMap<String, MessageFormat> codeMap = (HashMap<String, MessageFormat>)this.cachedMessageFormats.get(bundle);
        if (codeMap != null && (result = (MessageFormat)codeMap.get(code)) != null) {
            return result;
        }
        String msg = bundle.getString(code);
        if (msg != null) {
            MessageFormat result2 = new MessageFormat(msg);
            if (codeMap != null) {
                codeMap.put(code, result2);
            } else {
                codeMap = new HashMap<String, MessageFormat>();
                codeMap.put(code, result2);
                this.cachedMessageFormats.put(bundle, codeMap);
            }
            return result2;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + " with basenames [" + StringUtils.arrayToCommaDelimitedString(this.basenames) + "]";
    }
}

