/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessException;

public class PropertyAccessExceptionsException
extends BeansException {
    private List exceptions = new ArrayList();
    private BeanWrapper beanWrapper;

    PropertyAccessExceptionsException(BeanWrapper beanWrapper) {
        super("");
        this.beanWrapper = beanWrapper;
    }

    public BeanWrapper getBeanWrapper() {
        return this.beanWrapper;
    }

    public Object getBindObject() {
        return this.beanWrapper.getWrappedInstance();
    }

    public int getExceptionCount() {
        return this.exceptions.size();
    }

    public PropertyAccessException[] getPropertyAccessExceptions() {
        return this.exceptions.toArray(new PropertyAccessException[this.exceptions.size()]);
    }

    public PropertyAccessException getPropertyAccessException(String propertyName) {
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            PropertyAccessException pae = (PropertyAccessException)it.next();
            if (!propertyName.equals(pae.getPropertyChangeEvent().getPropertyName())) continue;
            return pae;
        }
        return null;
    }

    void addPropertyAccessException(PropertyAccessException ex) {
        this.exceptions.add(ex);
    }

    public void printStackTrace(PrintStream ps) {
        ps.println(this);
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            PropertyAccessException pae = (PropertyAccessException)it.next();
            pae.printStackTrace(ps);
        }
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println(this);
        Iterator it = this.exceptions.iterator();
        while (it.hasNext()) {
            PropertyAccessException pae = (PropertyAccessException)it.next();
            pae.printStackTrace(pw);
        }
    }

    public String toString() {
        return "PropertyAccessExceptionsException (" + this.getExceptionCount() + " errors)";
    }
}

